package learningproject;

/**
 * <p>Title: AgentePersona </p>
 * <p>Description: Agente che rappresenta la persona e che pu visualizzare
 * i propri attributi e inviarli ad altri agenti attraverso messaggi ACL.
* </p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.*;

public class AgentePersona extends Agent
{
  //Attributi
  private String nome;
  private String cognome;
  private Indirizzo indirizzo;
  private String e_mail;

  //Metodi per l'accesso agli attributi
   public void setNome(String nome)
   {
     this.nome = nome;
   }
   public void setCognome(String cognome)
   {
     this.cognome = cognome;
   }
   public void setIndirizzo(Indirizzo indirizzo)
   {
     this.indirizzo = indirizzo;
   }
   public void setEMail(String e_mail)
   {
     this.e_mail = e_mail;
   }
   public String getNome()
   {
     return nome;
   }
   public String getCognome()
     {
       return cognome;
     }
   public Indirizzo getIndirizzo()
   {
     return indirizzo;
   }
   public String getEMail()
   {
     return e_mail;
   }

   //Metodi per convertire la persona in stringa
   public String personaToStringNomeCognome()
   {
     String persona_stringa = "Nome:" +nome + "\n";
     persona_stringa += "Cognome: " + cognome + "\n";
     return persona_stringa;
   }
   public String personaToStringNomeCognomeEmail()
   {
     String persona_stringa = "Nome:" + nome + "\n";
     persona_stringa += "Cognome: " + cognome + "\n";
     persona_stringa += "Email: " + e_mail + "\n";
     return persona_stringa;
   }
   public String personaToStringCompleta()
   {
     String persona_stringa = "Nome:" + nome + "\n";
     persona_stringa += "Cognome: " + cognome + "\n";
     persona_stringa += "Indirizzo: " + indirizzo.indirizzoToString()
         + "\n";
     persona_stringa += "Email: " + e_mail + "\n";
     return persona_stringa;
   }


   //Inizializzazione agente Persona
   protected void setup()
   {
     //Recupero gli argomenti
     //PER SEMPLICITA' USO SOLO ALCUNI ARGOMENTI
     Object[] args = getArguments();
     if(args != null && args.length >0)
     {
       this.nome = (String)args[0];
       this.cognome = (String) args[1];
       this.e_mail = (String) args[2];
     }
     System.out.println(getAID().getName()+ ": pronto per l'esecuzione!!\n");

     //Visualizzazione dati
     VisualizzaDatiPersonaBehaviour visualizzaDati =
         new VisualizzaDatiPersonaBehaviour(this);
      addBehaviour(visualizzaDati);

    //Invio dati ad altri agenti
//  InviaACLDatiPersonaBehaviour inviaDati = new InviaACLDatiPersonaBehaviour();
//  addBehaviour(inviaDati);

    //Ricezione dei dati
//  RiceviACLDatiBehaviour riceviDati = new RiceviACLDatiBehaviour();
//  addBehaviour(riceviDati);
  }

  protected void takeDown()
  {
    System.out.println("AgentePersona "+getAID().getName()+" in terminazione");
  }
}


