package learningproject;

/**
 * <p>Title: AgenteDocente</p>
 * <p>Description: Agente che rappresenta il docente e che estende l'agente persona.
* Pu eseguire varie funzioni, come ad esempio,
* visualizzare il profilo di uno studente,
* creare nuovi quiz e nuovo materiale didattico,
* valutare i quiz e assegnare i voti agli studenti.
* </p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import java.util.*;

public class AgenteDocente extends AgentePersona
{
  //Attributi
  private String matricola;
  private Vector elencoCorsi;

  //Metodi per l'accesso agli attributi
  public void setMatricola(String matricola)
  {
    this.matricola = matricola;
  }
  //Inserimento di un corso nell'elenco
  public void insertCorso (Corso nuovo_corso)
  {
    if(!elencoCorsi.contains(nuovo_corso))
      elencoCorsi.add(nuovo_corso);
  }
  //Eliminazione di un corso dall'elenco
  public void deleteCorso (Corso vecchio_corso)
  {
    elencoCorsi.remove(vecchio_corso);
  }
  public String getMatricola()
  {
    return matricola;
  }
  public Vector getElencoCorsi()
  {
    return elencoCorsi;
  }


  //Inizializzazione agente
  protected void setup()
  {
    System.out.println(getAID().getName()+ ": pronto per l'esecuzione!\n");

    //Recupero gli argomenti
    //PER SEMPLICITA' USO SOLO ALCUNI PARAMETRI
    Object[] args = getArguments();
    if(args != null && args.length >0)
    {
      super.setNome((String)args[0]);
      super.setCognome((String)args[1]);
      super.setEMail((String)args[2]);
      this.matricola = (String)args[3];
    }

    //Visualizzare il profilo di uno studente
    //PER SEMPLICITA' LO STUDENTE DA VISUALIZZARE E' CREATO QUI
    Studente studenteDaVisualizzare = new Studente("Vincenzo","Da qui",
                                                   "vincequi@tin.it","326543",
                                                   "abile");
    addBehaviour(new VisualizzaDatiStudenteBehaviour(this,
        studenteDaVisualizzare));

    //Creare e inserire i quiz
    //DA IMPLEMENTARE
 // addBehaviour(new CreazioneQuizBehaviour());

    //Creare e inserire le letture per ogni corso
    //DA IMPLEMENTARE
 // addBehaviour(new CreazioneLetturaBehaviour());

    //Giudicare i quiz eseguiti da ogni studente e inviare la risposta
//  addBehaviour(new CorrezioneQuizBehaviour(this));


  }

  protected void takeDown()
  {
    System.out.println("AgenteDocente "+getAID().getName()+" in terminazione");
  }
}
