package learningproject;

/**
 * <p>Title: AgenteCorso/p>
 * <p>Description: Agente che rappresenta il corso e che mette a
* disposizione di studenti e docenti alcune funzioni, ad esempio Selezione Corso
* e Selezione Quiz, seguendo il modello delle Yellow Pages.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import java.util.*;
import jade.core.*;
import jade.domain.FIPAAgentManagement.*;
import jade.domain.*;

public class AgenteCorso extends Agent
{
  //Attributi
  private String nome;
  private String codice;
  private Vector materialeDidattico;
  private Vector elencoQuiz;
  private Vector learningStyle; //scritto, orale, progetto, altro
  private Docente docente;
  private String descrizione;
  private Vector elencoStudenti;
  private String difficolta;

//Metodi per accedere agli attributi privati
  public String getNome()
  {
    return nome;
  }
  public String getCodice()
  {
    return codice;
  }
  public Vector getMaterialeDidattico()
  {
  return materialeDidattico;
  }
  public Vector getElencoQuiz()
  {
  return elencoQuiz;
  }
  public Vector getLearningStyle()
  {
    return learningStyle;
  }
  public Docente getDocente()
  {
    return docente;
  }
  public String getDescrizione()
  {
    return descrizione;
  }
  public Vector getElencoStudenti()
  {
    return elencoStudenti;
  }
  public String getDifficolta()
  {
    return this.difficolta;
  }
  public void setNome(String nome)
  {
    this.nome = nome;
  }
  public void setCodice(String codice)
  {
    this.codice = codice;
  }
  //Inserimento di nuovo materiale
  //PER SEMPLICITA' IL MATERIALE DIDATTICO E' UNA STRINGA
  public void insertMaterialeDidattico (String nuova_lettura)
  {
    if (!materialeDidattico.contains(nuova_lettura))
        materialeDidattico.add(nuova_lettura);
   }
  //Eliminazione di materiale
  public void deleteMaterialeDidattico (String vecchia_lettura)
  {
    materialeDidattico.remove(vecchia_lettura);
  }
  //Inserimento di nuovo quiz nell'elenco
  public void insertQuiz (Quiz nuovo_quiz)
  {
      if (!elencoQuiz.contains(nuovo_quiz))
        elencoQuiz.add(nuovo_quiz);
  }
  //Eliminazione di quiz dall'elenco
  public void deleteQuiz (Quiz vecchio_quiz)
  {
      elencoQuiz.remove(vecchio_quiz);
  }
   //Inserimento di un nuovo learning style
  public void insertLearningStyle (String nuovo_learningStyle)
  {
      if (!learningStyle.contains(nuovo_learningStyle))
        learningStyle.add(nuovo_learningStyle);
  }
  //Eliminazione di learning style
  public void deleteLearningStyle (String vecchio_learningStyle)
  {
      learningStyle.remove(vecchio_learningStyle);
  }
  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }
  //Inserimento di nuovo studente
  public void insertStudente (Studente nuovo_studente)
  {
      if (!elencoStudenti.contains(nuovo_studente))
        elencoStudenti.add(nuovo_studente);
  }
  //Eliminazione di uno studente
  public void deleteStudente (Studente vecchio_studente)
  {
      elencoStudenti.removeElement(vecchio_studente);
  }
  public void setDocente(Docente docente)
  {
    this.docente = docente;
  }
  public void setDifficolta(String difficolta)
  {
    this.difficolta = difficolta;
  }


  //Inizializzazione agente
  protected void setup()
  {
    //Recupero gli argomenti
    //PER SEMPLICITA' USO SOLO ALCUNI PARAMETRI
    Object[] args = getArguments();
    if(args != null && args.length >0)
    {
      this.nome = (String) args[0];
      this.codice = (String) args[1];
      this.difficolta = (String) args[2];
    }
    System.out.println(getAID().getName()+ ": pronto per l'esecuzione!!\n");

    //Registrazione del corso nelle yellow pages
    DFAgentDescription dfagent = new DFAgentDescription();
    dfagent.setName(getAID());
    ServiceDescription servizio = new ServiceDescription();
    servizio.setType("Corsi");
    servizio.setName("Progetto Learning");
    dfagent.addServices(servizio);
    try
    {
      DFService.register(this,dfagent);
      System.out.println(getAID().getName()+": registrazione nelle yellow pages\n");
    }
    catch(FIPAException fe) {fe.printStackTrace(); }


    //Servizio di selezione del corso
    addBehaviour(new SelezioneCorsoBehaviour(this));
    addBehaviour(new ConfermaSceltaCorsoBehaviour(this));

    //Servizio di selezione dei quiz
  //addBehaviour(new SelezioneQuizBehaviour(this));
  //addBehaviour(new ConfermaSceltaQuizBehaviour(this));
  }

  //Operazioni di clean-up dell'agente
  protected void takeDown()
  {
    //Deregistrazione del servizio dalle yellow pages
    try
    {
      DFService.deregister(this);
    }
    catch(FIPAException fe){fe.printStackTrace(); }

    //Stampa messaggio di terminazione
    System.out.println("AgenteCorso "+getAID().getName()+"in terminazione.");
  }
}
