//CONTROLLARE IL COSTRUTTORE

//CONTROLLARE IL DTD
package learningproject;

/**
 * <p>Title: LetturaQuizXml</p>
 * <p>Description: In questa classe si esegue il parsing del file quiz.xml
* per recuperare i dati e mapparli in un oggetto Java.
* Il file xml deve rispettare una particolare struttura rappresentata dal DTD.
* L'uso del formato xml garantisca la portabilit.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import java.util.*;
import java.io.*;
import org.xml.sax.*;
import javax.xml.parsers.*;

public class LetturaQuizXml
{
  private String fileQuizXml;


  private String titolo = null; //Titolo del quiz
  private Date data = null; //Data creazione quiz
  private String argomento = null;
  private String domanda = null;
  private Vector choice = null;
  private String difficolta;

private Quiz quiz;

  //Costruttore
  public LetturaQuizXml(String fileQuizXml)
  {
    this.fileQuizXml = fileQuizXml;
  }

//Parsing (SAX) del documento xml indicato dalla Stringa nomeFile
  public void parsingXml ()
  {

    try
    {
      //Apertura file Xml
      BufferedReader buffer = new BufferedReader(new FileReader(fileQuizXml));
      InputSource input = new InputSource (buffer);

      //Invocazione handler necessario per il parsing del documento xml
      XmlParsingHandler handler = new XmlParsingHandler (quiz);

      //Creazione istanza parser SAX
      //L'istranza della classe SAXParser  ottenuta attraverso la craezione
      //di un'istanza della classe SAXParserFactory
      SAXParserFactory factory = SAXParserFactory.newInstance();
      factory.setNamespaceAware(true); //supporto per l'uso del namespaces
      SAXParser parser = factory.newSAXParser();
      parser.parse(input, handler);

    }
    catch (Exception e)//CONTROLLARE LA GESTIONE DELLE ECCEZIONI
    {
      System.err.println("Eccezione!");
    }
}


}
