//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.utils;

import java.util.*;
import java.beans.*;
import java.net.*;
import java.io.*;

import ants.p2p.*;
import ants.p2p.query.*;

import org.apache.log4j.*;

/**
 * Crawler that search the net in order to find the addressess of other
 * peers with free connection slots.
 */
public class InetAddressEngine extends Thread implements PropertyChangeListener{

  static Logger _logger = Logger.getLogger(InetAddressEngine.class.getName());

  public static int refreshRate = 120000;
  public static int peersToMemorize = 20;
  public static int peersToSendback = 3;
  public static int broadcastTimeToLive = 1000;
  public static InetAddressEngine instance = null;
  public static File trustedPeersFile = new File("trustedPeers.ant");
  boolean terminate = false;

  WarriorAnt warriorAnt;
  ArrayList peersWithFreeSlots = new ArrayList();
  static ArrayList trustedPeers = new ArrayList();

  static{
    if(trustedPeersFile.exists())
      InetAddressEngine.loadTrustedPeers();
  }

  public static InetAddressEngine getInstance(WarriorAnt owner){
    try{
      instance = new InetAddressEngine(owner);
      instance.setPriority(Thread.MIN_PRIORITY);
      instance.start();
      return instance;
    }catch (Exception ex) {
      _logger.error("",ex);
      return null;
    }
  }

  public static InetAddressEngine getInstance(){
    return instance;
  }

  public InetAddressEngine(WarriorAnt warriorAnt) {
    this.warriorAnt=warriorAnt;
    this.warriorAnt.propertyChangeSupport.addPropertyChangeListener(this);
  }

  public static boolean contains(int[] indexes, int val){
    for(int x = 0; x < indexes.length; x++){
      if(indexes[x]==val)
        return true;
    }
    return false;
  }

  public ArrayList getPeersWithFreeSlots(int howMany){
    int[] indexes = new int[this.peersToSendback];
    Arrays.fill(indexes,-1);
    for(int x = 0; x < this.peersToSendback && x < this.peersWithFreeSlots.size(); x++){
      int index = (int)Math.floor(Math.random()*this.peersWithFreeSlots.size());
      while(contains(indexes,index)){
        index = (int)Math.floor(Math.random()*this.peersWithFreeSlots.size());
      }
      indexes[x]=index;
    }
    ArrayList sendBack = new ArrayList();
    for(int x = 0; x < this.peersToSendback && x < this.peersWithFreeSlots.size(); x++){
      sendBack.add(this.peersWithFreeSlots.get(indexes[x]));
    }
    return sendBack;
  }

  public static ArrayList getTrustedPeers(){
    return trustedPeers;
  }

  private static void storeTrustedPeers(){
    try {
      ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(
          trustedPeersFile));
      oos.writeObject(trustedPeers);
      oos.close();
    }
    catch (IOException e) {
      _logger.error("Cannot store trusted peers", e);
    }
  }

  public static void loadTrustedPeers(){
    try {
      ObjectInputStream ois = new ObjectInputStream(new FileInputStream(trustedPeersFile));
      trustedPeers = (ArrayList) ois.readObject();
      ois.close();
    }catch (Exception e) {
      _logger.error("Cannot load trusted peers");
    }
  }

  public static void removeTrustedPeer(ServerInfo sInfo){
    trustedPeers.remove(sInfo);
    storeTrustedPeers();
  }

  public static void addTrustedPeer(InetAddress inetAddr, int port){
    ServerInfo sInfo = new ServerInfo("", inetAddr, new Integer(port), "");
    if(!trustedPeers.contains(sInfo)){
      trustedPeers.add(sInfo);
      storeTrustedPeers();
    }
  }

  public void run(){
    while(!terminate){
      try {
        _logger.info("Search...");
        warriorAnt.getServersWithFreeSlots(broadcastTimeToLive);
        sleep(refreshRate);
      }
      catch (Exception e) {
        _logger.error("",e);
      }
    }
    _logger.info("InetAddressEngine Terminated");
  }

  public void terminate(){
    this.terminate = true;
  }

  public void propertyChange(PropertyChangeEvent e){
    if (e.getPropertyName().equals("inetAddressQueryCompleted")) {
      ArrayList result = (ArrayList)e.getNewValue();
      if(result.size() > 0 && result.get(0) != null){
        if (!this.peersWithFreeSlots.contains(result.get(0))){
          this.peersWithFreeSlots.addAll(0, (ArrayList) e.getNewValue());
        }
        while(this.peersWithFreeSlots.size() > InetAddressEngine.peersToMemorize){
          this.peersWithFreeSlots.remove(this.peersWithFreeSlots.size()-1);
        }
      }
    }
  }
}