//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.utils;

import java.io.*;

public class FileInfos implements Serializable{
  String hash;
  long lastModified;
  String name;
  long size;

  public FileInfos(File f) throws Exception{
    if(!f.exists())
      throw new IOException("File not exists.");
    this.name=f.getAbsolutePath();
    DigestManager dm = new DigestManager();
    this.hash = dm.getDigest(f);
    this.lastModified = f.lastModified();
    this.size = f.length();
  }

  public long getLastModified(){
    return this.lastModified;
  }

  public String getName(){
    return this.name;
  }

  public String getHash(){
    return this.hash;
  }

  public long getSize() {
    return this.size;
  }

  public boolean equals(Object o){
    if(o instanceof FileInfos)
      return ((FileInfos)o).hash.equals(this.hash);
    else
      return this==o;
  }

  public String toString(){
    String result = this.getHash() + "          " + this.getName();
    while (result.length() < 150)
      result += ".";
    result += "  ";
    double dSize = this.getSize();
    int x = 0;
    while (dSize > 1 && x < 4) {
      dSize = dSize / Math.pow(2, 20);
      x++;
    }
    String suffix = " bytes";
    String size = this.getSize()+suffix;
    if (x == 2) {
      suffix = " Mb";
      size = (new Double(this.getSize() * 1.0 / Math.pow(2, 20))).
          toString();
      int index = size.indexOf(".");
      if (index >= 0)
        size = size.substring(0, index + 2);
      size += suffix;
    }
    if (x == 3) {
      suffix = " Gb";
      size = (new Double(this.getSize() * 1.0 / Math.pow(2, 30))).
          toString();
      int index = size.indexOf(".");
      if (index >= 0)
        size = size.substring(0, index + 2);
      size += suffix;
    }
    return result += " File Size: " + size;
  }
}