//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.utils;

import java.security.*;
import java.io.*;
import ants.p2p.utils.*;

import java.beans.*;
import java.util.*;

public class DigestManager {
  byte[] digest;
  private static final int megaByte = (int)Math.pow(2,20);
  public static final String hashName = "MD5";
  static long sizeToHash = 5*megaByte;
  File f;

  static ArrayList propertyChangeListeners = new ArrayList();

  public DigestManager(){
    for(int x = 0; x < propertyChangeListeners.size(); x++){
      this.propertyChangeSupport.addPropertyChangeListener((PropertyChangeListener)propertyChangeListeners.get(x));
    }
  }

  static void addPropertyChangeListener(PropertyChangeListener pcl){
    propertyChangeListeners.add(pcl);
  }

  static void removePropertyChangeListener(PropertyChangeListener pcl){
    propertyChangeListeners.remove(pcl);
  }

  public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

  private byte[] computeDigest(File f) throws Exception{
    this.f=f;
    MessageDigest md = MessageDigest.getInstance(hashName);
    FileInputStream fis = new FileInputStream(f);
    byte[] block;
    long index = 0;
    this.propertyChangeSupport.firePropertyChange("fileIndexingInProgress", f.getName(), new Integer(0));
    while (fis.available() > 0){ // && index < sizeToHash) {
      if (fis.available() >= 10 * megaByte)
        block = new byte[ (int) (10 * megaByte)];
      else
        block = new byte[fis.available()];
      index += fis.read(block);
      md.update(block);

      int progress = (int)Math.floor(((index*1.0)/f.length())*100);
      this.propertyChangeSupport.firePropertyChange("fileIndexingInProgress", f.getName(), new Integer(progress));
      Thread.currentThread().sleep(1000);
    }
    //String suffix = f.length()+"";
    //md.update(suffix.getBytes());
    return digest = md.digest();
  }

  public String getDigest(File f) throws Exception{
    if(digest!=null && f.equals(f))
      return Base16.toHexString(digest);
    else{
      this.computeDigest(f);
      return Base16.toHexString(digest);
    }
  }

  public String getDigest(String s) throws Exception{
    MessageDigest md = MessageDigest.getInstance("MD5");
    md.update(s.getBytes());
    byte[] dig = md.digest();
    return Base16.toHexString(dig);
  }

}