//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.utils;

import java.net.*;
import java.util.*;

import ants.p2p.*;

import org.apache.log4j.*;

/**
 * This thread allows other nodes not connected to the ANts net to find peers
 * address.
 */
public class AddressServer extends Thread{

  static Logger _logger = Logger.getLogger(AddressServer.class.getName());

  int localPort;
  WarriorAnt caller;
  ServerSocket serverSocket;

  public AddressServer(WarriorAnt caller) {
    localPort = caller.getServerPort()+1;
    this.caller = caller;
    InetAddressEngine.getInstance(caller);
    this.setPriority(Thread.MIN_PRIORITY);
    this.start();
  }

  public void terminate() {
    try {
      this.serverSocket.close();
    }
    catch (Exception e) {
      _logger.info("Address Server terminated");
      _logger.debug("Address Server terminated",e);
    }
  }

  public void run(){
    try{
      serverSocket = new ServerSocket(localPort);

      while (true) {
        _logger.info("Accepting addresses requests");
        Socket localSocket = serverSocket.accept();
        AddressServerThread serverThread = new AddressServerThread(localSocket);
        serverThread.start();
      }

    }
    catch (Exception e) {
      _logger.info("Address server stopped");
      _logger.error("Address server stopped",e);
    }
  }
}