//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.security.sockets;

import java.net.*;
import java.io.*;
import java.math.BigInteger;
import java.security.*;
import java.security.spec.*;
import java.security.interfaces.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import javax.crypto.interfaces.*;
import com.sun.crypto.provider.SunJCE;
import java.util.*;

import ants.p2p.*;

import org.apache.log4j.*;

public class SecureServerSocket extends ServerSocket implements Runnable{

  static Logger _logger = Logger.getLogger(SecureServerSocket.class.getName());

  public ArrayList threads = new ArrayList();
  public Thread serverThread;

  DHParameterSpec dhParamSpec;
  KeyPair serverKpair;
  KeyAgreement serverKeyAgree;
  byte[] serverPubKeyEnc;

  Ant n;

  public SecureServerSocket(Ant n, int port) throws IOException{
    super(port);
    this.n = n;
    try{
      serverThread = new Thread(this);
      serverThread.setPriority(Thread.MIN_PRIORITY);
      serverThread.start();
    }catch(Exception e){_logger.error("",e);}
  }

  public SecureServerSocket(Ant n, int port, int backlog) throws IOException,
      NoSuchAlgorithmException,
      InvalidParameterSpecException,
      InvalidAlgorithmParameterException,
      InvalidKeyException {
    super(port, backlog);
    this.n = n;
    serverThread = new Thread(this);
    serverThread.setPriority(Thread.MIN_PRIORITY);
    serverThread.start();
  }

  public SecureServerSocket(Ant n) throws IOException,
      NoSuchAlgorithmException,
      InvalidParameterSpecException,
      InvalidAlgorithmParameterException,
      InvalidKeyException {
    super(4000);
     this.n = n;
    serverThread = new Thread(this);
    serverThread.setPriority(Thread.MIN_PRIORITY);
    serverThread.start();
  }

  private void loadDHParameter(){

  }

  public void listen() {
    try{
      while (!n.isDisconnected()) {
        _logger.info(n.getId()+" :Server Listening...");
        Socket localSocket = this.accept();
        if(localSocket != null){
          if(n.getNeighboursNumber() < n.getMaxNeighbours()){
            localSocket.setKeepAlive(true);
            SecureServerSocketThread serverSocketThread = new
                SecureServerSocketThread(localSocket);
            if(!localSocket.isClosed()){
              NeighbourAnt na = new NeighbourAnt(n,
                                                 localSocket.getInetAddress() +
                                                 "",
                                                 localSocket.getPort(),
                                                 serverSocketThread.
                                                 getRemoteServerPort(),
                                                 serverSocketThread.
                                                 getCipherEnc(),
                                                 serverSocketThread.
                                                 getCipherDec(),
                                                 serverSocketThread.getSocket(),
                                                 false);
              try{
                n.addNeighbour(na);
              }catch(Exception e){
                na.terminate();
                throw new Exception(e);
              }
              _logger.info(n.getId() + " :Server added neighbour...");
            }else{
              _logger.info(n.getId() + " :Rejected connection...");
            }
          }else{
            localSocket.close();
            _logger.info(n.getId() + " :Rejected neighbour...");
          }
        }
      }
    }
    catch (Exception e) {
      _logger.info("Secure Server Socket closed: "+this.getLocalPort()+" "+e.getMessage());
      _logger.debug("Secure Server Socket closed: "+this.getLocalPort(),e);
    }
  }

  public void run(){
    listen();
  }
}