//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.query.security;

import java.io.*;
import java.math.*;
import java.security.*;
import ants.p2p.utils.*;
import javax.crypto.*;
import javax.crypto.spec.*;

public class PublicHeader implements Serializable{
  String pq = null;
  String E = null;
  String sessionKey = null;
  String characternumbers = new String("ASCII representation");
  String characterbinary = new String("binary representation");
  String encryptednumbers = new String("encrypted numbers");
  String encryptedmessage = new String("Ciphertext");
  String binaryblocks = new String("binary blocks");
  String codeblocks = new String("code blocks");

  String s8 = new String("");

  public PublicHeader(String pq, String E){
    this.pq = pq;
    this.E = E;
  }

  PublicHeader(){
  }

  public void generateSessionKey(){
    byte[] sessionBytes = new byte[SimmetricProvider.cipherKeySize];
    SecureRandom sr = new SecureRandom();
    sr.nextBytes(sessionBytes);
    this.sessionKey = Base16.toHexString(sessionBytes);
  }

  public String getE(){
    return E;
  }

  public String getPQ(){
    return this.pq;
  }

  public String getBase64SessionKey() {
    return this.sessionKey;
  }

  public Cipher getEncCipher() throws Exception{
    SecretKeySpec skeySpec = new SecretKeySpec(Base16.fromHexString(sessionKey),
                                               SimmetricProvider.cipher);
    Cipher cipher = Cipher.getInstance(SimmetricProvider.cipher);
    cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
    return cipher;
  }

  private String encryptSessionKey(){
    String mymessage = new String(this.sessionKey);
    BigInteger biginteger6 = new BigInteger(E);
    BigInteger biginteger8 = new BigInteger(pq);
    characterbinary="";
    characternumbers="";
    encryptednumbers="";
    encryptedmessage="";
    binaryblocks="";
    codeblocks="";
    int k = 0;
    byte byte0 = 2;
    for(int i = 0; i < mymessage.length(); i++)
    {
        String s7 = mymessage;
        String s6 = s7.substring(i, i + 1);
        char c = s7.charAt(i);
        String s = Integer.toBinaryString(c);
        for(int l = s.length(); l < 8; l++)
            s = "0" + s;

        String s5 = (new Integer(c)).toString();
        characternumbers=characternumbers + s5 + "  ";
        characterbinary=characterbinary + s + " ";
        s8 = s8 + s;
        k++;
        if(k == byte0)
        {
            binaryblocks=binaryblocks + s8 + "   ";
            BigInteger biginteger10 = new BigInteger(s8, 2);
            codeblocks=codeblocks + biginteger10.toString() + "  ";
            BigInteger biginteger13 = biginteger10.modPow(biginteger6, biginteger8);
            String s2 = biginteger13.toString();
            encryptednumbers=encryptednumbers + s2 + " ";
            for(int i1 = 0; i1 < s2.length(); i1 += 2)
            {
                byte byte1;
                if(s2.length() - i1 > 1)
                    byte1 = 2;
                else
                    byte1 = 1;
                Integer integer = new Integer(s2.substring(i1, i1 + byte1));
                char c1 = (char)integer.intValue();
                encryptedmessage=encryptedmessage + c1;
            }

            k = 0;
            s8 = "";
        }
    }

    if(k > 0 && k < byte0)
    {
        for(int j1 = k; j1 < byte0; j1++)
            s8 = "00000000" + s8;

        binaryblocks=binaryblocks + s8 + "   ";
        BigInteger biginteger11 = new BigInteger(s8, 2);
        codeblocks=codeblocks + biginteger11.toString() + "  ";
        BigInteger biginteger14 = biginteger11.modPow(biginteger6, biginteger8);
        String s3 = biginteger14.toString();
        encryptednumbers=encryptednumbers + s3 + " ";
        for(int k1 = 0; k1 < s3.length(); k1 += 2)
        {
            byte byte2;
            if(s3.length() - k1 > 1)
                byte2 = 2;
            else
                byte2 = 1;
            Integer integer1 = new Integer(s3.substring(k1, k1 + byte2));
            char c2 = (char)integer1.intValue();
            encryptedmessage=encryptedmessage + c2;
        }
    }
    return Base16.toHexString(encryptednumbers.getBytes());
  }
}