//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.query.security;

import java.security.*;
import java.math.*;
import java.io.*;
import ants.p2p.utils.*;

public class MessageHeader extends PublicHeader implements Serializable{
  String p = null;
  String q = null;
  String D = null;
  String EDm1 = null;
  String numberstodecrypt = new String("");
  String decryptednumbers = new String("decrypted numbers");
  String decryptedmessage = new String("Plain Message");

  BigInteger biginteger = new BigInteger("1");

  public PublicHeader generatePublicHeader(){
    return new PublicHeader(this.pq,this.E);
  }

  public MessageHeader(int qSize, int pSize) throws Exception{
    java.util.Random rnd = new java.util.Random(System.currentTimeMillis());
    q = BigInteger.probablePrime(qSize,rnd).toString();
    p = BigInteger.probablePrime(pSize,rnd).toString();
    this.pq = (new BigInteger(p)).multiply(new BigInteger(q)).toString();
    BigInteger biginteger12 = new BigInteger(pq);
    BigInteger biginteger1 = new BigInteger(q);
    BigInteger biginteger3 = new BigInteger(p);
    BigInteger biginteger5 = biginteger1.subtract(biginteger);
    BigInteger biginteger7 = biginteger3.subtract(biginteger);
    BigInteger biginteger9 = biginteger5.multiply(biginteger7);
    if (!biginteger1.isProbablePrime(20)) {
      p = p + " not prime";
      throw new Exception("Error in creating keyPair");
    }
    if (!biginteger3.isProbablePrime(20)) {
      q = q + " not prime";
      throw new Exception("Error in creating keyPair");
    }
    pq = biginteger12.toString();
    BigInteger biginteger15 = biginteger.add(biginteger);
    BigInteger biginteger16 = biginteger.add(biginteger);
    for (BigInteger biginteger17 = new BigInteger("0");
         biginteger15.compareTo(biginteger12) < 0 &&
         biginteger17.intValue() != 1;
         biginteger17 = biginteger9.gcd(biginteger15))
      biginteger15 = biginteger15.add(biginteger);

    biginteger16 = biginteger15;
    E = biginteger16.toString();
    BigInteger biginteger19 = biginteger16.modInverse(biginteger9);
    D = biginteger19.toString();
    BigInteger biginteger21 = biginteger16.multiply(biginteger19);
    biginteger21 = biginteger21.subtract(biginteger);
    EDm1 = biginteger21.toString();
  }

  public String getP(){
    return this.p;
  }

  public String getQ(){
    return this.q;
  }

  public String getPQ(){
    return this.pq;
  }

  private MessageHeader(){}

  public String decryptSessionKey(String encryptedSessionKey) throws Exception{
    String keyString = this.generate(Base16.fromHexString(encryptedSessionKey));
    return keyString;
  }

  private String generate(byte[] header) throws Exception{
    BigInteger biginteger2 = new BigInteger(D);
    BigInteger biginteger4 = new BigInteger(pq);
    String s11 = new String(header);
    decryptednumbers="";
    decryptedmessage="";
    numberstodecrypt="";
    int i2;
    for(int j = 0; j < s11.length(); j = i2 + 1)
    {
        int l1 = j;
        i2 = s11.indexOf(' ', j);
        String s9 = s11.substring(l1, i2);
        BigInteger biginteger18 = new BigInteger(s9, 10);
        numberstodecrypt=numberstodecrypt + biginteger18.toString() + " ";
        BigInteger biginteger20 = biginteger18.modPow(biginteger2, biginteger4);
        String s4 = biginteger20.toString();
        decryptednumbers=decryptednumbers + s4 + " ";
        String s1 = Integer.toBinaryString(biginteger20.intValue());
        for(int j2 = s1.length(); j2 < 16; j2++)
            s1 = "0" + s1;

        decryptednumbers=decryptednumbers + "'" + s1 + "' ";
        for(int k2 = 1; k2 <= 2; k2++)
        {
            String s10 = s1.substring((k2 - 1) * 8, k2 * 8);
            if(!s10.equals("00000000"))
            {
                BigInteger biginteger22 = new BigInteger(s10, 2);
                int l2 = biginteger22.intValue();
                char c3 = (char)l2;
                decryptedmessage=decryptedmessage + c3;
            }
        }

    }
    String decryptedKey = decryptedmessage;
    this.numberstodecrypt = null;
    this.decryptednumbers = null;
    this.decryptedmessage = null;
    return decryptedKey;
  }
}
