//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.query;

import java.net.InetAddress;
import javax.crypto.*;

public class ServerInfo extends QueryTuple{
  Object addres;
  Object port;
  Object connectionType;

  public ServerInfo(String sessionKey, InetAddress address, Integer port, String connectionType) {
    super(sessionKey);
    this.addres=address;
    this.port=port;
    //this.connectionType=connectionType;
    this.connectionType="Masked";
  }

  public InetAddress getAddress(){
    if (this.addres instanceof InetAddress)
      return (InetAddress)this.addres;
    else
      return null;
  }

  public Integer getPort(){
    if (this.port instanceof Integer)
      return (Integer)this.port;
    else
      return null;
  }

  public String getConnectionType(){
    if(this.connectionType instanceof String)
      return (String)this.connectionType;
    else
      return null;
  }

  public void encrypt(Cipher c) throws Exception {
    this.addres = new SealedObject( (InetAddress)this.addres, c);
    this.port = new SealedObject( (Integer)this.port, c);
    this.connectionType = new SealedObject( (String)this.connectionType, c);
  }

  public void decrypt(Cipher c) throws Exception {
    this.addres = (InetAddress) ( (SealedObject)this.addres).getObject(c);
    this.port = (Integer) ( (SealedObject)this.port).getObject(c);
    this.connectionType = (String) ( (SealedObject)this.connectionType).getObject(c);
  }

  public String toString(){
    //return this.getAddress().getHostAddress()+":"+this.getPort()+"   "+this.getConnectionType();
    return this.getAddress().getHostAddress()+":"+this.getPort();
  }

  public boolean equals(Object o){
    if(o instanceof ServerInfo){
      ServerInfo so = (ServerInfo)o;
      return this.getAddress().getHostAddress().equals(so.getAddress().getHostAddress()) &&
          this.getPort().equals(so.getPort());
    }else{
      return this == o;
    }
  }
}