package ants.p2p.query;

import ants.p2p.*;

import org.apache.log4j.*;

public class QueryResultSenderThread extends Thread {
  WarriorAnt wa;
  QueryMessage qm;
  Router r;

  public static final int waitTime = 10;

  static Logger _logger = Logger.getLogger(QueryResultSenderThread.class.getName());

  public QueryResultSenderThread(WarriorAnt wa, QueryMessage qm, Router r){
    this.wa = wa;
    this.qm = qm;
    this.r = r;
    this.setPriority(Thread.MAX_PRIORITY);
  }

  public void run(){
    try {
      int mSeconds = (int)(Math.floor(Math.random()*waitTime)*1000);
      sleep(mSeconds);
      qm = new QueryMessage(qm);
      QueryManager queryManager = new QueryManager(qm, wa);
      qm.setProcessed();
      qm.resetResolveLoop();
      qm.resetTTL();
      qm.resetDelivered();
      if (qm.getTuples().size() > 0) {
        if(qm.getQuery()instanceof QueryInetAddressItem) {
          qm.fillMessageProperties("",qm.getSource(),1,qm.getAck_Id());
          wa.activateNewRouterProcess(qm, this.r.getRequirer());
        }else{
          qm.fillMessageProperties(wa.getId(),qm.getSource(),1,qm.getAck_Id());
          wa.activateNewRouterProcess(qm, this.r.getRequirer());
        }
      }
    }
    catch (Exception e) {
      _logger.error("",e);
    }
  }
}