//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.query;

import ants.p2p.Message;
import ants.p2p.query.security.*;
import java.util.*;

public class QueryMessage extends Message {
  QueryNode query;
  ArrayList tuples;
  PublicHeader ph;
  boolean processed = false;
  long localQueryId;

  private static long localQueryIDCounter = 0;

  public QueryMessage(Message m, QueryNode query, PublicHeader ph) {
    super(m);
    this.tuples = new ArrayList();
    this.ph = ph;
    this.query = query;
    this.localQueryId = nextLocalQueryID();
  }

  public QueryMessage(QueryMessage qm) {
    super(qm);
    this.tuples = new ArrayList();
    this.ph = qm.ph;
    this.query = qm.query;
    this.localQueryId = qm.localQueryId;
  }

  public QueryMessage(QueryNode query, long timeToLive, PublicHeader ph) {
    super();
    super.ttl = timeToLive;
    this.tuples = new ArrayList();
    this.ph = ph;
    this.query = query;
    this.localQueryId = nextLocalQueryID();
  }

  public QueryNode getQuery(){
    return this.query;
  }

  public ArrayList getTuples(){
    return this.tuples;
  }

  public void resetTuples(){
    this.tuples = new ArrayList();
  }

  public PublicHeader getPublicHeader(){
    return this.ph;
  }

  public void setProcessed(){
    this.processed=true;
  }

  public boolean getProcessed(){
    return this.processed;
  }

  public long getLocalQueryId(){
    return this.localQueryId;
  }

  public static long nextLocalQueryID(){
    return localQueryIDCounter++;
  }

}