//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.query;

import java.util.*;
import java.io.*;
import java.net.*;

import ants.p2p.*;
import ants.p2p.gui.*;
import ants.p2p.utils.*;
import ants.p2p.query.security.*;

import org.apache.log4j.*;

public class QueryManager {
  public static int resultSize = 50;

  static Logger _logger = Logger.getLogger(QueryManager.class.getName());

  WarriorAnt caller;
  QueryMessage queryMessage;
  public ArrayList resultSet = new ArrayList();

  public QueryManager(QueryMessage queryMessage, WarriorAnt caller) throws Exception{
    this.caller=caller;
    this.queryMessage = queryMessage;
    if(this.queryMessage.tuples.size() < QueryManager.resultSize){
      this.resultSet = this.process(queryMessage.query);
      queryMessage.getPublicHeader().generateSessionKey();
      String sessionKey = queryMessage.getPublicHeader().
          getBase64SessionKey();
      if (this.queryMessage.getQuery()instanceof QueryInetAddressItem) {
        if (this.resultSet != null) {
          for (int x = 0; x < resultSet.size() && this.queryMessage.tuples.size() < QueryManager.resultSize; x++) {
            ServerInfo si = new ServerInfo(sessionKey,
                                           FrameAnt.
                getInstance(null).getGuiAnt().getConnectionAntPanel().
                getLocalAddress(),
                                           new Integer(caller.getServerPort()),
                                           WarriorAnt.ConnectionType);
            si.encrypt(queryMessage.getPublicHeader().getEncCipher());
            queryMessage.tuples.add(si);
          }
        }
      }
      else {
        if (this.resultSet != null) {
          for (int x = 0; x < resultSet.size() && this.queryMessage.tuples.size() < QueryManager.resultSize; x++) {
            if(resultSet.get(x) instanceof String){
              QueryCompletedFileTuple qt = new QueryCompletedFileTuple(sessionKey,
                  (new File( (String) resultSet.get(x))).getName(),
                  (String) ( (FileInfos) BackgroundEngine.getInstance().
                            sharedFiles.get(resultSet.get(x))).getHash(),
                  new Long( ( (FileInfos) BackgroundEngine.getInstance().
                             sharedFiles.get(resultSet.get(x))).getSize()),
                  caller.getId(),
                  new Integer(caller.maxPullRequestsToServe -
                              caller.inServiceFilePullRequests.size()),
                  WarriorAnt.ConnectionType);
              qt.encrypt(queryMessage.getPublicHeader().getEncCipher());
              queryMessage.tuples.add(qt);
            }else if(resultSet.get(x) == null && resultSet.size() > x + 1){
              x++;
              BackgroundEngine be = BackgroundEngine.getInstance();
              QueryPartialFileTuple qpt = be.getPartialFileTuple(sessionKey,
                  (String) resultSet.get(x),
                  caller.getId(), new Integer(caller.maxPullRequestsToServe -
                                            caller.inServiceFilePullRequests.
                                            size()),
                                      WarriorAnt.ConnectionType);
              qpt.encrypt(queryMessage.getPublicHeader().getEncCipher());
              queryMessage.tuples.add(qpt);
            }
          }
        }
      }
    }else{
      this.queryMessage.setTTLtoZero();
    }
  }

  public QueryManager(QueryMessage queryMessage) throws Exception{
    AsymmetricProvider ap = new AsymmetricProvider(false);
    this.queryMessage = queryMessage;
    ArrayList decryptedRs = new ArrayList();
    this.resultSet=queryMessage.getTuples();
    if(this.queryMessage.getQuery() instanceof QueryInetAddressItem){
      if (this.resultSet != null) {
        for (int x = 0; x < resultSet.size(); x++) {
          ServerInfo si = (ServerInfo) resultSet.get(x);
          si.decrypt(ap.getDecCipher(si.getEncryptedSessionKey()));
          decryptedRs.add(si);
        }
      }
      this.resultSet = decryptedRs;
    }else{
      if (this.resultSet != null) {
        for (int x = 0; x < resultSet.size(); x++) {
          if(resultSet.get(x) instanceof QueryCompletedFileTuple){
            QueryCompletedFileTuple qft = (QueryCompletedFileTuple) resultSet.get(x);
            qft.decrypt(ap.getDecCipher(qft.getEncryptedSessionKey()));
            decryptedRs.add(qft);
          }else if(resultSet.get(x) instanceof QueryPartialFileTuple){
            QueryPartialFileTuple qpft = (QueryPartialFileTuple) resultSet.get(x);
            qpft.decrypt(ap.getDecCipher(qpft.getEncryptedSessionKey()));
            decryptedRs.add(qpft);
          }
        }
      }
      this.resultSet = decryptedRs;
    }
  }

  public QueryMessage getQueryMessage(){
    return this.queryMessage;
  }

  public ArrayList process(QueryNode qn){
    if(qn instanceof QueryOperator)
      return process((QueryOperator)qn);
    else if(qn instanceof QueryItem)
      return process((QueryItem)qn);
    else
      return null;
  }
  public ArrayList process(QueryOperator qn){
    if(qn instanceof QueryStringAndOperator)
      return process((QueryStringAndOperator)qn);
    else if(qn instanceof QueryStringOrOperator)
      return process((QueryStringOrOperator)qn);
    else
      return null;
  }
  public ArrayList process(QueryStringAndOperator qn){
    ArrayList leftRs = process(qn.left);
    ArrayList rightRs = process(qn.right);
    for(int x=leftRs.size()-1; x >= 0 ; x--){
      if(!rightRs.contains(leftRs.get(x)))
        leftRs.remove(x);
    }
    return leftRs;
  }
  public ArrayList process(QueryStringOrOperator qn){
    ArrayList leftRs = process(qn.left);
    ArrayList rightRs = process(qn.right);
    for(int x=0; x < leftRs.size(); x++){
      if(!rightRs.contains(leftRs.get(x)))
        rightRs.add(leftRs.get(x));
    }
    return rightRs;
  }
  public ArrayList process(QueryItem qn){
    if(qn instanceof QueryStringItem)
      return process((QueryStringItem)qn);
    else if(qn instanceof QueryHashItem)
      return process((QueryHashItem)qn);
    else if(qn instanceof QueryInetAddressItem)
      return process((QueryInetAddressItem)qn);
    else
      return null;
  }

  public ArrayList process(QueryStringItem qn){
    String itemLower = qn.item.toLowerCase();
    ArrayList elements = new ArrayList();
    BackgroundEngine be = BackgroundEngine.getInstance();
    if(be!=null){
      Enumeration fileNames = be.sharedFiles.keys();
      while (fileNames.hasMoreElements()) {
        String elem = (String) fileNames.nextElement();
        String elemLower = elem.toLowerCase();
        if (elemLower.indexOf(itemLower) != -1)
          elements.add(elem);
      }
    }
    return elements;
  }

  public ArrayList process(QueryHashItem qh){
    String hash = qh.hash;
    ArrayList elements = new ArrayList();
    BackgroundEngine be = BackgroundEngine.getInstance();
    if(be!=null){
      Enumeration fileInfos = be.sharedFiles.elements();
      Enumeration fileNames = be.sharedFiles.keys();
      while (fileInfos.hasMoreElements()) {
        FileInfos elemInfo = (FileInfos) fileInfos.nextElement();
        String elemName = (String) fileNames.nextElement();
        if (elemInfo.getHash().equals(hash))
          elements.add(elemName);
      }
      elements.add(null);
      Enumeration partialFileHashes = be.getPartialFiles();
      while (partialFileHashes.hasMoreElements()){
        String curentHash = (String) partialFileHashes.nextElement();
        if (curentHash.equals(hash))
          elements.add(curentHash);
      }
    }
    return elements;
  }

  public ArrayList process(QueryInetAddressItem qh) {
    ServerInfo serverInfo;
    ArrayList elements = new ArrayList();
    if(caller.getNeighbours().size() < caller.maxNeighbours){
      try{
        elements.add(new Boolean(true));
      }catch(Exception e){_logger.error("",e);}
    }
    return elements;
  }

  /*
  public ArrayList filterResultSet(){
    ArrayList tupleGroups = new ArrayList();
    for(int x=0; x < this.resultSet.size(); x++){
      if(this.resultSet.get(x) instanceof QueryFileTuple){
        if(tupleGroups.contains((QueryFileTuple)this.resultSet.get(x))){
          FileTupleGroup ftg = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryFileTuple)this.resultSet.get(x)));
          ftg.tuples.add(this.resultSet.get(x));
        }else{
          QueryFileTuple qft = (QueryFileTuple)this.resultSet.get(x);
          FileTupleGroup ftg = new FileTupleGroup(qft.getFileHash(),qft.getSize());
          ftg.tuples.add(qft);
          tupleGroups.add(ftg);
        }
      }
    }
    return tupleGroups;
  }
  */
}