//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.query;

import java.util.*;

public class FileTupleGroup {
  public ArrayList tuples;
  String hash;
  Long size;

  public FileTupleGroup(String hash, Long size) {
    this.hash=hash;
    this.size=size;
    tuples = new ArrayList();
  }

  public String getHash(){
    return this.hash;
  }

  public Long getSize(){
    return this.size;
  }

  public boolean equals(Object o){
    if(o instanceof FileTupleGroup){
      return ((FileTupleGroup)o).getHash().equals(this.getHash())&&
          ((FileTupleGroup)o).getSize().longValue()==this.getSize().longValue();
    }else if(o instanceof QueryCompletedFileTuple){
      return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getHash())&&
          ((QueryCompletedFileTuple)o).getSize().longValue()==this.getSize().longValue();
    }else if(o instanceof QueryPartialFileTuple){
      return ((QueryPartialFileTuple)o).getFileHash().equals(this.getHash())&&
          ((QueryPartialFileTuple)o).getSize().longValue()==this.getSize().longValue();
    }else{
      return o==this;
    }
  }

  public String toString(){
    int max = 30;
    String result = "";
    if(this.tuples.get(0) instanceof QueryCompletedFileTuple){
    if (max > ( (QueryCompletedFileTuple)this.tuples.get(0)).getFileName().length())
      max = ( (QueryCompletedFileTuple)this.tuples.get(0)).getFileName().length();
    result +=
        ( (QueryCompletedFileTuple)this.tuples.get(0)).getFileName().substring(0, max);
    }else if(this.tuples.get(0) instanceof QueryPartialFileTuple){
      if (max > ( (QueryPartialFileTuple)this.tuples.get(0)).getFileName().length())
        max = ( (QueryPartialFileTuple)this.tuples.get(0)).getFileName().length();
      result +=
          ( (QueryPartialFileTuple)this.tuples.get(0)).getFileName().substring(0, max);
    }
    result += " ";
    while (result.length() < 35)
      result += ".";
    result += this.sizeToString(this.getSize().longValue());
    while (result.length() < 70)
      result += ".";
    result += " Owners: " + this.tuples.size();
    while (result.length() < 90)
      result += ".";
    result += "File hash: " + this.getHash();
    return result;
  }

  public String sizeToString(double dSize){
    double currentSize = dSize;
    int x = 0;
    while (dSize > 1 && x < 4) {
      dSize = dSize / Math.pow(2, 20);
      x++;
    }
    String suffix = " bytes";
    String size = currentSize+suffix;
    if (x == 2) {
      suffix = " Mb";
      size = (new Double(currentSize * 1.0 / Math.pow(2, 20))).
          toString();
      int index = size.indexOf(".");
      if (index >= 0)
        size = size.substring(0, index + 2);
      size += suffix;
    }
    if (x == 3) {
      suffix = " Gb";
      size = (new Double(currentSize * 1.0 / Math.pow(2, 30))).
          toString();
      int index = size.indexOf(".");
      if (index >= 0)
        size = size.substring(0, index + 2);
      size += suffix;
    }
    return " File Size: " + size;
  }
}