//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.messages;

import ants.p2p.Message;
import ants.p2p.*;
import javax.crypto.*;

public class FileSizePushMessage extends Message {
  Object fileName; //String
  Object hash;     //byte[]
  Object size;     //Long

  public FileSizePushMessage(Message m, String fileName, Long size) {
    super(m);
    this.fileName = fileName;
    this.hash = hash;
    this.size = size;
  }

  public FileSizePushMessage(String fileName, byte[] hash, Long size) {
    super();
    this.fileName=fileName;
    this.hash=hash;
    this.size = size;
  }

  public String getFileName(){
    if(this.fileName instanceof String)
      return (String)this.fileName;
    else
      return null;
  }

  public byte[] getHash(){
    if(this.hash instanceof byte[])
      return (byte[])this.hash;
    else
      return null;
  }

  public Long getSize(){
    if(this.size instanceof Long)
      return (Long)this.size;
    else
      return null;
  }


  public void encrypt(Cipher c) throws Exception{
    this.fileName = new SealedObject((String)this.fileName, c);
    this.hash = new SealedObject((byte[])this.hash, c);
    this.size = new SealedObject((Long)this.size, c);
  }

  public void decrypt(Cipher c) throws Exception{
    this.fileName = (String)((SealedObject)this.fileName).getObject(c);
    this.hash = (byte[])((SealedObject)this.hash).getObject(c);
    this.size = (Long)((SealedObject)this.size).getObject(c);
  }
}
