//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.messages;

import ants.p2p.Message;
import ants.p2p.*;
import javax.crypto.*;

public class FilePullMessage extends Message {
  Object fileName; //String
  Object hash;     //byte[]
  Object offset;   //Long
  Object blocks;   //Long
  Object blockSize; //Int
  Object localFileName; //String
  Object resume;

  public FilePullMessage(Message m, String fileName, byte[] hash, Long offset, Long blocks, Integer blockSize, String localFileName, Boolean resume){
    super(m);
    this.fileName = fileName;
    this.hash = hash;
    this.offset = offset;
    this.blocks = blocks;
    this.blockSize = blockSize;
    this.localFileName = localFileName;
    this.resume=resume;
  }

  public FilePullMessage(String fileName, byte[] hash, Long offset, Long blocks, Integer blockSize, String localFileName, Boolean resume){
    super();
    this.fileName=fileName;
    this.hash=hash;
    this.offset=offset;
    this.blocks = blocks;
    this.blockSize=blockSize;
    this.localFileName=localFileName;
    this.resume=resume;
  }

  public Long getBlocks(){
    if(this.blocks instanceof Long)
      return (Long)this.blocks;
    else
      return null;
  }

  public Boolean getResume() {
    if (this.resume instanceof Boolean)
      return (Boolean)this.resume;
    else
      return null;
  }


  public String getFileName(){
    if(this.fileName instanceof String)
      return (String)this.fileName;
    else
      return null;
  }

  public String getLocalFileName(){
    if(this.localFileName instanceof String)
      return (String)this.localFileName;
    else
      return null;
  }


  public byte[] getHash(){
    if(this.hash instanceof byte[])
      return (byte[])this.hash;
    else
      return null;
  }

  public Long getOffset(){
    if(this.offset instanceof Long)
      return (Long)this.offset;
    else
      return null;
  }

  public Integer getBlockSize() {
    if (this.blockSize instanceof Integer)
      return (Integer)this.blockSize;
    else
      return null;
  }

  public void encrypt(Cipher c) throws Exception{
    this.fileName = new SealedObject((String)this.fileName, c);
    this.localFileName = new SealedObject((String)this.localFileName, c);
    this.hash = new SealedObject((byte[])this.hash, c);
    this.offset = new SealedObject((Long)this.offset, c);
    this.blocks = new SealedObject((Long)this.blocks, c);
    this.blockSize = new SealedObject((Integer)this.blockSize, c);
    this.resume = new SealedObject((Boolean)this.resume, c);
  }

  public void decrypt(Cipher c) throws Exception{
    this.fileName = (String)((SealedObject)this.fileName).getObject(c);
    this.localFileName = (String)((SealedObject)this.localFileName).getObject(c);
    this.hash = (byte[])((SealedObject)this.hash).getObject(c);
    this.offset = (Long)((SealedObject)this.offset).getObject(c);
    this.blocks = (Long)((SealedObject)this.blocks).getObject(c);
    this.blockSize = (Integer)((SealedObject)this.blockSize).getObject(c);
    this.resume = (Boolean)((SealedObject)this.resume).getObject(c);
  }
}



