//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.messages;

import ants.p2p.*;
import javax.crypto.*;
import ants.p2p.messages.*;

public class FilePartMessage extends Message{
  Object content; //byte[]
  Object hash;    //byte[]
  Object partId;    //Long
  Object fpm;     //FilePushMessage

  public FilePartMessage(Message m, byte[] content, byte[] hash, Long partId, FilePushMessage fpm){
    super(m);
    this.fpm=fpm;
    this.content=content;
    this.hash=hash;
    this.partId=partId;
  }

  public FilePartMessage(byte[] content, byte[] hash, Long partId, FilePushMessage fpm) {
    super();
    this.fpm=fpm;
    this.content = content;
    this.hash = hash;
    this.partId = partId;
  }

  public byte[] getContent() {
    if(this.content instanceof byte[])
      return (byte[])this.content;
    else
      return null;
  }

  public byte[] getHash(){
    if(this.hash instanceof byte[])
      return (byte[])this.hash;
    else
      return null;
  }

  public Long getPartId(){
    if(this.partId instanceof Long)
      return (Long)this.partId;
    else
      return null;
  }

  public FilePushMessage getFilePushMessage(){
    if(this.fpm instanceof FilePushMessage)
      return (FilePushMessage)this.fpm;
    else
      return null;
  }

  public void encrypt(Cipher c) throws Exception {
    this.content = new SealedObject( (byte[])this.content, c);
    this.hash = new SealedObject( (byte[])this.hash, c);
    this.partId = new SealedObject( (Long)this.partId, c);
    this.fpm = new SealedObject( (FilePushMessage)this.fpm, c);
  }

  public void decrypt(Cipher c) throws Exception {
    this.content = (byte[]) ( (SealedObject)this.content).getObject(c);
    this.hash = (byte[]) ( (SealedObject)this.hash).getObject(c);
    this.partId = (Long) ( (SealedObject)this.partId).getObject(c);
    this.fpm = (FilePushMessage) ( (SealedObject)this.fpm).getObject(c);
  }

}