//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.messages;

import ants.p2p.*;
import javax.crypto.*;

public class ControlMessage extends Message {
  Object controlID; //Integer
  Object content;    //byte[]
  Object message;    //String

  public ControlMessage(Message m, Integer controlID, byte[] content, String message){
    super(m);
    this.content=content;
    this.controlID=controlID;
    this.message=message;
  }

  public ControlMessage(Integer controlID, byte[] content, String message) {
    super();
    this.content = content;
    this.controlID = controlID;
    this.message = message;
  }


  public byte[] getContent(){
    if(this.content instanceof byte[])
      return (byte[])this.content;
    else
      return null;
  }

  public String getMessage(){
    if(this.message instanceof String)
      return (String)this.message;
    else
      return null;
  }

  public Integer getControlId(){
    if(this.controlID instanceof Integer)
      return (Integer)this.controlID;
    else
      return null;
  }

  public void encrypt(Cipher c) throws Exception {
    this.content = new SealedObject( (byte[])this.content, c);
    this.message = new SealedObject( (String)this.message, c);
    this.controlID = new SealedObject( (Integer)this.controlID, c);
  }

  public void decrypt(Cipher c) throws Exception {
    this.content = (byte[]) ( (SealedObject)this.content).getObject(c);
    this.message = (String) ( (SealedObject)this.message).getObject(c);
    this.controlID = (Integer) ( (SealedObject)this.controlID).getObject(c);
  }



  //////////////////////////////////
  // CONTROL ID LIST:
  //
  //
}