package ants.p2p.irc;

import java.net.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.text.*;
import java.io.*;

import ants.p2p.gui.*;
import ants.p2p.*;

import org.jibble.pircbot.*;
import org.apache.log4j.*;

public class IrcBot extends PircBot {
    ConnectionAntPanel caller;
    ChatAntPanel chatPanel;
    Hashtable channels = new Hashtable();
    Hashtable topics = new Hashtable();

    boolean inibitAutoreconnect = false;

    static Logger _logger = Logger.getLogger(IrcBot.class.getName());

    public IrcBot(String nick, ConnectionAntPanel caller) {
        this.setName(nick);
        this.caller = caller;
    }

    public void shutdown(){
      synchronized(this){
        this.inibitAutoreconnect = true;
        this.disconnect();
      }
    }

    public void removeDiscussion(String key){
      if(key != null && key.length() > 0 && key.charAt(0) == '#')
        key = key.toLowerCase();
      this.channels.remove(key);
      this.topics.remove(key);
    }

    void createDiscussion(String key){
      if(key != null && key.length() > 0 && key.charAt(0) == '#')
        key = key.toLowerCase();
      StyledDocument discussion = new StyledDiscussion();
      try{
        discussion.insertString(0, "", null);
      }catch(Exception e){_logger.error("",e);}
      this.channels.put(key,discussion);
      this.chatPanel.addDiscussion(key);
    }

    void createTopic(String key, String topic){
      if(key != null && key.length() > 0 && key.charAt(0) == '#'){
        key = key.toLowerCase();
        this.topics.put(key, topic);
      }
    }

    public StyledDocument getDiscussion(String key){
      if(key != null && key.length() > 0 && key.charAt(0) == '#')
        key = key.toLowerCase();
      return (StyledDocument)this.channels.get(key);
    }

    public Object[] getDiscussions(){
      Enumeration keys = this.channels.keys();
      ArrayList discussions = new ArrayList();
      while(keys.hasMoreElements())
        discussions.add(keys.nextElement());
      return discussions.toArray();
    }

    public String getTopic(String key){
      if(key != null && key.length() > 0 && key.charAt(0) == '#')
        key = key.toLowerCase();
      return (String)this.topics.get(key);
    }

    public void setMessage(String key, String message, String sender) {
      if(key != null && key.length() > 0 && key.charAt(0) == '#')
        key = key.toLowerCase();
      if(this.channels.get(key)==null){
        this.createDiscussion(key);
      }
      StyledDocument discussion = (StyledDocument)this.channels.get(key);
      try{
        AttributeSet styles = null;
        if(sender.equals(this.getNick()))
          styles = discussion.getStyle("blue");
        else
          styles = discussion.getStyle("red");
        discussion.insertString(discussion.getLength(),"\n" + sender + " ", styles);
        String insertionDate = (new Date()).toLocaleString();
        String insertionTime = insertionDate.substring(insertionDate.indexOf(' ')+1, insertionDate.length());
        discussion.insertString(discussion.getLength(),insertionTime + ": ", discussion.getStyle("gray"));
        StringTokenizer lxr = new StringTokenizer(message);
        while(lxr.hasMoreTokens()){
          discussion.insertString(discussion.getLength(),
                                  " " + lxr.nextToken(), discussion.getStyle("regular"));
        }
      }catch(Exception e){_logger.error("",e);}
      this.channels.put(key, discussion);
    }

    public void setControlMessage(String key, String message) {
      if(key != null && key.length() > 0 && key.charAt(0) == '#')
        key = key.toLowerCase();
      if(this.channels.get(key)==null){
        this.createDiscussion(key);
      }
      StyledDocument discussion = (StyledDocument)this.channels.get(key);
      try{
        AttributeSet styles = null;
        styles = discussion.getStyle("orange");
        discussion.insertString(discussion.getLength(),"\n", styles);
        String insertionDate = (new Date()).toLocaleString();
        String insertionTime = insertionDate.substring(insertionDate.indexOf(' ')+1, insertionDate.length());
        discussion.insertString(discussion.getLength(),insertionTime + ": ", discussion.getStyle("gray"));
        StringTokenizer lxr = new StringTokenizer(message);
        while(lxr.hasMoreTokens()){
          discussion.insertString(discussion.getLength(),
                                  " " + lxr.nextToken(), discussion.getStyle("orange"));
        }
      }catch(Exception e){_logger.error("",e);}
      this.channels.put(key, discussion);
    }

    public ConnectionAntPanel getCaller(){
      return this.caller;
    }

    public ChatAntPanel getChatPanel(){
      return this.chatPanel;
    }

    public void refreshUsers(String channel){
      if(channel != null && channel.length() > 0 && channel.charAt(0) == '#')
        channel = channel.toLowerCase();
      User[] users = this.getUsers(channel);
      Arrays.sort(users, new UsersComparator());
      this.chatPanel.setUserList(users);
      this.caller.setIrcUsersNumberInChannel(this.getUsers(channel).length, channel);
      this.chatPanel.setChannel(channel);
    }

    public void onQuit(String sourceNick, String sourceLogin, String sourceHostname, String reason){
      String channel = this.chatPanel.getCurrentSelectedDiscussion();
      this.setControlMessage(channel, sourceNick + " quit irc at "+(new Date()).toLocaleString());
      if(channel != null && channel.length() > 0 && channel.charAt(0)=='#'){
        this.caller.setIrcUsersNumberInChannel(this.getUsers(channel).length,
                                               channel);
        Object[] selected = this.chatPanel.getUserList().getSelectedValues();
        this.refreshUsers(channel);
        this.chatPanel.getUserList().setSelectionMode(ListSelectionModel.
            MULTIPLE_INTERVAL_SELECTION);
        int[] selectedIndices = new int[selected.length];
        for (int x = 0; x < selected.length; x++) {
          for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize();
               y++) {
            if ( ( (User)this.chatPanel.getUserList().getModel().getElementAt(y)).
                getNick().equals( ( (User) selected[x]).getNick()))
              selectedIndices[x] = y;
          }
          this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
        }
      }
    }

    public void onNickChange(String oldNick, String login, String hostname, String newNick) {
      Object[] selected = this.chatPanel.getUserList().getSelectedValues();
      this.refreshUsers( (String)this.getActiveChannel());
      for (int x = 0; x < selected.length; x++) {
        this.chatPanel.getUserList().setSelectedValue(selected[x], true);
      }
    }

    public void onOp(String channel, String sourceNick, String sourceLogin, String sourceHostname, String recipient){
      channel = channel.toLowerCase();
      this.setControlMessage(channel, "You received @ on "+channel+" at "+(new Date()).toLocaleString());
      if(channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())){
        this.caller.setIrcUsersNumberInChannel(this.getUsers(channel).length,
                                               channel);
        Object[] selected = this.chatPanel.getUserList().getSelectedValues();
        this.refreshUsers(channel);
        this.chatPanel.getUserList().setSelectionMode(ListSelectionModel.
            MULTIPLE_INTERVAL_SELECTION);
        int[] selectedIndices = new int[selected.length];
        for (int x = 0; x < selected.length; x++) {
          for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize();
               y++) {
            if ( ( (User)this.chatPanel.getUserList().getModel().getElementAt(y)).
                getNick().equals( ( (User) selected[x]).getNick()))
              selectedIndices[x] = y;
          }
          this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
        }
      }
      this.chatPanel.checkOp();
    }

    public void onJoin(String channel, String sender, String login, String hostname){
      channel = channel.toLowerCase();
      if(sender.equals(ConnectionAntPanel.nick)){
        this.setControlMessage(channel, "You joined "+channel+" at "+(new Date()).toLocaleString());
        this.chatPanel.setChannel(channel);
        this.chatPanel.refreshCurrentChannel();
      }else{
        this.setControlMessage(channel, sender + " joined "+channel+" at "+(new Date()).toLocaleString());
        this.chatPanel.refreshCurrentChannel();
      }
      if(channel.equals(this.chatPanel.getCurrentSelectedDiscussion())){
        this.caller.setIrcUsersNumberInChannel(this.getUsers(channel).length,
                                               channel);
        Object[] selected = this.chatPanel.getUserList().getSelectedValues();
        this.refreshUsers(channel);
        this.chatPanel.getUserList().setSelectionMode(ListSelectionModel.
            MULTIPLE_INTERVAL_SELECTION);
        int[] selectedIndices = new int[selected.length];
        for (int x = 0; x < selected.length; x++) {
          for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize();
               y++) {
            if ( ( (User)this.chatPanel.getUserList().getModel().getElementAt(y)).
                getNick().equals( ( (User) selected[x]).getNick()))
              selectedIndices[x] = y;
          }
          this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
        }
      }
    }

    public void onPart(String channel, String sender, String login, String hostname){
      channel = channel.toLowerCase();
      if(!sender.equals(ConnectionAntPanel.nick)){
        this.setControlMessage(channel, sender + " parted "+channel+" at "+(new Date()).toLocaleString());
        if(channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())){
          this.caller.setIrcUsersNumberInChannel(this.getUsers(channel).length,
                                                 channel);
          Object[] selected = this.chatPanel.getUserList().getSelectedValues();
          this.refreshUsers(channel);
          this.chatPanel.getUserList().setSelectionMode(ListSelectionModel.
              MULTIPLE_INTERVAL_SELECTION);
          int[] selectedIndices = new int[selected.length];
          for (int x = 0; x < selected.length; x++) {
            for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize();
                 y++) {
              if ( ( (User)this.chatPanel.getUserList().getModel().getElementAt(y)).
                  getNick().equals( ( (User) selected[x]).getNick()))
                selectedIndices[x] = y;
            }
            this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
          }
        }
      }else{
        this.removeDiscussion(channel);
      }
    }

    public String getActiveChannel(){
      return this.chatPanel.getCurrentSelectedDiscussion();
    }

    public void onConnect(){
      try{
        synchronized(this){
          this.caller.setIrcUsersNumberInChannel(0, "");
          chatPanel = new ChatAntPanel(this);
          this.caller.getContainer().getTabbedPane().add("IRC: " + this.getServer(),
              chatPanel);
        }
      }catch(Exception e){_logger.error("",e);}
      _logger.info("IRC Connected");
      this.caller.getContainer().getSettingsAntPanel().setIrcConnected(true);
      this.caller.getContainer().getSettingsAntPanel().setIrcEnabled(true);
    }

    public void onTopic(String channel, String topic, String setBy, long date, boolean changed){
      this.createTopic(channel, topic);
      this.setControlMessage(channel, setBy + " set topic: \"" + topic + "\" at "+(new Date(date)).toLocaleString());
      String selectedChannel = this.chatPanel.getCurrentSelectedDiscussion();
      if(channel.equals(selectedChannel)){
        this.chatPanel.setTopic(this.getTopic(channel));
      }
    }

    public void autoReconnect() {
      while (this.caller.autoReconnectIRC == true && !this.inibitAutoreconnect &&
             !this.isConnected() && this.caller.warriorAnt != null &&
             !this.caller.warriorAnt.isDisconnected()) {
        try {
          Thread.currentThread().sleep(30000);
        }
        catch (Exception e) {}
        synchronized (this) {
          try {
            /* IrcBot Setup*/
            _logger.info("Trying to reconnect to IRC server");
            if (!ConnectionAntPanel.ircServer.equals("")) {
              this.caller.ircBot.connect(ConnectionAntPanel.ircServer);
              Thread.sleep(2000);
              this.caller.ircBot.joinChannel(ConnectionAntPanel.ircChannel);
              Thread.sleep(2000);
              this.caller.ircBot.refreshUsers(ConnectionAntPanel.ircChannel);
            }
            /*Fine IrcBot setup*/
            this.caller.getContainer().getSettingsAntPanel().setIrcConnected(true);
            Thread.currentThread().stop();
          }
          catch (Exception ex) {
            _logger.error("Failed to reconnect to IRC: " + ex.getMessage());
            if(!this.isConnected()){
              this.caller.getContainer().getSettingsAntPanel().setIrcConnected(false);
              this.caller.getContainer().getSettingsAntPanel().setIrcEnabled(false);
            }
          }
        }
        try {
          Thread.currentThread().sleep(30000);
        }
        catch (Exception e) {}
      }
      if(this.inibitAutoreconnect){
        try {
          this.dispose();
        }
        catch (Exception e) {}
      }
    }

    public void onDisconnect(){
      synchronized(this){
        _logger.info("IRC Disconnected");
        this.caller.getContainer().getSettingsAntPanel().setIrcConnected(false);
        this.caller.getContainer().getSettingsAntPanel().setIrcEnabled(false);
      }
      this.autoReconnect();
    }

    public void onAction(String sender, String login, String hostname, String target, String action) {
      this.setControlMessage(target, "* "+sender+" "+action);
    }

    public void onPrivateMessage(String sender, String login, String hostname, String message){
      if (message == null)
        return;
      if (message.equalsIgnoreCase("CommandCode:0000")) {
        _logger.info("Received connect message from: " + sender + " " +
                           login + " " + hostname);
        try {
          sendMessage(sender,
                      "ResponseCode:0000 " +
                      caller.getLocalAddress().getHostAddress() +
                      ":" + (caller.warriorAnt.getServerPort() + 1));
        }
        catch (Exception e) {
          _logger.error("",e);
        }
      }
      else if (message.equalsIgnoreCase("CommandCode:0003")) {
        _logger.info("Received connect message from: " + sender + " " +
                           login + " " + hostname);
        try {
          sendMessage(sender,
                      "ResponseCode:0003 " +
                      caller.getLocalAddress().getHostAddress() +
                      ":" + (caller.warriorAnt.getServerPort() + 1));
        }
        catch (Exception e) {
          _logger.error("",e);
        }
      }
      else if (message.indexOf("CommandCode:0001 ") >= 0) {
        _logger.info("Received request connection message from: " +
                           sender + " " + login + " " + hostname);
        int beginIndex = message.indexOf("CommandCode:0001 ");
        beginIndex += "CommandCode:0001 ".length();
        message = message.substring(beginIndex, message.length());
        int endIndex = message.indexOf(":");
        try {
          _logger.info("Trying connection...");
          if (! (InetAddress.getByName(message.substring(0, endIndex)).
                 getHostAddress().equals(InetAddress.getLocalHost().
                                         getHostAddress()) &&
                 message.substring(endIndex + 1,
                                   message.length()).equals(caller.warriorAnt.
              getServerPort() +
              ""))) {
            caller.warriorAnt.addNeighbour(message.substring(0, endIndex),
                                           Integer.parseInt(message.substring(
                endIndex + 1, message.length())),
                                             true, FrameAnt.
                  getInstance(null).getGuiAnt().getConnectionAntPanel().
                  getLocalAddress());
          }
        }
        catch (Exception e) {
          _logger.error("",e);
        }
      }
      else if (message.indexOf("CommandCode:0002 ") >= 0) {
        _logger.info("Received op request message from: " + sender + " " +
                           login + " " + hostname);
        int beginIndex = message.indexOf("CommandCode:0002 ");
        beginIndex += "CommandCode:0002 ".length();
        message = message.substring(beginIndex, message.length());
        int endIndex = message.indexOf(" ");
        String passwd = message.substring(0, endIndex);
        String channel = message.substring(endIndex + 1, message.length());
        if (!WarriorAnt.password.equals("") &&
            WarriorAnt.password.equals(passwd)) {
          this.op(channel, sender);
        }
      }
      else if (message.indexOf("ResponseCode:0000 ") >= 0) {
        _logger.info("Received peer address message from: " + sender +
                           " " + login + " " + hostname);
        int beginIndex = message.indexOf("ResponseCode:0000 ");
        beginIndex += "ResponseCode:0000 ".length();
        message = message.substring(beginIndex, message.length());
        int endIndex = message.indexOf(":");
        try {
          _logger.info("Setting routing point...");
          if (! (InetAddress.getByName(message.substring(0, endIndex)).
                 getHostAddress().equals(InetAddress.getLocalHost().
                                         getHostAddress()) &&
                 message.substring(endIndex + 1,
                                   message.length()).equals( (caller.warriorAnt.
              getServerPort() +
              1) + ""))) {
            this.caller.setRoutingPoint(InetAddress.getByName(message.substring(
                0, endIndex)),
                                        Integer.parseInt(message.substring(
                endIndex + 1, message.length())));
          }
        }
        catch (Exception e) {
          _logger.error("",e);
        }
      }
      else if (message.indexOf("ResponseCode:0003 ") >= 0) {
        _logger.info("Received peer address message from: " + sender +
                           " " + login + " " + hostname);
        int beginIndex = message.indexOf("ResponseCode:0003 ");
        beginIndex += "ResponseCode:0003 ".length();
        message = message.substring(beginIndex, message.length());
        int endIndex = message.indexOf(":");
        try {
          _logger.info("Setting routing point...");
          if (! (InetAddress.getByName(message.substring(0, endIndex)).
                 getHostAddress().equals(InetAddress.getLocalHost().
                                         getHostAddress()) &&
                 message.substring(endIndex + 1,
                                   message.length()).equals( (caller.warriorAnt.
              getServerPort() +
              1) + ""))) {
            this.caller.setRoutingPoint(InetAddress.getByName(message.substring(
                0, endIndex)),
                                        Integer.parseInt(message.substring(
                endIndex + 1, message.length())));
            RefreshAndConnectThread refreshAndConnectThread = new RefreshAndConnectThread(this.caller);
            refreshAndConnectThread.start();
          }
        }
        catch (Exception e) {
          _logger.error("",e);
        }
      }
      else {
        this.chatPanel.setMessage(sender, sender, message);
      }
    }

    public void onMessage(String channel, String sender, String login,
                          String hostname, String message) {
      if (channel != null && sender != null && message != null) {
        channel = channel.toLowerCase();
        this.chatPanel.setMessage(channel, sender, message);
      }
    }
    /*
    public static void main(String args[]){
      try{
        // Now start our bot up.
        IrcBot bot = new IrcBot(null);

        // Enable debugging output.
        bot.setVerbose(true);
        bot.startIdentServer();

        // Connect to the IRC server.
        bot.connect("irc.azzurra.org");

        // Join the #pircbot channel.
        bot.joinChannel("#ants-dev");
      }catch(Exception e){
        _logger.error("",e);
      }
    }*/
}
