package ants.p2p.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.text.*;
import java.io.*;


public class StyledDiscussion extends DefaultStyledDocument {

  public StyledDiscussion(){
    initStylesForDocument(this);
  }

  protected void initStylesForDocument(StyledDiscussion document) {
      //Initialize some styles.
      Style def = StyleContext.getDefaultStyleContext().getStyle(StyleContext.DEFAULT_STYLE);

      Style regular = document.addStyle("regular", def);
      StyleConstants.setForeground(regular, Color.black);

      Style s = document.addStyle("italic", regular);
      StyleConstants.setItalic(s, true);

      s = document.addStyle("bold", regular);
      StyleConstants.setBold(s, true);

      s = document.addStyle("small", regular);
      StyleConstants.setFontSize(s, 10);

      s = document.addStyle("large", regular);
      StyleConstants.setFontSize(s, 16);

      s = document.addStyle("red", regular);
      StyleConstants.setForeground(s, Color.red);

      s = document.addStyle("blue", regular);
      StyleConstants.setForeground(s, Color.blue);

      s = document.addStyle("pink", regular);
      StyleConstants.setForeground(s, Color.pink);

      s = document.addStyle("orange", regular);
      StyleConstants.setForeground(s, Color.orange);

      s = document.addStyle("magenta", regular);
      StyleConstants.setForeground(s, Color.magenta);

      s = document.addStyle("green", regular);
      StyleConstants.setForeground(s, Color.green);

      s = document.addStyle("gray", regular);
      StyleConstants.setForeground(s, Color.gray);
  }
}