package ants.p2p.gui;

import java.awt.*;
import java.beans.*;
import javax.swing.*;
import com.borland.jbcl.layout.*;
import javax.swing.border.*;
import java.io.*;
import java.util.*;

import org.apache.log4j.*;

import ants.p2p.utils.*;
import java.awt.event.*;

public class ShareAntPanel extends JPanel implements PropertyChangeListener{
  public static String pic = "./backgrounds/bg6.jpg";

  static Logger _logger = Logger.getLogger(ShareAntPanel.class.getName());

  Image buffer;
  JPanel jPanel1 = new JPanel();
  XYLayout xYLayout1 = new XYLayout();
  Border border1;
  JButton jButton2 = new JButton();
  JLabel jLabel2 = new JLabel();
  JButton jButton1 = new JButton();
  JList jList1 = new JList();
  JScrollPane jScrollPane2 = new JScrollPane();
  JScrollPane jScrollPane1 = new JScrollPane();
  JList jList2 = new JList();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JPanel jPanel2 = new JPanel();
  FlowLayout flowLayout1 = new FlowLayout();
  Border border2;
  Border border3;
  XYLayout xYLayout2 = new XYLayout();
  Border border4;
  Border border5;
  JProgressBar jProgressBar1 = new JProgressBar();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();

  public ShareAntPanel() {
    try {
      jbInit();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }
  void jbInit() throws Exception {
    border1 = BorderFactory.createEmptyBorder(20,20,20,20);
    border2 = BorderFactory.createEmptyBorder(0,5,0,5);
    border3 = BorderFactory.createEmptyBorder(20,20,20,20);
    border4 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),BorderFactory.createEmptyBorder(5,5,5,5));
    border5 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),BorderFactory.createEmptyBorder(5,5,5,5));
    this.setLayout(flowLayout1);
    jPanel1.setLayout(xYLayout1);
    jPanel1.setBorder(border4);
    jPanel1.setDebugGraphicsOptions(0);
    jPanel1.setDoubleBuffered(true);
    jPanel1.setMinimumSize(new Dimension(220, 250));
    jPanel1.setPreferredSize(new Dimension(410, 250));
    this.addComponentListener(new ShareAntPanel_this_componentAdapter(this));
    jButton2.setText("Remove");
    jButton2.addActionListener(new ShareAntPanel_jButton2_actionAdapter(this));
    jLabel2.setText("Shared Directories");
    jButton1.setText("Add");
    jButton1.addActionListener(new ShareAntPanel_jButton1_actionAdapter(this));
    jList1.setFont(new java.awt.Font("Monospaced", 0, 11));
    jList1.setOpaque(true);
    jScrollPane2.setOpaque(true);
    jScrollPane2.setPreferredSize(new Dimension(400, 130));
    jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    jScrollPane1.setDebugGraphicsOptions(0);
    jLabel1.setText("Shared Files");
    jLabel3.setText("Status: ");
    jPanel2.setLayout(xYLayout2);
    this.setBorder(border1);
    jPanel2.setBorder(border5);
    jList2.setFont(new java.awt.Font("Monospaced", 0, 11));
    jLabel4.setText("Indexing file: ");
    jLabel4.setVisible(false);
    jLabel5.setVisible(false);
    this.jProgressBar1.setMaximum(100);
    this.jProgressBar1.setMinimum(0);
    this.jProgressBar1.setVisible(false);
    jPanel1.add(jLabel2,    new XYConstraints(0, 0, -1, -1));
    jPanel1.add(jScrollPane2,        new XYConstraints(0, 20, -1, -1));
    jPanel1.add(jButton1,   new XYConstraints(0, 170, 100, -1));
    jPanel1.add(jButton2,  new XYConstraints(110, 170, 100, -1));
    jPanel1.add(jLabel3,      new XYConstraints(0, 200, -1, -1));
    jPanel1.add(jLabel4,   new XYConstraints(230, 160, -1, -1));
    jPanel1.add(jProgressBar1,    new XYConstraints(230, 180, -1, -1));
    jPanel1.add(jLabel5,   new XYConstraints(0, 220, -1, -1));
    jScrollPane2.getViewport().add(jList1, null);
    jPanel2.add(jLabel1,   new XYConstraints(0, 0, -1, -1));
    jPanel2.add(jScrollPane1,       new XYConstraints(0, 20, -1, -1));
    jScrollPane1.getViewport().add(jList2, null);
    this.add(jPanel1, null);
    this.add(jPanel2, null);

    BackgroundEngine be = BackgroundEngine.getInstance();
    be.addPropertyChangeListener(this);
    be.forceExternalUpdate();
  }

  public void propertyChange(PropertyChangeEvent e) {
    if (e.getPropertyName().equals("fileIndexingCompleted")) {
      this.jLabel5.setText("");
      this.jLabel4.setVisible(false);
      this.jLabel5.setVisible(false);
      this.jProgressBar1.setVisible(false);
      this.jLabel3.setForeground(Color.BLUE);
      this.jLabel3.setText("Status: file indexing completed... indexing engine idle.");
      Hashtable files = BackgroundEngine.getInstance().sharedFiles;
      Enumeration fileInfos = files.elements();
      ArrayList infos = new ArrayList();
      while(fileInfos.hasMoreElements()){
        infos.add(fileInfos.nextElement());
      }
      this.jList2.setListData(infos.toArray());
    }
    else if (e.getPropertyName().equals("fileIndexed")) {
      int filesToBeProcessed = ((Integer)e.getNewValue()).intValue();
      int fileTotalNumber = ((Integer)e.getOldValue()).intValue();
      this.jLabel5.setText("Progress: "+filesToBeProcessed+"/"+fileTotalNumber+" files");
      Hashtable files = BackgroundEngine.getInstance().sharedFiles;
      Enumeration fileInfos = files.elements();
      ArrayList infos = new ArrayList();
      while(fileInfos.hasMoreElements()){
        infos.add(fileInfos.nextElement());
      }
      this.jList2.setListData(infos.toArray());
    }
    else if(e.getPropertyName().equals("fileIndexingInProgress")) {
      this.jLabel3.setText("Status: file indexing in progress... indexing may slow down your computer for a while!");
      this.jLabel4.setVisible(true);
      this.jLabel5.setVisible(true);
      this.jProgressBar1.setVisible(true);
      String fileName = (String)e.getOldValue();
      Integer progress = (Integer)e.getNewValue();
      this.jLabel4.setText("Indexing file: "+fileName);
      this.jProgressBar1.setValue(progress.intValue());
    }
    else if (e.getPropertyName().equals("fileIndexingInit")) {
      this.jProgressBar1.setValue(0);
      this.jLabel3.setForeground(Color.RED);
    }
    else if(e.getPropertyName().equals("SharedDirectoriesModification")){
      this.jList1.setListData(BackgroundEngine.getInstance().sharedDirectories.toArray());
    }
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (buffer != null){
      int posX = (this.getWidth() - 650)/2;
      int posY = (this.getHeight() - 550)/2;
      if(posX < 0) posX = 0;
      if(posY < 0) posY = 0;
      g.drawImage(buffer, posX, posY, this);
    }
  }

  void this_componentResized(ComponentEvent e) {
    this.jPanel1.setPreferredSize(new Dimension(e.getComponent().getWidth()-40,this.jPanel1.getHeight()));
    this.jPanel1.setSize(new Dimension(e.getComponent().getWidth()-40,this.jPanel1.getHeight()));

    this.jPanel2.setPreferredSize(new Dimension(e.getComponent().getWidth()-40, e.getComponent().getHeight()-this.jPanel1.getHeight()-40));
    this.jPanel2.setSize(new Dimension(e.getComponent().getWidth()-40, e.getComponent().getHeight()-this.jPanel1.getHeight()-40));

    this.jScrollPane1.setPreferredSize(new Dimension(this.getWidth()-80,this.getHeight()-this.jPanel1.getHeight()-80));
    this.jScrollPane1.setSize(new Dimension(this.getWidth()-80,this.getHeight()-this.jPanel1.getHeight()-80));
  }

  void jButton1_actionPerformed(ActionEvent e) {
    JFileChooser jfc = new JFileChooser();
    jfc.setMultiSelectionEnabled(true);
    jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    int returnVal = jfc.showDialog(this,"Add directory");
    if(returnVal == JFileChooser.APPROVE_OPTION) {
       File[] toAdd = jfc.getSelectedFiles();
       for(int x = 0; x < toAdd.length; x++){
         BackgroundEngine.getInstance().addDirectory(toAdd[x]);
       }
    }
  }

  void jButton2_actionPerformed(ActionEvent e) {
    Object[] valuesDir = this.jList1.getSelectedValues();
    int[] indexesDir = this.jList1.getSelectedIndices();
    for (int x = 0; x < indexesDir.length; x++) {
      BackgroundEngine.getInstance().removeDirectory( (File) valuesDir[x]);
    }
  }

}

class ShareAntPanel_jButton1_actionAdapter implements java.awt.event.ActionListener {
  ShareAntPanel adaptee;

  ShareAntPanel_jButton1_actionAdapter(ShareAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton1_actionPerformed(e);
  }
}

class ShareAntPanel_jButton2_actionAdapter implements java.awt.event.ActionListener {
  ShareAntPanel adaptee;

  ShareAntPanel_jButton2_actionAdapter(ShareAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}

class ShareAntPanel_this_componentAdapter extends java.awt.event.ComponentAdapter {
  ShareAntPanel adaptee;

  ShareAntPanel_this_componentAdapter(ShareAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}