//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.event.*;
import java.net.*;

import ants.p2p.*;
import ants.p2p.irc.*;

import com.borland.jbcl.layout.*;

import org.apache.log4j.*;
import javax.swing.border.*;

public class SettingsAntPanel extends JPanel {
  public static String pic = "./backgrounds/bg4.jpg";
  public static final int maxNeighboursNumber = 50;
  public static final int minNeighboursNumber = 1;

  static Logger _logger = Logger.getLogger(SettingsAntPanel.class.getName());

  Image buffer;
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel jPanel1 = new JPanel();
  XYLayout xYLayout1 = new XYLayout();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JComboBox jComboBox1 = new JComboBox();
  JLabel jLabel3 = new JLabel();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  GuiAnt caller;

  File settings = new File("settings.ant");
  File servers = new File("servers.ini");
  JLabel jLabel4 = new JLabel();
  JSlider jSlider1 = new JSlider();
  JLabel jLabel5 = new JLabel();
  JButton jButton1 = new JButton();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel8 = new JLabel();
  JTextField jTextField4 = new JTextField();
  JLabel jLabel9 = new JLabel();
  JTextField jTextField5 = new JTextField();
  JComboBox jComboBox2 = new JComboBox();
  JButton jButton2 = new JButton();
  JLabel jLabel10 = new JLabel();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel11 = new JLabel();
  JComboBox jComboBox3 = null;
  JButton jButton3 = new JButton();
  JCheckBox jCheckBox2 = new JCheckBox();
  JCheckBox jCheckBox1 = new JCheckBox();
  Border border1;
  JCheckBox jCheckBox3 = new JCheckBox();
  JCheckBox jCheckBox4 = new JCheckBox();
  JCheckBox jCheckBox5 = new JCheckBox();

  public SettingsAntPanel(GuiAnt caller) {
    this.caller=caller;
    if(servers.exists()){
      this.loadIrcServers();
    }
    this.jComboBox2.addItem("");
    if(this.jComboBox2.getItemCount()>0){
      ConnectionAntPanel.ircServer = (String)this.jComboBox2.getItemAt(0);
      this.jComboBox2.setSelectedIndex(0);
    }
    if(settings.exists()){
      this.loadSettings();
    }
    try{
      Toolkit tk = Toolkit.getDefaultToolkit();
      MediaTracker mt = new MediaTracker(this);
      buffer = tk.getImage(pic);
      mt.waitForAll();
    }catch(Exception e){}
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
    this.jTextField1.setText(WarriorAnt.maxPullRequestsToServe+"");
    this.jTextField2.setText(WarriorAnt.maxSecureConnections+"");
    this.jTextField3.setText(WarriorAnt.password+"");
    this.jTextField4.setText(ConnectionAntPanel.ircPort+"");
    this.jTextField5.setText(ConnectionAntPanel.ircChannel);
    this.caller.cap.jTextField4.setText(ConnectionAntPanel.nick);
    int maxNeighbours = Ant.maxNeighbours;
    this.jComboBox1.setSelectedItem(WarriorAnt.ConnectionType);
    this.jSlider1.setValue(maxNeighbours);
    this.jComboBox2.setSelectedItem(ConnectionAntPanel.ircServer);
    this.jComboBox3.setSelectedItem(this.caller.cap.getLocalAddress());
    this.jCheckBox3.setSelected(ConnectionAntPanel.autoReconnectIRC);
    this.jCheckBox5.setSelected(ConnectionAntPanel.searchPeersOnIRC);
    this.setIrcConnected(false);
    this.setIrcEnabled(false);
  }

  void jbInit() throws Exception {
    border1 = BorderFactory.createEmptyBorder(20,20,20,20);
    this.jPanel1.setOpaque(false);
    this.setLayout(borderLayout1);
    jPanel1.setLayout(xYLayout1);
    jLabel1.setText("Max download requests to serve");
    jLabel2.setText("Max allowed secure connections");
    jComboBox1.setMaximumSize(new Dimension(100, 32767));
    jComboBox1.setMinimumSize(new Dimension(100, 21));
    jComboBox1.setOpaque(true);
    jComboBox1.setPreferredSize(new Dimension(100, 21));
    jComboBox1.addItem("56K");
    jComboBox1.addItem("ISDN");
    jComboBox1.addItem("DSL");
    jComboBox1.addItem("CABLE");
    jComboBox1.addItem("LAN T3");
    jComboBox1.addItem("LAN T2");
    jComboBox1.addItem("LAN T1");
    jComboBox1.addItem("LAN or Fiber Net");
    jComboBox1.addActionListener(new SettingsAntPanel_jComboBox1_actionAdapter(this));
    jLabel3.setText("Connection Speed");
    jTextField1.setMaximumSize(new Dimension(100, 2147483647));
    jTextField1.setMinimumSize(new Dimension(100, 21));
    jTextField1.setOpaque(true);
    jTextField1.setPreferredSize(new Dimension(100, 21));
    jTextField1.setText("jTextField1");
    jTextField1.addFocusListener(new SettingsAntPanel_jTextField1_focusAdapter(this));
    jTextField2.setMaximumSize(new Dimension(100, 2147483647));
    jTextField2.setMinimumSize(new Dimension(100, 21));
    jTextField2.setOpaque(true);
    jTextField2.setPreferredSize(new Dimension(100, 21));
    jTextField2.setText("jTextField2");
    jTextField2.addFocusListener(new SettingsAntPanel_jTextField2_focusAdapter(this));
    jLabel4.setText("Max neighbours number: "+Ant.maxNeighbours);
    jSlider1.setMinimum(SettingsAntPanel.minNeighboursNumber);
    jSlider1.setMaximum(SettingsAntPanel.maxNeighboursNumber);
    jSlider1.setValue(Ant.maxNeighbours);
    jSlider1.setMaximumSize(new Dimension(100, 24));
    jSlider1.setMinimumSize(new Dimension(100, 24));
    jSlider1.setPreferredSize(new Dimension(100, 24));
    jSlider1.setOpaque(false);
    jSlider1.addChangeListener(new SettingsAntPanel_jSlider1_changeAdapter(this));
    jPanel1.setBorder(border1);
    jPanel1.setMinimumSize(new Dimension(332, 400));
    jPanel1.setPreferredSize(new Dimension(332, 500));
    jLabel5.setText("Download path: "+WarriorAnt.downloadPath);
    jButton1.setText("Change Download Path");
    jButton1.addActionListener(new SettingsAntPanel_jButton1_actionAdapter(this));
    jLabel6.setText("DoubleClick with the right mouse buttton on the tab to close this " +
    "panel.");
    jLabel8.setText("IRC server");
    jTextField4.setMaximumSize(new Dimension(50, 2147483647));
    jTextField4.setMinimumSize(new Dimension(50, 21));
    jTextField4.setPreferredSize(new Dimension(50, 21));
    jTextField4.setVisible(false);
    jLabel9.setText("Channel");
    jTextField5.addFocusListener(new SettingsAntPanel_jTextField5_focusAdapter(this));
    jComboBox2.setOpaque(true);
    jComboBox2.setEditable(true);
    jComboBox2.addActionListener(new SettingsAntPanel_jComboBox2_actionAdapter(this));
    jButton2.setActionCommand("Connect");
    jButton2.setText("Connect");
    jButton2.addActionListener(new SettingsAntPanel_jButton2_actionAdapter(this));
    this.setDebugGraphicsOptions(0);
    jLabel10.setText("Bot password");
    jTextField3.setOpaque(true);
    jTextField3.setText(WarriorAnt.password);
    jTextField3.addFocusListener(new SettingsAntPanel_jTextField3_focusAdapter(this));
    jLabel11.setText("IP Address");
    jTextField5.setOpaque(true);
    try {
      this.jComboBox3 = new JComboBox(InetAddress.getAllByName(InetAddress.
          getLocalHost().getHostName()));
      boolean found = false;
      for (int x = 0; x < this.jComboBox3.getItemCount(); x++) {
        if ( ( (InetAddress)this.jComboBox3.getItemAt(x)).equals(this.caller.
            cap.localAddress)) {
          found = true;
        }
      }
      if (!found) {
        this.jComboBox3.addItem(this.caller.cap.localAddress);
      }
    }
    catch (Exception e) {}
    jButton3.setText("Refresh");
    jButton3.addActionListener(new SettingsAntPanel_jButton3_actionAdapter(this));
    jComboBox3.setEditable(true);
    jComboBox3.addActionListener(new SettingsAntPanel_jComboBox3_actionAdapter(this));
    jCheckBox2.setOpaque(false);
    jCheckBox2.setText("Memorize ip setting");
    jCheckBox2.addActionListener(new SettingsAntPanel_jCheckBox2_actionAdapter(this));
    jCheckBox1.setOpaque(false);
    jCheckBox1.setText("Autostart ANts on run");
    jCheckBox1.addActionListener(new SettingsAntPanel_jCheckBox1_actionAdapter(this));
    jCheckBox3.setText("Autoreconnect to IRC ");
    jCheckBox3.addActionListener(new SettingsAntPanel_jCheckBox3_actionAdapter(this));
    jCheckBox4.setText("Autoresume files on run");
    jCheckBox4.addActionListener(new SettingsAntPanel_jCheckBox4_actionAdapter(this));
    jCheckBox5.setText("Search peers on IRC");
    jCheckBox5.addActionListener(new SettingsAntPanel_jCheckBox5_actionAdapter(this));
    jPanel1.add(jLabel4,     new XYConstraints(0, 30, -1, -1));
    jPanel1.add(jLabel1,    new XYConstraints(0, 60, -1, -1));
    jPanel1.add(jLabel2,    new XYConstraints(0, 90, -1, -1));
    jPanel1.add(jSlider1,      new XYConstraints(200, 30, -1, -1));
    jPanel1.add(jTextField1,  new XYConstraints(200, 60, -1, -1));
    jPanel1.add(jTextField2,   new XYConstraints(200, 90, -1, -1));
    jPanel1.add(jComboBox1,   new XYConstraints(200, 120, -1, -1));
    jPanel1.add(jLabel3,    new XYConstraints(0, 120, 164, -1));
    jPanel1.add(jLabel6,    new XYConstraints(0, 0, -1, -1));
    jPanel1.add(jLabel8,       new XYConstraints(0, 180, -1, -1));
    jPanel1.add(jTextField4, new XYConstraints(313, 238, -1, -1));
    jPanel1.add(jLabel9,      new XYConstraints(0, 210, -1, -1));
    jPanel1.add(jTextField5,      new XYConstraints(200, 210, 109, -1));
    jPanel1.add(jComboBox2,         new XYConstraints(200, 180, 154, -1));
    jPanel1.add(jButton2,        new XYConstraints(400, 180, -1, -1));
    jPanel1.add(jLabel10,     new XYConstraints(0, 240, -1, -1));
    jPanel1.add(jTextField3,     new XYConstraints(200, 240, 109, -1));
    jPanel1.add(jLabel11,         new XYConstraints(0, 300, -1, -1));
    jPanel1.add(jComboBox3,        new XYConstraints(200, 300, 154, -1));
    jPanel1.add(jButton3,      new XYConstraints(400, 300, -1, -1));
    jPanel1.add(jButton1,      new XYConstraints(0, 390, -1, -1));
    jPanel1.add(jCheckBox2,  new XYConstraints(200, 330, -1, -1));
    jPanel1.add(jCheckBox1,    new XYConstraints(200, 360, -1, -1));
    jPanel1.add(jLabel5,        new XYConstraints(0, 420, -1, -1));
    jPanel1.add(jCheckBox3,    new XYConstraints(400, 210, -1, -1));
    jPanel1.add(jCheckBox4,    new XYConstraints(200, 390, -1, -1));
    jPanel1.add(jCheckBox5,     new XYConstraints(400, 240, -1, -1));
    this.add(jPanel1,  BorderLayout.NORTH);
  }

  public void storeSettings(){
    ObjectOutputStream oos = null;
    try{
      oos = new ObjectOutputStream(new FileOutputStream(
          settings));
      oos.writeInt(WarriorAnt.maxPullRequestsToServe);
      oos.writeInt(WarriorAnt.maxSecureConnections);
      oos.writeInt(WarriorAnt.blockSizeInDownload);
      oos.writeInt(MultipleSourcesDownloadManager.blocksPerSource);
      oos.writeInt(MultipleSourcesDownloadManager.MaxSources);
      oos.writeObject(WarriorAnt.ConnectionType);
      oos.writeInt(Ant.maxNeighbours);
      oos.writeObject(WarriorAnt.downloadPath);
      oos.writeObject(ConnectionAntPanel.lastRoutingPoint);
      oos.writeInt(ConnectionAntPanel.lastRoutingPointPort);
      oos.writeObject(ConnectionAntPanel.ircServer);
      oos.writeInt(ConnectionAntPanel.ircPort);
      oos.writeObject(ConnectionAntPanel.ircChannel);
      oos.writeObject(ConnectionAntPanel.nick);
      oos.writeBoolean(ConnectionAntPanel.autoReconnectIRC);
      oos.writeBoolean(ConnectionAntPanel.searchPeersOnIRC);
      oos.writeObject(WarriorAnt.password);
      oos.writeBoolean(this.jCheckBox2.isSelected());
      if(this.jCheckBox2.isSelected())
        oos.writeObject(this.caller.cap.localAddress);
      oos.writeBoolean(this.jCheckBox1.isSelected());
      oos.writeBoolean(this.jCheckBox4.isSelected());
      oos.close();
    }catch(Exception e){
      _logger.error("",e);
      try{
        if (oos != null)
          oos.close();
      }catch(IOException ioe){}
    }
  }

  public void loadIrcServers(){
    BufferedReader reader = null;
    try{
      reader = new BufferedReader(new FileReader(servers));
      String line = reader.readLine();
      while(!line.equals("[servers]")){
            line = reader.readLine();
      }
      line = reader.readLine();
      while(!(line.indexOf("[")>=0 && line.indexOf("]")>=0)){
        if(!line.equals("")){
          line = line.substring(line.indexOf(":")+1,line.length());
          line = line.substring(line.indexOf(":")+1,line.length());
          line = line.substring(0,line.indexOf(":"));
          this.jComboBox2.addItem(line);
        }
        line = reader.readLine();
      }
    }catch(Exception e){
      try{
        reader.close();
      }catch(Exception ex){}
      _logger.error("IRC Server file not found");
    }
  }

  public void loadSettings(){
    ObjectInputStream ois = null;
    try{
      ois = new ObjectInputStream(new FileInputStream(
          settings));
      WarriorAnt.maxPullRequestsToServe = ois.readInt();
      WarriorAnt.maxSecureConnections = ois.readInt();
      WarriorAnt.blockSizeInDownload = ois.readInt();
      MultipleSourcesDownloadManager.blocksPerSource = ois.readInt();
      MultipleSourcesDownloadManager.MaxSources = ois.readInt();
      WarriorAnt.ConnectionType = (String)ois.readObject();
      Ant.maxNeighbours = ois.readInt();
      WarriorAnt.downloadPath = (String)ois.readObject();
      ConnectionAntPanel.lastRoutingPoint = (String)ois.readObject();
      caller.cap.jTextField5.setText(ConnectionAntPanel.lastRoutingPoint);
      ConnectionAntPanel.lastRoutingPointPort = ois.readInt();
      caller.cap.jTextField6.setText(ConnectionAntPanel.lastRoutingPointPort+"");
      ConnectionAntPanel.ircServer = (String)ois.readObject();
      this.jComboBox2.setSelectedItem(ConnectionAntPanel.ircServer);
      ConnectionAntPanel.ircPort = ois.readInt();
      this.jTextField4.setText(ConnectionAntPanel.ircPort+"");
      ConnectionAntPanel.ircChannel = (String)ois.readObject();
      this.jTextField5.setText(ConnectionAntPanel.ircChannel+"");
      ConnectionAntPanel.nick = (String)ois.readObject();
      this.caller.cap.jTextField4.setText(ConnectionAntPanel.nick);
      ConnectionAntPanel.autoReconnectIRC = ois.readBoolean();
      ConnectionAntPanel.searchPeersOnIRC = ois.readBoolean();
      WarriorAnt.password = (String)ois.readObject();
      this.jTextField3.setText(WarriorAnt.password);
      this.jCheckBox2.setSelected(ois.readBoolean());
      if(this.jCheckBox2.isSelected()){
        this.caller.cap.localAddress = (InetAddress) ois.readObject();
      }
      this.jCheckBox1.setSelected(ois.readBoolean());
      this.jCheckBox4.setSelected(ois.readBoolean());
      ois.close();
    }catch(Exception e){
      _logger.error("",e);
      try{
        ois.close();
      }catch(IOException ioe){}
    }
  }

  void jComboBox1_actionPerformed(ActionEvent e) {
    WarriorAnt.ConnectionType = (String)jComboBox1.getSelectedItem();
    if (jComboBox1.getSelectedItem().equals("LAN or Fiber Net")) {
      /*
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 20);
      MultipleSourcesDownloadManager.blocksPerSource = 5;
      MultipleSourcesDownloadManager.MaxSources = 20;
      this.storeSettings();
      */
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 10;
      this.jSlider1.setValue(1);
      this.storeSettings();
      jComboBox1.setSelectedItem("56K");
    }else if (jComboBox1.getSelectedItem().equals("LAN T1")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 40;
      this.jSlider1.setValue(((int)Math.floor(Math.random()*2))*2 + 29);
      this.storeSettings();
    }
    else if (jComboBox1.getSelectedItem().equals("LAN T2")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 40;
      this.jSlider1.setValue(((int)Math.floor(Math.random()*2))*2 + 17);
      this.storeSettings();
    }
    else if (jComboBox1.getSelectedItem().equals("LAN T3")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 40;
      this.jSlider1.setValue(((int)Math.floor(Math.random()*2))*2 + 17);
      this.storeSettings();
    }
    else if (jComboBox1.getSelectedItem().equals("CABLE")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 20;
      this.jSlider1.setValue(((int)Math.floor(Math.random()*2))*2 + 11);
      this.storeSettings();
    }
    else if (jComboBox1.getSelectedItem().equals("DSL")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 20;
      this.jSlider1.setValue(((int)Math.floor(Math.random()*2))*2 + 7);
      this.storeSettings();
    }
    else if (jComboBox1.getSelectedItem().equals("ISDN")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 10;
      this.jSlider1.setValue(1);
      this.storeSettings();
    }
    else if (jComboBox1.getSelectedItem().equals("56K")) {
      WarriorAnt.blockSizeInDownload = (int) Math.pow(2, 15);
      MultipleSourcesDownloadManager.blocksPerSource = 10;
      MultipleSourcesDownloadManager.MaxSources = 10;
      this.jSlider1.setValue(1);
      this.storeSettings();
    }
  }

  void jSlider1_stateChanged(ChangeEvent e) {
    this.jLabel4.setText("Max neighbours number: "+jSlider1.getValue());
    Ant.maxNeighbours = this.jSlider1.getValue();
    if(FrameAnt.getInstance(null).getGuiAnt() != null &&
       FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel() != null &&
       FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().connectionManager != null)
      FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().connectionManager.resume();
    this.storeSettings();
  }

  void jButton1_actionPerformed(ActionEvent e) {
    JFileChooser jfc = new JFileChooser();
    jfc.setMultiSelectionEnabled(false);
    jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    int returnVal = jfc.showDialog(this, "Select Directory");
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      File downloadTo = jfc.getSelectedFile();
      int length = downloadTo.getAbsolutePath().length();
      if(downloadTo.getAbsolutePath().charAt(length-1)=='\\' ||
        downloadTo.getAbsolutePath().charAt(length-1)=='/'){
       WarriorAnt.downloadPath = downloadTo.getAbsolutePath();
       this.jLabel5.setText(WarriorAnt.downloadPath);
       this.storeSettings();
     }else{
       WarriorAnt.downloadPath = downloadTo.getAbsolutePath()+"/";
       this.jLabel5.setText(WarriorAnt.downloadPath);
       this.storeSettings();
     }
    }
  }

  void jTextField5_focusLost(FocusEvent e) {
    ConnectionAntPanel.ircChannel = this.jTextField5.getText();
    this.storeSettings();
  }

  void jTextField1_focusLost(FocusEvent e) {
    try {
      int num = Integer.parseInt(jTextField1.getText());
      WarriorAnt.maxPullRequestsToServe = num;
      this.storeSettings();
    }
    catch (Exception ex) {
      jTextField1.setText(WarriorAnt.maxPullRequestsToServe + "");
    }
  }

  void jTextField2_focusLost(FocusEvent e) {
    try {
      int num = Integer.parseInt(jTextField2.getText());
      WarriorAnt.maxSecureConnections = num;
      this.storeSettings();
    }
    catch (Exception ex) {
      jTextField2.setText(WarriorAnt.maxSecureConnections + "");
    }
  }


  void jComboBox2_actionPerformed(ActionEvent e) {
    try {
          if (!((String)this.jComboBox2.getSelectedItem()).equals("")) {
            //InetAddress.getByName(((String)this.jComboBox2.getSelectedItem())).getHostAddress();
            ConnectionAntPanel.ircServer = ((String)this.jComboBox2.getSelectedItem());
            ConnectionAntPanel.ircPort = Integer.parseInt(this.jTextField4.getText());
          }
          else {
            ConnectionAntPanel.ircServer = "";
            this.jComboBox2.setSelectedItem("");
            ConnectionAntPanel.ircPort = 6666;
            this.jTextField4.setText(6666 + "");
          }
          this.storeSettings();
        }
        catch (Exception ex) {
          ConnectionAntPanel.ircServer = "";
          this.jComboBox2.setSelectedItem("");
          ConnectionAntPanel.ircPort = 6666;
          this.jTextField4.setText(6666 + "");
        }
  }

  public void setIrcConnected(boolean val){
    if(val){
      this.jTextField5.setEnabled(false);
      this.jComboBox2.setEnabled(false);
      this.jButton2.setText("Disconnect");
      this.jButton2.setEnabled(true);
    }else{
      if(this.caller.cap != null && this.caller.cap.ircBot != null){
        ChatAntPanel chatPanel = this.caller.cap.ircBot.getChatPanel();
        if (chatPanel != null) {
          chatPanel.setChannel("Channel: ");
          this.caller.cap.setIrcUsersNumberInChannel( -1, "");
          this.caller.getTabbedPane().remove(chatPanel);
          chatPanel.setUserList(null);
          chatPanel = null;
        }
        for(int x = this.caller.getTabbedPane().getComponentCount()-1; x >= 0; x--){
          if(this.caller.getTabbedPane().getComponentAt(x) instanceof ChatAntPanel){
            this.caller.getTabbedPane().remove(x);
          }
        }
      }
      this.jTextField5.setEnabled(true);
      this.jComboBox2.setEnabled(true);
      this.jButton2.setText("Connect");
      if(this.caller.cap != null && this.caller.cap.warriorAnt != null)
        this.jButton2.setEnabled(!this.caller.cap.warriorAnt.isDisconnected());
    }
  }

  public void setIrcEnabled(boolean val){
    this.caller.cap.jButton9.setEnabled(val);
  }

  public boolean autoStartANts(){
    return this.jCheckBox1.isSelected();
  }

  public boolean autoResumeOnRun(){
    return this.jCheckBox4.isSelected();
  }

  void jButton2_actionPerformed(ActionEvent e) {
    if (this.jButton2.getText().equals("Connect")) {
      try {
        this.jButton2.setEnabled(false);
        if (this.caller.cap.ircBot != null) {
          this.caller.cap.ircBot.shutdown();
        }
        /* IrcBot Setup*/
        if (!ConnectionAntPanel.ircServer.equals("")) {
          this.caller.cap.ircBot = new IrcBot(ConnectionAntPanel.nick,
                                              this.caller.cap);
          this.caller.cap.ircBot.connect(ConnectionAntPanel.ircServer);
          Thread.sleep(2000);
          this.caller.cap.ircBot.joinChannel(ConnectionAntPanel.ircChannel);
          Thread.sleep(2000);
          this.caller.cap.ircBot.refreshUsers(ConnectionAntPanel.ircChannel);
          //this.caller.cap.jButton9.setEnabled(true);
          //this.setIrcEnabled(true);
          //this.setIrcConnected(true);
        }
        /*Fine IrcBot setup*/
        this.jButton2.setEnabled(true);
      }
      catch (Exception ex) {
        this.setIrcConnected(false);
        this.setIrcEnabled(false);

        _logger.error("IRC not started: "+ex.getMessage());
        this.jButton2.setEnabled(true);
        final SwingWorker worker = new SwingWorker() {
          public Object construct() {
            caller.cap.ircBot.autoReconnect();
            return null;
          }
        };
        worker.start();
      }
    }
    else {
      try{
        this.jButton2.setEnabled(false);
        if (this.caller.cap.ircBot != null) {
          this.caller.cap.ircBot.shutdown();
        }
        this.setIrcEnabled(false);
        this.setIrcConnected(false);
        this.jButton2.setEnabled(true);
      }catch(Exception ex){
        this.jButton2.setEnabled(true);
        _logger.error("Error in IRC swithcing",ex);
      }
    }
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (buffer != null) {
      int posX = (this.getWidth() - 650) / 2;
      int posY = (this.getHeight() - 550) / 2;
      if(posX < 0) posX = 0;
      if(posY < 0) posY = 0;
      g.drawImage(buffer, posX, posY, this);
    }
  }

  void jTextField3_focusLost(FocusEvent e) {
    WarriorAnt.password = this.jTextField3.getText();
    this.storeSettings();
  }


  void jButton3_actionPerformed(ActionEvent e) {
    try {
      this.jComboBox3.removeAllItems();
      InetAddress[] inetAddrs = InetAddress.getAllByName(InetAddress.
          getLocalHost().getHostName());
      for(int x = 0; x < inetAddrs.length; x++){
        this.jComboBox3.addItem(inetAddrs[x]);
      }
    }
    catch (Exception ex) {}
  }

  void jComboBox3_actionPerformed(ActionEvent e) {
    try {
      if(this.jComboBox3.getSelectedItem() instanceof InetAddress){
        this.caller.cap.localAddress = (InetAddress)this.jComboBox3.
            getSelectedItem();
        this.storeSettings();
      }
      else if(this.jComboBox3.getSelectedItem() instanceof String){
        this.caller.cap.localAddress = InetAddress.getByName( (String)this.
            jComboBox3.
            getSelectedItem());
        this.storeSettings();
      }else
        throw new Exception("Not a valid IP address in settings panel field");
    }
    catch (Exception ex) {
      this.jComboBox3.setSelectedItem(this.caller.cap.localAddress);
    }
  }

  void jCheckBox2_actionPerformed(ActionEvent e) {
    this.storeSettings();
  }

  void jCheckBox1_actionPerformed(ActionEvent e) {
    this.storeSettings();
  }

  void jCheckBox3_actionPerformed(ActionEvent e) {
    ConnectionAntPanel.autoReconnectIRC = this.jCheckBox3.isSelected();
    this.storeSettings();
  }

  void jCheckBox4_actionPerformed(ActionEvent e) {
    this.storeSettings();
  }

  void jCheckBox5_actionPerformed(ActionEvent e) {
    ConnectionAntPanel.searchPeersOnIRC = this.jCheckBox5.isSelected();
    this.storeSettings();
  }
}

class SettingsAntPanel_jComboBox1_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jComboBox1_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jComboBox1_actionPerformed(e);
  }
}

class SettingsAntPanel_jSlider1_changeAdapter implements javax.swing.event.ChangeListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jSlider1_changeAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.jSlider1_stateChanged(e);
  }
}

class SettingsAntPanel_jButton1_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jButton1_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton1_actionPerformed(e);
  }
}

class SettingsAntPanel_jTextField3_focusAdapter extends java.awt.event.FocusAdapter {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jTextField3_focusAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField3_focusLost(e);
  }
}

class SettingsAntPanel_jTextField5_focusAdapter extends java.awt.event.FocusAdapter {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jTextField5_focusAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField5_focusLost(e);
  }
}

class SettingsAntPanel_jTextField1_focusAdapter extends java.awt.event.FocusAdapter {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jTextField1_focusAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField1_focusLost(e);
  }
}

class SettingsAntPanel_jTextField2_focusAdapter extends java.awt.event.FocusAdapter {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jTextField2_focusAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField2_focusLost(e);
  }
}

class SettingsAntPanel_jComboBox2_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jComboBox2_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jComboBox2_actionPerformed(e);
  }
}

class SettingsAntPanel_jButton2_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jButton2_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    final ActionEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jButton2_actionPerformed(event);
        return null;
      }
    };
    worker.start();
  }
}

class SettingsAntPanel_jButton3_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jButton3_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton3_actionPerformed(e);
  }
}

class SettingsAntPanel_jComboBox3_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jComboBox3_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jComboBox3_actionPerformed(e);
  }
}

class SettingsAntPanel_jCheckBox2_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jCheckBox2_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBox2_actionPerformed(e);
  }
}

class SettingsAntPanel_jCheckBox1_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jCheckBox1_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBox1_actionPerformed(e);
  }
}

class SettingsAntPanel_jCheckBox3_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jCheckBox3_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBox3_actionPerformed(e);
  }
}

class SettingsAntPanel_jCheckBox4_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jCheckBox4_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBox4_actionPerformed(e);
  }
}

class SettingsAntPanel_jCheckBox5_actionAdapter implements java.awt.event.ActionListener {
  SettingsAntPanel adaptee;

  SettingsAntPanel_jCheckBox5_actionAdapter(SettingsAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBox5_actionPerformed(e);
  }
}