//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.beans.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.event.*;

import ants.p2p.*;
import ants.p2p.query.*;
import ants.p2p.query.security.*;

import org.apache.log4j.*;

import com.borland.jbcl.layout.*;
import javax.swing.border.*;

public class QueryAntPanel extends JPanel implements PropertyChangeListener{
  public static String pic = "./backgrounds/bg3.jpg";
  static Logger _logger = Logger.getLogger(QueryAntPanel.class.getName());

  Image buffer;
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextField jTextField1 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JTree jTree1;
  DefaultTreeModel queryTree = new DefaultTreeModel(null);
  QueryMessage currentQuery = null;
  GuiAnt container;
  JLabel jLabel2 = new JLabel();
  JButton jButton3 = new JButton();
  JLabel jLabel3 = new JLabel();
  JSlider jSlider1 = new JSlider();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();

  ArrayList currentResultSet;
  JPanel jPanel1 = new JPanel();
  XYLayout xYLayout2 = new XYLayout();
  XYLayout xYLayout3 = new XYLayout();
  JPanel jPanel2 = new JPanel();
  XYLayout xYLayout4 = new XYLayout();
  FlowLayout flowLayout1 = new FlowLayout(FlowLayout.LEFT);
  Border border1;

  public QueryAntPanel(GuiAnt container) {
    this.container=container;
    try{
      Toolkit tk = Toolkit.getDefaultToolkit();
      MediaTracker mt = new MediaTracker(this);
      buffer = tk.getImage(pic);
      mt.waitForAll();
    }catch(Exception e){}
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
    currentResultSet = new ArrayList();
  }
  void jbInit() throws Exception {
    jTree1 = new JTree(queryTree);
    border1 = BorderFactory.createEmptyBorder(20,20,20,20);
    this.setLayout(flowLayout1);
    jLabel1.setText("Query String or File Hash");
    jButton1.setText("Search by string");
    jButton1.addActionListener(new QueryAntPanel_jButton1_actionAdapter(this));
    jButton2.setText("New Query");
    jButton2.addActionListener(new QueryAntPanel_jButton2_actionAdapter(this));
    jTree1.setFont(new java.awt.Font("Monospaced", 0, 11));
    jTree1.setRootVisible(false);
    jTree1.addMouseListener(new QueryAntPanel_jTree1_mouseAdapter(this));
    jLabel2.setText("no last search...");
    jTextField1.setOpaque(true);
    jTextField1.setText("");
    jButton3.setText("Search by hash");
    jButton3.addActionListener(new QueryAntPanel_jButton3_actionAdapter(this));
    jLabel3.setMaximumSize(new Dimension(336, 20));
    jLabel3.setMinimumSize(new Dimension(336, 20));
    jLabel3.setPreferredSize(new Dimension(336, 20));
    jLabel3.setText("DoubleClick with the right mouse buttton on the tab to close this " +
    "panel.");
    int primeSum = 0;
    int x = 0;
    while(x < Router.timeToLiveDecreaseRounds){
      primeSum += Router.primes[Router.timeToLiveDecreaseFactorIndex];
      x++;
    }
    this.jLabel4.setText("Query accuracy setting: "+(WarriorAnt.queryTimeToLive/(primeSum/Router.timeToLiveDecreaseRounds)));
    jSlider1.setMaximumSize(new Dimension(200, 24));
    jSlider1.setMinimumSize(new Dimension(200, 24));
    jSlider1.setMaximum(WarriorAnt.maxQueryTimeToLive);
    jSlider1.setMinimum(WarriorAnt.minQueryTimeToLive);
    jSlider1.setValue((int)WarriorAnt.queryTimeToLive);
    jSlider1.setLayout(xYLayout2);
    jSlider1.setOpaque(false);
    jSlider1.addChangeListener(new QueryAntPanel_jSlider1_changeAdapter(this));
    jLabel5.setText("speed");
    jLabel6.setText("accuracy");
    jLabel7.setText("approximate number of nodes to visit");
    jPanel1.setLayout(xYLayout3);
    jPanel2.setLayout(xYLayout4);
    jScrollPane1.setMaximumSize(new Dimension(32767, 32767));
    jScrollPane1.setMinimumSize(new Dimension(400, 200));
    jScrollPane1.setPreferredSize(new Dimension(400, 200));
    this.addComponentListener(new QueryAntPanel_this_componentAdapter(this));
    jPanel2.setMinimumSize(new Dimension(480, 100));
    jPanel2.setOpaque(false);
    jPanel2.setPreferredSize(new Dimension(480, 100));
    jPanel2.setRequestFocusEnabled(true);
    jPanel1.setMinimumSize(new Dimension(470, 90));
    jPanel1.setOpaque(false);
    jPanel1.setPreferredSize(new Dimension(470, 90));
    this.setAlignmentX((float) 0.5);
    this.setBorder(border1);
    jPanel1.add(jLabel7,     new XYConstraints(0, 60, -1, -1));
    jPanel1.add(jLabel2,     new XYConstraints(0, 10, -1, -1));
    jPanel1.add(jSlider1,   new XYConstraints(250, 24, -1, -1));
    jPanel1.add(jLabel5,    new XYConstraints(250, 51, -1, -1));
    jPanel1.add(jLabel6,   new XYConstraints(390, 51, -1, -1));
    jPanel1.add(jLabel4,     new XYConstraints(0, 35, -1, -1));
    jScrollPane1.getViewport().add(jTree1, null);
    jPanel2.add(jTextField1,       new XYConstraints(0, 65, 325, -1));
    jPanel2.add(jLabel1,  new XYConstraints(0, 32, -1, -1));
    jPanel2.add(jButton2,  new XYConstraints(210, 33, 109, -1));
    jPanel2.add(jButton1,  new XYConstraints(350, 33, 129, -1));
    jPanel2.add(jButton3,   new XYConstraints(350, 63, 129, -1));
    jPanel2.add(jLabel3,       new XYConstraints(0, 0, 480, -1));
    this.add(jPanel2, null);
    this.add(jScrollPane1, null);
    this.add(jPanel1, null);
  }

  void jButton1_actionPerformed(ActionEvent e) {
    try{
      this.currentResultSet = new ArrayList();
      String query = this.jTextField1.getText();
      if(query == null || query.equals("")) return;
      QueryNode qn = this.parseQueryString(this.jTextField1.getText());
      //QueryStringItem qsi = new QueryStringItem(null, this.jTextField1.getText());
      AsymmetricProvider ap = new AsymmetricProvider(false);
      this.currentQuery = (QueryMessage)this.container.cap.warriorAnt.doQuery(qn, ap.getPublicHeader(), WarriorAnt.queryTimeToLive).getMessage();
      this.jLabel2.setText("Last search (by string): "+this.jTextField1.getText());
      Component[] tabs = this.container.jTabbedPane1.getComponents();
      for(int x = 0; x < tabs.length; x++){
        if(tabs[x]==this){
          int max = this.jTextField1.getText().length();
          if(max > 10)
            max = 10;
          this.container.jTabbedPane1.setTitleAt(x,"Query: " + this.jTextField1.getText().substring(0,max));
          return;
        }
      }
    }catch(Exception ex){_logger.error("",ex);}
  }

  public QueryNode parseQueryString(String query){
    QueryNode queryStructure = this.parseQueryString(null, query);
    return queryStructure;
  }

  private QueryNode parseQueryString(QueryNode father, String query){
    char current;
    String buffer = "";
    int index = 0;
    if(query.length() == 0)
      return null;
    if(query.charAt(index)=='"'){
      index++;
      boolean foundClosingQuotes = false;
      while (index < query.length() &&
             query.charAt(index) != '"') {
        buffer+=query.charAt(index);
        index++;
        if(index < query.length() &&
           query.charAt(index) == '"'){
          foundClosingQuotes = true;
          break;
        }
      }
      if(foundClosingQuotes && index == query.length()){
        return new QueryStringItem(father, buffer);
      }else if(foundClosingQuotes && index < query.length()){
        QueryStringOrOperator fatherOp = new QueryStringOrOperator(father, null, null);
        fatherOp.setLeft(new QueryStringItem(father, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                         query.substring(buffer.length() + 2)));
        if(fatherOp.getRight()!=null)
          return fatherOp;
        else
          return fatherOp.left;
      }
      else{
        return parseQueryString(father, query.substring(1));
      }
    }
    else if (query.charAt(index) == ' ') {
      while (query.length()>0 && query.charAt(index) == ' ') {
        query = query.substring(1);
        return this.parseQueryString(father,query);
      }
      while (index < query.length() &&
             query.charAt(index) != ' ' &&
             query.charAt(index) != '+' &&
             query.charAt(index) != '"') {
        buffer += query.charAt(index);
        index++;
      }

      boolean fwd = false;
      while (index < query.length() && query.charAt(index) == ' '){
        index++;
      }
      if(fwd)
        index--;

      if(query.charAt(index) == ' '){
        QueryStringOrOperator fatherOp = new QueryStringOrOperator(father, null, null);
        fatherOp.setLeft(parseQueryString(fatherOp, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                           query.substring(buffer.length() + 1)));
        if (fatherOp.getRight() != null)
          return fatherOp;
        else
          return fatherOp.left;
      }else if(query.charAt(index) == '+'){
        QueryStringAndOperator fatherOp = new QueryStringAndOperator(father, null, null);
        fatherOp.setLeft(parseQueryString(fatherOp, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                           query.substring(buffer.length() + 1)));
        if (fatherOp.getRight() != null)
          return fatherOp;
        else
          return fatherOp.left;
      }else if(query.charAt(index) == '"'){
        QueryStringOrOperator fatherOp = new QueryStringOrOperator(father, null, null);
        fatherOp.setLeft(parseQueryString(fatherOp, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                           query.substring(buffer.length())));
        if (fatherOp.getRight() != null)
          return fatherOp;
        else
          return fatherOp.left;
      }else{
        QueryStringItem word = new QueryStringItem(father, query);
        return word;
      }
    }
    else if (query.charAt(index) == '+') {
      while (query.length()>0 && (
          query.charAt(index) == '+' ||
          query.charAt(index) == ' ')) {
        query = query.substring(1);
        return this.parseQueryString(father,query);
      }
      while (index < query.length() &&
             query.charAt(index) != ' ' &&
             query.charAt(index) != '+' &&
             query.charAt(index) != '"') {
        buffer += query.charAt(index);
        index++;
      }

      boolean fwd = false;
      while (index < query.length() && query.charAt(index) == ' '){
        index++;
      }
      if(fwd)
        index--;

      if(query.charAt(index) == '+'){
        QueryStringAndOperator fatherOp = new QueryStringAndOperator(father, null, null);
        fatherOp.setLeft(parseQueryString(fatherOp, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                           query.substring(buffer.length() + 1)));
        if (fatherOp.getRight() != null)
          return fatherOp;
        else
          return fatherOp.left;
      }else if(query.charAt(index) == ' '){
        QueryStringOrOperator fatherOp = new QueryStringOrOperator(father, null, null);
        fatherOp.setLeft(parseQueryString(fatherOp, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                           query.substring(buffer.length() + 1)));
        if (fatherOp.getRight() != null)
          return fatherOp;
        else
          return fatherOp.left;
      }else if(query.charAt(index) == '"'){
        QueryStringOrOperator fatherOp = new QueryStringOrOperator(father, null, null);
        fatherOp.setLeft(parseQueryString(fatherOp, buffer));
        fatherOp.setRight(parseQueryString(fatherOp,
                                           query.substring(buffer.length())));
        if (fatherOp.getRight() != null)
          return fatherOp;
        else
          return fatherOp.left;
      }else{
        QueryStringItem word = new QueryStringItem(father, query);
        return word;
      }
    }
    else {
      boolean more = false;
      boolean and = false;
      int inc = 0;
      while (index < query.length() &&
             query.charAt(index) != ' ' &&
             query.charAt(index) != '"' &&
             query.charAt(index) != '+') {
        buffer += query.charAt(index);
        index++;
        if (index == query.length())
         break;
        else if(query.charAt(index) == ' '){
          inc = 1;
          more = true;
          break;
        }else if(query.charAt(index) == '"') {
          inc = 0;
          more = true;
          break;
        }else if(query.charAt(index) == '+') {
          inc = 1;
          more = true;
          and = true;
          break;
        }
      }

      while (index < query.length() &&
             (query.charAt(index) == ' ' ||
             query.charAt(index) == '+' ||
             query.charAt(index) == '"')){
        if(query.charAt(index) == '+') {
          inc = 1;
          more = true;
          and = true;
        }
        index++;
      }

      if(more){
        if(!and){
          QueryStringOrOperator fatherOp = new QueryStringOrOperator(father, null, null);
          fatherOp.setLeft(parseQueryString(fatherOp, buffer));
          fatherOp.setRight(parseQueryString(fatherOp,
                                             query.substring(buffer.length() +
              inc)));
          if (fatherOp.getRight() != null)
            return fatherOp;
          else
            return fatherOp.left;
        }else{
          QueryStringAndOperator fatherOp = new QueryStringAndOperator(father, null, null);
          fatherOp.setLeft(parseQueryString(fatherOp, buffer));
          fatherOp.setRight(parseQueryString(fatherOp,
                                             query.substring(buffer.length() +
              inc)));
          if (fatherOp.getRight() != null)
            return fatherOp;
          else
            return fatherOp.left;
        }
      }else{
        QueryStringItem word = new QueryStringItem(father, query);
        return word;
      }
    }
  }

  public void propertyChange(PropertyChangeEvent e) {
    if (e.getPropertyName().equals("queryCompleted")) {
      if (this.currentQuery != null){
        QueryMessage eventQuerySource = (QueryMessage) e.getOldValue();
        QueryMessage currentQuery = this.currentQuery;
        if(eventQuerySource.getLocalQueryId() == currentQuery.getLocalQueryId()){
          DefaultMutableTreeNode root = new DefaultMutableTreeNode( ( (
              QueryMessage) e.getOldValue()).getQuery());
          this.queryTree.setRoot(root);
          ArrayList resultset = this.mergeQueryResults((ArrayList) e.getNewValue());
          for (int x = 0; x < resultset.size(); x++) {
            FileTupleGroup ftg = (FileTupleGroup) resultset.get(x);
            DefaultMutableTreeNode nodeftg = new DefaultMutableTreeNode(ftg);
            this.queryTree.insertNodeInto(nodeftg, root, x);
            for (int y = 0; y < ftg.tuples.size(); y++) {
              this.queryTree.insertNodeInto(new DefaultMutableTreeNode(ftg.
                  tuples.
                  get(y)), nodeftg, y);
            }
          }
          this.queryTree.reload();
        }
      }
    }
  }

  public ArrayList mergeQueryResults(ArrayList resultSet){
    ArrayList tupleGroups = this.currentResultSet;
    for(int x=0; x < resultSet.size(); x++){
      if(resultSet.get(x) instanceof QueryCompletedFileTuple){
        if(tupleGroups.contains((QueryCompletedFileTuple)resultSet.get(x))){
          FileTupleGroup ftg = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryCompletedFileTuple)resultSet.get(x)));
          ftg.tuples.add(resultSet.get(x));
        }else{
          QueryCompletedFileTuple qft = (QueryCompletedFileTuple)resultSet.get(x);
          FileTupleGroup ftg = new FileTupleGroup(qft.getFileHash(),qft.getSize());
          ftg.tuples.add(qft);
          tupleGroups.add(ftg);
        }
      }else if(resultSet.get(x) instanceof QueryPartialFileTuple){
        if(tupleGroups.contains((QueryPartialFileTuple)resultSet.get(x))){
          FileTupleGroup ftg = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryPartialFileTuple)resultSet.get(x)));
          ftg.tuples.add(resultSet.get(x));
        }else{
          QueryPartialFileTuple qpft = (QueryPartialFileTuple)resultSet.get(x);
          FileTupleGroup ftg = new FileTupleGroup(qpft.getFileHash(),qpft.getSize());
          ftg.tuples.add(qpft);
          tupleGroups.add(ftg);
        }
      }
    }
    return tupleGroups;
  }

  void jButton2_actionPerformed(ActionEvent e) {
    QueryAntPanel qap = new QueryAntPanel(this.container);
    this.container.queryPanels.add(qap);
    this.container.jTabbedPane1.add("Query", qap);
    this.container.cap.warriorAnt.getPropertyChangeSupport().
        addPropertyChangeListener(qap);
  }

  void jTree1_mousePressed(MouseEvent e) {
    int selRow = jTree1.getRowForLocation(e.getX(), e.getY());
    TreePath selPath = jTree1.getPathForLocation(e.getX(), e.getY());
    if (selRow != -1) {
      if (e.getClickCount() == 1 && e.getButton() == MouseEvent.BUTTON3) {
        //mySingleClick(selRow, selPath);
        if ( ( (DefaultMutableTreeNode) selPath.getLastPathComponent()).
            getUserObject()instanceof QueryCompletedFileTuple) {
          QueryCompletedFileTuple fileToDownload = (QueryCompletedFileTuple) ( (
              DefaultMutableTreeNode) selPath.getLastPathComponent()).
              getUserObject();
          AntPopupMenu popup = new AntPopupMenu(this, fileToDownload, selRow,
                                                selPath);
          popup.show(e.getComponent(), e.getX(), e.getY());
        }else if ( ( (DefaultMutableTreeNode) selPath.getLastPathComponent()).
            getUserObject()instanceof QueryPartialFileTuple) {
          QueryPartialFileTuple partialFileToDownload = (QueryPartialFileTuple) ( (
              DefaultMutableTreeNode) selPath.getLastPathComponent()).
              getUserObject();
          AntPopupMenu popup = new AntPopupMenu(this, partialFileToDownload, selRow,
                                                selPath);
          popup.show(e.getComponent(), e.getX(), e.getY());
        }
      }
      else if (e.getClickCount() == 2) {

      }
    }
  }

  void jButton3_actionPerformed(ActionEvent e) {
    try {
      this.currentResultSet = new ArrayList();
      String query = this.jTextField1.getText();
      if(query == null || query.equals("")) return;
      QueryHashItem qsi = new QueryHashItem(null, query);
      AsymmetricProvider ap = new AsymmetricProvider(false);
      this.currentQuery = (QueryMessage)this.container.cap.warriorAnt.doQuery(
          qsi, ap.getPublicHeader(), WarriorAnt.queryTimeToLive).getMessage();
      this.jLabel2.setText("Last search (by hash): " + this.jTextField1.getText());
      Component[] tabs = this.container.jTabbedPane1.getComponents();
      for (int x = 0; x < tabs.length; x++) {
        if (tabs[x] == this) {
          int max = this.jTextField1.getText().length();
          if (max > 10)
            max = 10;
          this.container.jTabbedPane1.setTitleAt(x,
                                                 "Query: " +
                                                 this.jTextField1.getText().
                                                 substring(0, max));
          return;
        }
      }
    }
    catch (Exception ex) {
      _logger.error("",ex);
    }
  }

  void jSlider1_stateChanged(ChangeEvent e) {
    WarriorAnt.queryTimeToLive = this.jSlider1.getValue();
    int primeSum = 0;
    int x = 0;
    while (x < Router.timeToLiveDecreaseRounds) {
      primeSum += Router.primes[Router.timeToLiveDecreaseFactorIndex];
      x++;
    }
    this.jLabel4.setText("Query accuracy setting: " +
                         (WarriorAnt.queryTimeToLive /
                          (primeSum / 2)));
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (buffer != null) {
      int posX = (this.getWidth() - 650) / 2;
      int posY = (this.getHeight() - 550) / 2;
      if(posX < 0) posX = 0;
      if(posY < 0) posY = 0;
      g.drawImage(buffer, posX, posY, this);
    }
  }

  void this_componentResized(ComponentEvent e) {
    this.jPanel1.setPreferredSize(new Dimension(this.getWidth(),this.jPanel1.getHeight()));
    this.jPanel1.setSize(new Dimension(this.getWidth(),this.jPanel1.getHeight()));
    this.jPanel2.setPreferredSize(new Dimension(this.getWidth(),this.jPanel2.getHeight()));
    this.jPanel2.setSize(new Dimension(this.getWidth(),this.jPanel2.getHeight()));
    this.jScrollPane1.setPreferredSize(new Dimension(this.getWidth()-50, this.getHeight() - 250));
    this.jScrollPane1.setSize(new Dimension(this.getWidth()-50, this.getHeight() - 250));
  }
}

class QueryAntPanel_jButton1_actionAdapter implements java.awt.event.ActionListener {
  QueryAntPanel adaptee;

  QueryAntPanel_jButton1_actionAdapter(QueryAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    final ActionEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jButton1_actionPerformed(event);
        return null;
      }
    };
    worker.start();
  }
}

class QueryAntPanel_jButton2_actionAdapter implements java.awt.event.ActionListener {
  QueryAntPanel adaptee;

  QueryAntPanel_jButton2_actionAdapter(QueryAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}

class QueryAntPanel_jTree1_mouseAdapter extends java.awt.event.MouseAdapter {
  QueryAntPanel adaptee;

  QueryAntPanel_jTree1_mouseAdapter(QueryAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jTree1_mousePressed(e);
  }
}

class QueryAntPanel_jButton3_actionAdapter implements java.awt.event.ActionListener {
  QueryAntPanel adaptee;

  QueryAntPanel_jButton3_actionAdapter(QueryAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    final ActionEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jButton3_actionPerformed(event);
        return null;
      }
    };
    worker.start();
  }
}

class QueryAntPanel_jSlider1_changeAdapter implements javax.swing.event.ChangeListener {
  QueryAntPanel adaptee;

  QueryAntPanel_jSlider1_changeAdapter(QueryAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.jSlider1_stateChanged(e);
  }
}

class QueryAntPanel_this_componentAdapter extends java.awt.event.ComponentAdapter {
  QueryAntPanel adaptee;

  QueryAntPanel_this_componentAdapter(QueryAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}