//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.awt.*;
import javax.swing.*;
import java.util.*;
import java.awt.event.*;

import org.apache.log4j.*;

public class GuiAnt extends JPanel {

  static Logger _logger = Logger.getLogger(GuiAnt.class.getName());

  JTabbedPane jTabbedPane1 = new JTabbedPane();
  ConnectionAntPanel cap;
  DebugSettingsAntPane dsap;
  SettingsAntPanel sap;
  DownloadAntPanel dap;
  UploadAntPanel uap;
  ShareAntPanel shareap;
  StartUp aboutPanel;
  ArrayList queryPanels = new ArrayList();
  DoubleBuffer animationPanel;
  FlowLayout flowLayout1 = new FlowLayout(FlowLayout.LEFT);

  public GuiAnt() {
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
  }

  public ConnectionAntPanel getConnectionAntPanel(){
    return this.cap;
  }

  public SettingsAntPanel getSettingsAntPanel(){
    return this.sap;
  }

  void jbInit() throws Exception {
    animationPanel = new DoubleBuffer();
    if(!animationPanel.getReady()){
      animationPanel = null;
    }
    aboutPanel = new StartUp();
    cap = new ConnectionAntPanel(this);
    sap = new SettingsAntPanel(this);
    dsap = new DebugSettingsAntPane();
    shareap = new ShareAntPanel();
    this.setOpaque(true);
    this.addComponentListener(new GuiAnt_this_componentAdapter(this));
    this.setLayout(flowLayout1);
    //jTabbedPane1.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
    jTabbedPane1.addComponentListener(new GuiAnt_jTabbedPane1_componentAdapter(this));
    jTabbedPane1.setRequestFocusEnabled(true);
    jTabbedPane1.addMouseListener(new GuiAnt_jTabbedPane1_mouseAdapter(this));
    jTabbedPane1.add("Connection",cap);
    jTabbedPane1.add("About",aboutPanel);
    this.add(jTabbedPane1, null);
  }

  void jTabbedPane1_mousePressed(MouseEvent e) {
    if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON3) {
      Component comp = this.jTabbedPane1.getSelectedComponent();
      if(comp instanceof QueryAntPanel){
        this.jTabbedPane1.remove(this.jTabbedPane1.getSelectedComponent());
      }else if(comp instanceof SettingsAntPanel || comp instanceof DebugSettingsAntPane){
        this.jTabbedPane1.remove(this.jTabbedPane1.getSelectedComponent());
      }else if(comp instanceof ShareAntPanel){
        this.jTabbedPane1.remove(this.jTabbedPane1.getSelectedComponent());
      }
    }
  }

  public JTabbedPane getTabbedPane(){
    return this.jTabbedPane1;
  }

  void this_componentResized(ComponentEvent e) {
    this.jTabbedPane1.setPreferredSize(new Dimension(e.getComponent().getWidth()-10,e.getComponent().getHeight()-10));
    this.jTabbedPane1.setSize(new Dimension(e.getComponent().getWidth()-10,e.getComponent().getHeight()-10));
  }

  void jTabbedPane1_componentResized(ComponentEvent e) {
    for(int x = 0; x < this.jTabbedPane1.getTabCount(); x++){
      ((JPanel)this.jTabbedPane1.getComponentAt(x)).setPreferredSize(e.getComponent().getSize());
      ((JPanel)this.jTabbedPane1.getComponentAt(x)).setSize(e.getComponent().getSize());
    }
  }

}

class GuiAnt_jTabbedPane1_mouseAdapter extends java.awt.event.MouseAdapter {
  GuiAnt adaptee;

  GuiAnt_jTabbedPane1_mouseAdapter(GuiAnt adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jTabbedPane1_mousePressed(e);
  }
}

class GuiAnt_this_componentAdapter extends java.awt.event.ComponentAdapter {
  GuiAnt adaptee;

  GuiAnt_this_componentAdapter(GuiAnt adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}

class GuiAnt_jTabbedPane1_componentAdapter extends java.awt.event.ComponentAdapter {
  GuiAnt adaptee;

  GuiAnt_jTabbedPane1_componentAdapter(GuiAnt adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.jTabbedPane1_componentResized(e);
  }
}