//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.tree.*;
import java.security.*;
import java.security.spec.*;
import java.security.interfaces.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import javax.crypto.interfaces.*;
import java.io.*;

import ants.p2p.security.*;
import ants.p2p.*;

import org.apache.log4j.*;

public class FrameAnt extends JFrame {
  static FrameAnt instance;
  GuiAnt ga;
  public static int WIDTH = 600;
  public static int HEIGHT = 600;

  static
  {
    File properties = new File("Log.properties");
    if (properties.exists()) {
      PropertyConfigurator.configure("Log.properties");
    }
    else {
      BasicConfigurator.configure();
    }
  }

  static Logger _logger = Logger.getLogger(FrameAnt.class.getName());

  FrameAnt(String title) {
    super(title);
    instance = this;
    try {
      jbInit();
    }
    catch(Exception e) {
      _logger.error("",e);
    }
  }

  public GuiAnt getGuiAnt(){
    return ga;
  }

  public static FrameAnt getInstance(String title){
    if(instance == null){
      return instance = new FrameAnt(title);
    }else{
      return instance;
    }
  }

  public static void main(String args[]){
    _logger.info("Running VM: " + System.getProperty("java.version"));
    _logger.info("Running DIR: " + System.getProperty("java.home"));
    try{
      _logger.info("Checking cipher..............");
      Cipher cipher = Cipher.getInstance(EndpointSecurityManager.cipher);
      _logger.info("Cipher OK");
      _logger.info("Checking key size............");
      byte[] key = new byte[EndpointSecurityManager.cipherKeySize];
      SecretKeySpec secKey = new SecretKeySpec(key,
                                               EndpointSecurityManager.cipher);
      cipher.init(Cipher.ENCRYPT_MODE, secKey);
      _logger.info("Key size OK");
    }catch(Exception e){
      _logger.error("Some features needed by ANts are not supported by current VM",e);
    }
    _logger.info("Initializing ANTs............");
    FrameAnt fa = FrameAnt.getInstance("Ants P2P - version " +
                                       WarriorAnt.getVersion());
    fa.show();
    fa.validateTree();
  }

  public FrameAnt() {
    try {
      jbInit();
    }
    catch(Exception e) {
      _logger.error("",e);
    }
  }
  private void jbInit() throws Exception {
    this.setResizable(true);
    this.addComponentListener(new FrameAnt_this_componentAdapter(this));
    this.addWindowListener(new FrameAnt_this_windowAdapter(this));
    ga = new GuiAnt();
    this.getContentPane().add(ga);

    Image ico = null;
    if(this.ga.animationPanel != null){
      ico = this.ga.animationPanel.getIcon();
    }

    if(ico!=null){
      this.setIcon(ico);
    }

    if(this.ga.sap.autoStartANts()){
      _logger.info("Autostart enabled: running ANts");
      final SwingWorker worker = new SwingWorker() {
        public Object construct() {
          ga.cap.startANts();
          return null;
        }
      };
      worker.start();
    }

    reshape(100,100,650,550);
  }

  public void setIcon(Image ico){
    if(ico!=null){
      try{
        this.setIconImage(ico);
      }catch(Exception e){}
    }
  }

  void this_windowClosing(WindowEvent e) {
    if(this.ga.cap.warriorAnt != null){
      this.ga.cap.warriorAnt.disconnectWarrior();
    }
    /*
    if(this.ga.dap != null){
      Enumeration inDownloadFiles = this.ga.dap.downloadRoot.children();
      ArrayList threadToJoin = new ArrayList();
      while (inDownloadFiles.hasMoreElements()) {
        DefaultMutableTreeNode inDownload = ( (DefaultMutableTreeNode)
                                             inDownloadFiles.nextElement());
        MultipleSourcesDownloadManager msdm = ( (MultipleSourcesDownloadManager)
                                               inDownload.getUserObject());
        while (msdm.isAlive()) {
          try {
            msdm.setInterrupt();
            Thread.sleep(1000);
          }
          catch (Exception ex) {
            _logger.error("",ex);
          }
        }
        this.ga.dap.downloadTree.removeNodeFromParent(inDownload);
        this.ga.dap.jTree1.setModel(this.ga.dap.downloadTree);
        this.ga.dap.downloadTree.reload();
        this.ga.dap.repaint();
        this.ga.dap.interruptedRoot.add(new DefaultMutableTreeNode(new
            InterruptedDownload(msdm)));
        this.ga.dap.jTree2.setModel(this.ga.dap.interruptedTree);
        this.ga.dap.interruptedTree.reload();
        this.ga.dap.repaint();
      }
    }
    */
    if (this.ga.cap.ircBot != null) {
      this.ga.cap.ircBot.disconnect();
      this.ga.sap.setIrcConnected(false);
      this.ga.sap.setIrcEnabled(false);
    }
    System.exit(0);
  }

  void this_componentResized(ComponentEvent e) {
    this.ga.setPreferredSize(this.getContentPane().getSize());
    this.ga.setSize(this.getContentPane().getSize());
  }
}

class FrameAnt_this_windowAdapter extends java.awt.event.WindowAdapter {
  FrameAnt adaptee;

  FrameAnt_this_windowAdapter(FrameAnt adaptee) {
    this.adaptee = adaptee;
  }
  public void windowClosing(WindowEvent e) {
    adaptee.this_windowClosing(e);
  }
}

class FrameAnt_this_componentAdapter extends java.awt.event.ComponentAdapter {
  FrameAnt adaptee;

  FrameAnt_this_componentAdapter(FrameAnt adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}