//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.beans.*;
import java.io.*;

import ants.p2p.*;
import ants.p2p.query.*;

import com.borland.jbcl.layout.*;

import org.apache.log4j.*;
import javax.swing.border.*;

public class DownloadAntPanel extends JPanel implements PropertyChangeListener{
  public static String pic = "./backgrounds/bg2.jpg";
  static Logger _logger = Logger.getLogger(DownloadAntPanel.class.getName());

  Image buffer;
  JScrollPane jScrollPane1 = new JScrollPane();
  JScrollPane jScrollPane2 = new JScrollPane();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  DefaultMutableTreeNode downloadRoot = new DefaultMutableTreeNode("Downloads");
  DefaultMutableTreeNode interruptedRoot = new DefaultMutableTreeNode("Interrupted");
  DefaultTreeModel downloadTree = new DefaultTreeModel(null);
  DefaultTreeModel interruptedTree = new DefaultTreeModel(null);
  JTree jTree1 = new JTree(downloadTree);
  JTree jTree2 = new JTree(interruptedTree);
  GuiAnt container;
  Border border1;
  FlowLayout flowLayout1 = new FlowLayout(FlowLayout.CENTER);

  public DownloadAntPanel(GuiAnt container) {
    this.container=container;
    try{
      Toolkit tk = Toolkit.getDefaultToolkit();
      MediaTracker mt = new MediaTracker(this);
      buffer = tk.getImage(pic);
      mt.waitForAll();
    }catch(Exception e){}
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
  }
  void jbInit() throws Exception {
    border1 = BorderFactory.createEmptyBorder(20,20,20,20);
    downloadTree.setRoot(downloadRoot);
    interruptedTree.setRoot(interruptedRoot);
    this.setLayout(flowLayout1);
    jLabel1.setPreferredSize(new Dimension(400, 15));
    jLabel1.setText("Downloading...");
    jLabel2.setAlignmentX((float) 0.0);
    jLabel2.setAlignmentY((float) 0.5);
    jLabel2.setPreferredSize(new Dimension(400, 15));
    jLabel2.setText("Interrupted...");
    jTree1.addMouseListener(new DownloadAntPanel_jTree1_mouseAdapter(this));
    jTree2.addMouseListener(new DownloadAntPanel_jTree2_mouseAdapter(this));
    jTree1.setFont(new java.awt.Font("Monospaced", 0, 11));
    jTree1.setOpaque(true);
    jTree1.setRootVisible(false);
    jScrollPane2.setOpaque(true);
    jScrollPane2.setPreferredSize(new Dimension(400, 200));
    this.setBorder(border1);
    this.addComponentListener(new DownloadAntPanel_this_componentAdapter(this));
    jScrollPane1.setPreferredSize(new Dimension(400, 200));
    jTree2.setFont(new java.awt.Font("Monospaced", 0, 11));
    jTree2.setRootVisible(false);
    jScrollPane1.getViewport().add(jTree1, null);
    jScrollPane2.getViewport().add(jTree2, null);
    this.add(jLabel1, null);
    this.add(jScrollPane1, null);
    this.add(jLabel2, null);
    this.add(jScrollPane2, null);
    this.loadInterrupted();
    this.container.cap.warriorAnt.propertyChangeSupport.addPropertyChangeListener(this);
  }

  private void loadInterrupted(){
    WarriorAnt.checkChunksPath();
    File currentDirectory = new File(WarriorAnt.chunksPath);
    if(currentDirectory.exists() && currentDirectory.isDirectory()){
      File[] interrupted = currentDirectory.listFiles();
      for(int x = 0; x < interrupted.length; x++){
        if (interrupted[x].getName().lastIndexOf(".mul")==interrupted[x].getName().length()-".mul".length()){
          InterruptedDownload interruptedDownload = new InterruptedDownload(interrupted[x]);
          if(this.container.sap.autoResumeOnRun()){
            AutoresumeEngine ae = new AutoresumeEngine(interruptedDownload,
                this.container.cap.warriorAnt, this);
          }
          this.interruptedRoot.add(new DefaultMutableTreeNode(interruptedDownload));
        }
      }
      this.jTree2.setModel(this.interruptedTree);
      this.interruptedTree.reload();
      this.repaint();
    }
  }

  public void interruptAllDownloads(){
    DefaultMutableTreeNode[] msdmInDownload = new
        DefaultMutableTreeNode[this.downloadRoot.
        getChildCount()];
    for (int x = 0; x < msdmInDownload.length; x++) {
      msdmInDownload[x] = (DefaultMutableTreeNode)this.container.
          dap.downloadRoot.getChildAt(x);
    }
    for (int x = 0; x < msdmInDownload.length; x++) {
      MultipleSourcesDownloadManager currentNode = (
          MultipleSourcesDownloadManager) msdmInDownload[x].getUserObject();
      currentNode.setInterrupt(true);
      this.downloadTree.removeNodeFromParent(msdmInDownload[x]);
      this.jTree1.setModel(this.downloadTree);
      this.downloadTree.reload();
      this.repaint();
      InterruptedDownload interruptedDownload = new
          InterruptedDownload(currentNode);
      if (currentNode.isAutoresumeActive()) {
        currentNode.getAutoresumeEngine().setInterruptedDownload(
            interruptedDownload);
      }
      this.interruptedRoot.add(new DefaultMutableTreeNode(interruptedDownload));
      this.jTree2.setModel(this.interruptedTree);
      this.interruptedTree.reload();
      this.repaint();
      return;
    }
    DefaultMutableTreeNode[] msdmInterrupted = new
        DefaultMutableTreeNode[this.interruptedRoot.
        getChildCount()];
    for (int x = 0; x < msdmInterrupted.length; x++) {
      msdmInterrupted[x] = (DefaultMutableTreeNode)this.interruptedRoot.
          getChildAt(x);
    }
    for (int x = 0; x < msdmInterrupted.length; x++) {
      InterruptedDownload currentNode = (
          InterruptedDownload) msdmInterrupted[x].
          getUserObject();
      currentNode.deactivateAutoresumeEngine();
    }
  }

  public void propertyChange(PropertyChangeEvent e) {
    if (e.getPropertyName().equals("filePartDownloadCompleted")) {
      //this.downloadTree.reload();
      this.repaint();
    }
    if (e.getPropertyName().equals("multipleDownloadTimedOut")) {
      synchronized (this) {
        DefaultMutableTreeNode[] msdmInDownload = new
            DefaultMutableTreeNode[this.downloadRoot.
            getChildCount()];
        for (int x = 0; x < msdmInDownload.length; x++) {
          msdmInDownload[x] = (DefaultMutableTreeNode)this.container.
              dap.downloadRoot.getChildAt(x);
        }
        for (int x = 0; x < msdmInDownload.length; x++) {
          MultipleSourcesDownloadManager currentNode = (
              MultipleSourcesDownloadManager) msdmInDownload[x].getUserObject();
          if (currentNode.equals(e.getNewValue())) {
            currentNode.setInterrupt(false);
            this.downloadTree.removeNodeFromParent(msdmInDownload[x]);
            this.jTree1.setModel(this.downloadTree);
            this.downloadTree.reload();
            this.repaint();
            InterruptedDownload interruptedDownload = new
                InterruptedDownload(currentNode);
            if (currentNode.isAutoresumeActive()) {
              currentNode.getAutoresumeEngine().setInterruptedDownload(interruptedDownload);
            }
            this.interruptedRoot.add(new DefaultMutableTreeNode(
                interruptedDownload));
            this.jTree2.setModel(this.interruptedTree);
            this.interruptedTree.reload();
            this.repaint();
          }
        }
      }
    }
    if (e.getPropertyName().equals("removedSourcePeer")) {
      synchronized (this) {
        DefaultMutableTreeNode[] msdmInDownload = new
            DefaultMutableTreeNode[this.downloadRoot.
            getChildCount()];
        for (int x = 0; x < msdmInDownload.length; x++) {
          msdmInDownload[x] = (DefaultMutableTreeNode)this.container.
              dap.downloadRoot.getChildAt(x);
        }
        for (int x = 0; x < msdmInDownload.length; x++) {
          MultipleSourcesDownloadManager currentNode = (
              MultipleSourcesDownloadManager) msdmInDownload[x].getUserObject();
          if (currentNode.equals(e.getOldValue())) {
            if (currentNode.getPeersNumber() > 0) {
              DefaultMutableTreeNode queryFileTuple = null;
              for (int y = 0; y < msdmInDownload[x].getChildCount(); y++) {
                DefaultMutableTreeNode currentChild = (DefaultMutableTreeNode)
                    msdmInDownload[x].getChildAt(y);
                if ( ( (QueryFileTuple) currentChild.getUserObject()).
                    getOwnerID().equals(e.getNewValue())) {
                  this.downloadTree.removeNodeFromParent(currentChild);
                }
              }
              this.repaint();
              return;
            }
            else {
              currentNode.setInterrupt(false);
              this.downloadTree.removeNodeFromParent(msdmInDownload[x]);
              this.jTree1.setModel(this.downloadTree);
              this.downloadTree.reload();
              this.repaint();
              InterruptedDownload interruptedDownload = new
                  InterruptedDownload(currentNode);
              if (currentNode.isAutoresumeActive()) {
                /*currentNode.deactivateAutoresumeEngine();
                AutoresumeEngine ae = new AutoresumeEngine(interruptedDownload,
                    this.container.cap.warriorAnt);
                ae.pcs.addPropertyChangeListener(this);
                interruptedDownload.addAutoresumeEngine(ae);*/
                currentNode.getAutoresumeEngine().setInterruptedDownload(interruptedDownload);
              }
              this.interruptedRoot.add(new DefaultMutableTreeNode(
                  interruptedDownload));
              this.jTree2.setModel(this.interruptedTree);
              this.interruptedTree.reload();
              this.repaint();
              return;
            }
          }
        }
      }
    }
    /*
    if (e.getPropertyName().equals("multipleDownloadStalled")) {
      DefaultMutableTreeNode msdmInDownload = null;
      MultipleSourcesDownloadManager msdm = null;
      for (int x = 0; x < this.downloadRoot.getChildCount(); x++) {
        msdmInDownload = (DefaultMutableTreeNode)this.downloadRoot.getChildAt(x);
        msdm = ( (MultipleSourcesDownloadManager) msdmInDownload.getUserObject());
        if (msdm.getFileHash().equals( ( (MultipleSourcesDownloadManager) e.
                                        getNewValue()).getFileHash())) {
          msdmInDownload = (DefaultMutableTreeNode)this.downloadRoot.getChildAt(
              x);
          this.downloadTree.removeNodeFromParent(msdmInDownload);
          this.jTree1.setModel(this.downloadTree);
          this.downloadTree.reload();
          this.repaint();
          break;
        }
      }
      if (msdm != null) {
        this.interruptedRoot.add(new DefaultMutableTreeNode(new
            InterruptedDownload(msdm)));
        this.jTree2.setModel(this.interruptedTree);
        this.interruptedTree.reload();
        this.repaint();
      }
    }*/
    if (e.getPropertyName().equals("securityConnectionError")) {
      //Interrompi tutti i download
      synchronized (this) {
        DefaultMutableTreeNode[] msdmInDownload = new
            DefaultMutableTreeNode[this.downloadRoot.
            getChildCount()];
        for (int x = 0; x < msdmInDownload.length; x++) {
          msdmInDownload[x] = (DefaultMutableTreeNode)this.container.
              dap.downloadRoot.getChildAt(x);
        }
        /*
               DefaultMutableTreeNode[] msdmInterrupted = new
            DefaultMutableTreeNode[this.interruptedRoot.
            getChildCount()];
               for (int x = 0; x < msdmInterrupted.length; x++) {
          msdmInterrupted[x] = (DefaultMutableTreeNode)this.container.
              dap.interruptedRoot.getChildAt(x);
               }*/
        for (int x = 0; x < msdmInDownload.length; x++) {
          MultipleSourcesDownloadManager currentNode = (
              MultipleSourcesDownloadManager) msdmInDownload[x].getUserObject();
          currentNode.setInterrupt(false);
          currentNode.deactivateAutoresumeEngine();
          this.interruptedRoot.add(new DefaultMutableTreeNode(new
              InterruptedDownload( (
              MultipleSourcesDownloadManager) msdmInDownload[x].getUserObject())));
        }
        /*
              for (int x = 0; x < msdmInterrupted.length; x++) {
        MultipleSourcesDownloadManager currentNode = (
            MultipleSourcesDownloadManager) msdmInterrupted[x].
            getUserObject();
        currentNode.stop();
              }*/
       this.downloadRoot.removeAllChildren();
        this.jTree1.setModel(this.downloadTree);
        this.downloadTree.reload();
        this.jTree2.setModel(this.interruptedTree);
        this.interruptedTree.reload();
        this.repaint();
      }
    }
    if (e.getPropertyName().equals("addSourcePeer")) {
      try {
        synchronized (this) {
          DefaultMutableTreeNode[] msdmInDownload = new
              DefaultMutableTreeNode[this.downloadRoot.
              getChildCount()];
          QueryFileTuple fileToDownload = (QueryFileTuple) e.getNewValue();
          AutoresumeEngine oldAe = (AutoresumeEngine) e.getOldValue();
          for (int x = 0; x < msdmInDownload.length; x++) {
            msdmInDownload[x] = (DefaultMutableTreeNode)this.downloadRoot.
                getChildAt(x);
          }
          DefaultMutableTreeNode[] msdmInterrupted = new
              DefaultMutableTreeNode[this.interruptedRoot.
              getChildCount()];
          for (int x = 0; x < msdmInterrupted.length; x++) {
            msdmInterrupted[x] = (DefaultMutableTreeNode)this.interruptedRoot.
                getChildAt(x);
          }
          for (int x = 0; x < msdmInDownload.length; x++) {
            MultipleSourcesDownloadManager currentNode = (
                MultipleSourcesDownloadManager) msdmInDownload[x].getUserObject();
            if (currentNode.getFileHash().equals(fileToDownload.getFileHash())) {
              if (currentNode.addPeer(fileToDownload)) {
                msdmInDownload[x].add(new DefaultMutableTreeNode(fileToDownload));
                this.jTree1.setModel(this.downloadTree);
                this.downloadTree.reload();
                this.repaint();
                return;
              }
              else
                return;
            }
          }
          for (int x = 0; x < msdmInterrupted.length; x++) {
            InterruptedDownload currentNode = (
                InterruptedDownload) msdmInterrupted[x].
                getUserObject();
            if (currentNode.getFileHash().equals(fileToDownload.getFileHash())) {
              MultipleSourcesDownloadManager msdm = new
                  MultipleSourcesDownloadManager(this.container.cap.
                                                 warriorAnt,
                                                 currentNode.getFileName(),
                                                 currentNode.getFileHash(),
                                                 currentNode.getByteDownloaded(),
                                                 currentNode.getBlockSize(),
                                                 currentNode.getFileSize());
              if (msdm.addPeer(fileToDownload)) {
                DefaultMutableTreeNode fileGroup = new DefaultMutableTreeNode(
                    msdm);
                fileGroup.add(new DefaultMutableTreeNode(fileToDownload));
                this.downloadRoot.add(fileGroup);
                this.jTree1.setModel(this.downloadTree);
                //this.callerQuery.container.dap.downloadTree.reload();
                this.repaint();
                msdm.start();
                this.interruptedTree.
                    removeNodeFromParent(
                    msdmInterrupted[x]);
                this.jTree2.setModel(this.interruptedTree);
                this.downloadTree.reload();
                this.repaint();
                msdm.propertyChangeSupport.addPropertyChangeListener(this);
                if (oldAe != null && oldAe.isAlive()) {
                  //oldAe.deactivate();
                  oldAe.setMultipleSourcesDownloadManager(msdm);
                }else{
                  AutoresumeEngine ae = new AutoresumeEngine(msdm, this);
                }
              }
              return;
            }
          }

          MultipleSourcesDownloadManager currentNode = new
              MultipleSourcesDownloadManager(this.container.cap.
                                             warriorAnt,
                                             fileToDownload.getFileName(),
                                             fileToDownload.getFileHash(), 0L,
                                             WarriorAnt.blockSizeInDownload,
                                             fileToDownload.getSize().
                                             longValue());
          DefaultMutableTreeNode fileGroup = new DefaultMutableTreeNode(
              currentNode);
          if (currentNode.addPeer(fileToDownload)) {
            fileGroup.add(new DefaultMutableTreeNode(fileToDownload));
            this.downloadRoot.add(fileGroup);
            this.jTree1.setModel(this.downloadTree);
            this.downloadTree.reload();
            this.repaint();
            currentNode.propertyChangeSupport.addPropertyChangeListener(this);
            currentNode.start();
            AutoresumeEngine ae = new AutoresumeEngine(currentNode, this);
          }
          return;
        }
      }catch(Exception ex){
        _logger.error("Error in DownloadAntPanel refresh after a peer adding", ex);
      }
    }
  }

  void jTree1_mousePressed(MouseEvent e) {
    int selRow = jTree1.getRowForLocation(e.getX(), e.getY());
    TreePath selPath = jTree1.getPathForLocation(e.getX(), e.getY());
    if (selRow != -1) {
      if (e.getClickCount() == 1 && e.getButton() == MouseEvent.BUTTON3) {
        //mySingleClick(selRow, selPath);
        if ( ( (DefaultMutableTreeNode) selPath.getLastPathComponent()).
            getUserObject()instanceof MultipleSourcesDownloadManager) {
          MultipleSourcesDownloadManager downloader = (
              MultipleSourcesDownloadManager) ( (
              DefaultMutableTreeNode) selPath.getLastPathComponent()).
              getUserObject();
          AntPopupMenu popup = new AntPopupMenu(this, downloader, selRow,
                                                selPath);
          popup.show(e.getComponent(), e.getX(), e.getY());
        }
        else if ( ( (DefaultMutableTreeNode) selPath.getLastPathComponent()).
                 getUserObject()instanceof QueryFileTuple) {
         QueryFileTuple source = (QueryFileTuple) ( (
             DefaultMutableTreeNode) selPath.getLastPathComponent()).
             getUserObject();
         MultipleSourcesDownloadManager downloader = (
              MultipleSourcesDownloadManager) ( (
              DefaultMutableTreeNode) selPath.getParentPath().getLastPathComponent()).
              getUserObject();
         AntPopupMenu popup = new AntPopupMenu(this, source, downloader,
                                               selRow, selPath);
         popup.show(e.getComponent(), e.getX(), e.getY());
       }
      }
      else if (e.getClickCount() == 2) {

      }
    }
  }

  void jTree2_mousePressed(MouseEvent e) {
    int selRow = jTree2.getRowForLocation(e.getX(), e.getY());
    TreePath selPath = jTree2.getPathForLocation(e.getX(), e.getY());
    if (selRow != -1) {
      if (e.getClickCount() == 1 && e.getButton() == MouseEvent.BUTTON3) {
        //mySingleClick(selRow, selPath);
        if ( ( (DefaultMutableTreeNode) selPath.getLastPathComponent()).
            getUserObject()instanceof InterruptedDownload) {
          InterruptedDownload toBeProcessed = (
              InterruptedDownload) ( (
              DefaultMutableTreeNode) selPath.getLastPathComponent()).
              getUserObject();
          AntPopupMenu popup = new AntPopupMenu(this, toBeProcessed, selRow,
                                                selPath);
          popup.show(e.getComponent(), e.getX(), e.getY());
        }
      }
      else if (e.getClickCount() == 2) {

      }
    }
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (buffer != null){
      int posX = (this.getWidth() - 650)/2;
      int posY = (this.getHeight() - 550)/2;
      if(posX < 0) posX = 0;
      if(posY < 0) posY = 0;
      g.drawImage(buffer, posX, posY, this);
    }
  }

  void this_componentResized(ComponentEvent e) {
    this.jLabel1.setPreferredSize(new Dimension(this.getWidth()-40, this.jLabel1.getHeight()));
    this.jLabel2.setPreferredSize(new Dimension(this.getWidth()-40, this.jLabel2.getHeight()));
    this.jScrollPane1.setPreferredSize(new Dimension(this.getWidth()-40, (this.getHeight()-100)/2));
    this.jScrollPane2.setPreferredSize(new Dimension(this.getWidth()-40, (this.getHeight()-100)/2));
    this.jLabel1.setSize(new Dimension(this.getWidth()-40, this.jLabel1.getHeight()));
    this.jLabel2.setSize(new Dimension(this.getWidth()-40, this.jLabel2.getHeight()));
    this.jScrollPane1.setSize(new Dimension(this.getWidth()-40, (this.getHeight()-100)/2));
    this.jScrollPane2.setSize(new Dimension(this.getWidth()-40, (this.getHeight()-100)/2));
  }
}

class DownloadAntPanel_jTree1_mouseAdapter extends java.awt.event.MouseAdapter {
  DownloadAntPanel adaptee;

  DownloadAntPanel_jTree1_mouseAdapter(DownloadAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jTree1_mousePressed(e);
  }
}

class DownloadAntPanel_jTree2_mouseAdapter extends java.awt.event.MouseAdapter {
  DownloadAntPanel adaptee;

  DownloadAntPanel_jTree2_mouseAdapter(DownloadAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jTree2_mousePressed(e);
  }
}

class DownloadAntPanel_this_componentAdapter extends java.awt.event.ComponentAdapter {
  DownloadAntPanel adaptee;

  DownloadAntPanel_this_componentAdapter(DownloadAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}