//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.awt.*;
import javax.swing.JPanel;
import java.io.*;

import org.apache.log4j.*;

public class DoubleBuffer extends JPanel implements Runnable{

    static Logger _logger = Logger.getLogger(DoubleBuffer.class.getName());

    //the next line declares the double buffering image
    Image[] images = new Image[3];
    Image icon;
    int frame = 0;
    Image buffer;
    boolean ready = false;
    //the next line declares the double buffering Graphics
    Graphics bufferg;
    //the next line creates a Thread named main
    Thread main;
    public DoubleBuffer(){
      for(int x = 0; x < images.length; x++){
        if(!(new File("./anims/ant" + x + ".jpg").exists()))
          return;
      }
      ready = true;
      setSize(100,200);
      Toolkit tk = Toolkit.getDefaultToolkit();
      MediaTracker mt = new MediaTracker(this);
      for (int x = 0; x < 3; x++) {
        images[x] = tk.getImage("./anims/ant" + x + ".jpg");
        mt.addImage(images[x], x);
        try {
          mt.waitForAll();
        }
        catch (InterruptedException e) {}
      }
      buffer = images[0];

      if(!(new File("./anims/ant_ico.jpg").exists()))
          return;
      icon = tk.getImage("./anims/ant_ico.jpg");
      mt.addImage(icon, 3);
      try {
        mt.waitForAll();
      }
      catch (InterruptedException e) {}
    }

    public boolean getReady(){
      return this.ready;
    }

    public Image getIcon(){
      return this.icon;
    }

    public void init(){
      try{
        //the next line starts the Thread named main, which
        //makes it execute the run() method
        main = new Thread(this);
        main.start();
      }
      catch(Exception e){_logger.error("",e);}
    }
    //the run method() occurs while a Thread is running
    public void run(){
        //the following while loop makes the code in the loop
        //repeat so that higher and higher numbers will be printed
        int x = 0;
        boolean frw = true;
        while(main!=null){
            if(frw) x++;
            else x--;
            if(x == 3) frw = false;
            if(x == 0) frw = true;
            //the following try and catch attempts to make the
            //Thread named main sleep for 50 milleseconds
            try{
              main.sleep(1000);
              buffer = images[x];
            }
            catch(Exception e){}
            //the next line tells the Applet to run the paint()
            //method again
            if(buffer!=null){
              this.repaint();
            }
        }
    }
    //the stop() method occurs when the Thread stops
    public void stop(){
        if(main!=null){main.stop();}
    }
    //the paint() method paints different things to the Applet
    public void paint(Graphics g){
        //the next line runs the update method
        update(g);
    }
    public void update(Graphics g){
        //the nextlin draws the Image named buffer on the applet
        //without this line, nothing will show up!
        if(buffer != null)
          g.drawImage(buffer,0,0,this);
    }
}
