//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;

import ants.p2p.*;

import com.borland.jbcl.layout.*;

import org.apache.log4j.*;

public class DebugSettingsAntPane extends JPanel {

  static Logger _logger = Logger.getLogger(DebugSettingsAntPane.class.getName());

  JPanel jPanel1 = new JPanel();
  XYLayout xYLayout2 = new XYLayout();
  JCheckBox jCheckBox1 = new JCheckBox();
  ButtonGroup buttonGroup1 = new ButtonGroup();
  JRadioButton jRadioButton1 = new JRadioButton();
  JRadioButton jRadioButton2 = new JRadioButton();
  JPanel jPanel2 = new JPanel();
  XYLayout xYLayout3 = new XYLayout();
  JPanel jPanel3 = new JPanel();
  XYLayout xYLayout4 = new XYLayout();
  JTextField jTextField10 = new JTextField();
  JTextField jTextField9 = new JTextField();
  JTextField jTextField13 = new JTextField();
  JTextField jTextField14 = new JTextField();
  JTextField jTextField8 = new JTextField();
  JTextField jTextField12 = new JTextField();
  JTextField jTextField11 = new JTextField();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JTextField jTextField4 = new JTextField();
  JTextField jTextField5 = new JTextField();
  JTextField jTextField6 = new JTextField();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();
  JLabel jLabel8 = new JLabel();
  JLabel jLabel9 = new JLabel();
  JLabel jLabel12 = new JLabel();
  JLabel jLabel10 = new JLabel();
  JLabel jLabel14 = new JLabel();
  JLabel jLabel15 = new JLabel();
  JLabel jLabel13 = new JLabel();
  JLabel jLabel11 = new JLabel();
  JLabel jLabel16 = new JLabel();
  JTextField jTextField7 = new JTextField();
  JLabel jLabel17 = new JLabel();
  JTextField jTextField15 = new JTextField();
  JLabel jLabel18 = new JLabel();
  JLabel jLabel19 = new JLabel();
  TitledBorder titledBorder1;
  JTextField jTextField16 = new JTextField();
  JComboBox jComboBox1 = new JComboBox();

  public DebugSettingsAntPane() {
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
    this.jTextField1.setText(""+Router.delay);
    this.jTextField2.setText(""+Router.timeToLive);
    this.jTextField3.setText(""+Router.efficiencyLimit);
    this.jTextField4.setText(""+Router.efficiencyModifier);
    this.jTextField5.setText(""+Router.inTransitQueue);
    this.jTextField6.setText(""+Router.ownDeliveredMessagesQueue);
    this.jTextField7.setText(""+Ant.maxNeighbours);
    this.jTextField8.setText(""+Ant.messageTimeout);
    this.jTextField9.setText(""+WarriorAnt.maxSecureConnections);
    this.jTextField10.setText(""+WarriorAnt.maxPullRequestsToServe);
    this.jTextField11.setText(""+Ant.maxFailedMessageToTrace);
    this.jTextField12.setText(""+Ant.maxRetransmissions);
    this.jTextField13.setText(""+MultipleSourcesDownloadManager.blocksPerSource);
    this.jTextField14.setText(""+MultipleSourcesDownloadManager.MaxSources);
    this.jTextField15.setText(""+WarriorAnt.blockSizeInDownload);
    this.jTextField16.setText(""+Ant.maxMessagesToRouteToghether);
    this.jPanel2.setVisible(false);
  }
  void jbInit() throws Exception {
    titledBorder1 = new TitledBorder("");
    jCheckBox1.setSelected(Router.PARALLEL);
    jPanel2.setLayout(xYLayout3);
    jPanel2.setBackground(Color.lightGray);
    jRadioButton1.addActionListener(new SettingsAntPane_jRadioButton1_actionAdapter(this));
    jRadioButton2.addActionListener(new SettingsAntPane_jRadioButton2_actionAdapter(this));
    jCheckBox1.addActionListener(new SettingsAntPane_jCheckBox1_actionAdapter(this));
    jRadioButton1.setSelected(true);
    jPanel3.setMaximumSize(new Dimension(32767, 32767));
    jPanel3.setLayout(xYLayout4);
    jTextField10.setMaximumSize(new Dimension(100, 2147483647));
    jTextField10.setMinimumSize(new Dimension(100, 21));
    jTextField10.setPreferredSize(new Dimension(100, 21));
    jTextField10.setText("jTextField7");
    jTextField10.addActionListener(new DebugSettingsAntPane_jTextField10_actionAdapter(this));
    jTextField9.setMaximumSize(new Dimension(100, 2147483647));
    jTextField9.setMinimumSize(new Dimension(100, 21));
    jTextField9.setPreferredSize(new Dimension(100, 21));
    jTextField9.setText("jTextField7");
    jTextField9.addActionListener(new DebugSettingsAntPane_jTextField9_actionAdapter(this));
    jTextField13.setMaximumSize(new Dimension(100, 2147483647));
    jTextField13.setMinimumSize(new Dimension(100, 21));
    jTextField13.setPreferredSize(new Dimension(100, 21));
    jTextField13.setText("jTextField7");
    jTextField13.addActionListener(new DebugSettingsAntPane_jTextField13_actionAdapter(this));
    jTextField14.setMaximumSize(new Dimension(100, 2147483647));
    jTextField14.setMinimumSize(new Dimension(100, 21));
    jTextField14.setPreferredSize(new Dimension(100, 21));
    jTextField14.setText("jTextField7");
    jTextField14.addActionListener(new DebugSettingsAntPane_jTextField14_actionAdapter(this));
    jTextField8.setMaximumSize(new Dimension(100, 2147483647));
    jTextField8.setMinimumSize(new Dimension(100, 21));
    jTextField8.setPreferredSize(new Dimension(100, 21));
    jTextField8.setText("jTextField7");
    jTextField8.addActionListener(new DebugSettingsAntPane_jTextField8_actionAdapter(this));
    jTextField12.setMaximumSize(new Dimension(100, 2147483647));
    jTextField12.setMinimumSize(new Dimension(100, 21));
    jTextField12.setPreferredSize(new Dimension(100, 21));
    jTextField12.setText("jTextField7");
    jTextField12.addActionListener(new DebugSettingsAntPane_jTextField12_actionAdapter(this));
    jTextField11.setMaximumSize(new Dimension(100, 2147483647));
    jTextField11.setMinimumSize(new Dimension(100, 21));
    jTextField11.setPreferredSize(new Dimension(100, 21));
    jTextField11.setText("jTextField7");
    jTextField11.addActionListener(new DebugSettingsAntPane_jTextField11_actionAdapter(this));
    jTextField1.setMaximumSize(new Dimension(100, 2147483647));
    jTextField1.setMinimumSize(new Dimension(100, 21));
    jTextField1.setPreferredSize(new Dimension(100, 21));
    jTextField1.setText("jTextField1");
    jTextField1.addActionListener(new DebugSettingsAntPane_jTextField1_actionAdapter(this));
    jTextField2.setMaximumSize(new Dimension(100, 2147483647));
    jTextField2.setMinimumSize(new Dimension(100, 21));
    jTextField2.setPreferredSize(new Dimension(100, 21));
    jTextField2.setText("jTextField2");
    jTextField2.addActionListener(new DebugSettingsAntPane_jTextField2_actionAdapter(this));
    jTextField3.setMaximumSize(new Dimension(100, 2147483647));
    jTextField3.setMinimumSize(new Dimension(100, 21));
    jTextField3.setPreferredSize(new Dimension(100, 21));
    jTextField3.setText("jTextField3");
    jTextField3.addActionListener(new DebugSettingsAntPane_jTextField3_actionAdapter(this));
    jTextField4.setMaximumSize(new Dimension(100, 2147483647));
    jTextField4.setMinimumSize(new Dimension(100, 21));
    jTextField4.setPreferredSize(new Dimension(100, 21));
    jTextField4.setText("jTextField4");
    jTextField4.addActionListener(new DebugSettingsAntPane_jTextField4_actionAdapter(this));
    jTextField5.setMaximumSize(new Dimension(100, 2147483647));
    jTextField5.setMinimumSize(new Dimension(100, 21));
    jTextField5.setPreferredSize(new Dimension(100, 21));
    jTextField5.setText("jTextField5");
    jTextField5.addActionListener(new DebugSettingsAntPane_jTextField5_actionAdapter(this));
    jTextField6.setMaximumSize(new Dimension(100, 2147483647));
    jTextField6.setMinimumSize(new Dimension(100, 21));
    jTextField6.setPreferredSize(new Dimension(100, 21));
    jTextField6.setText("jTextField6");
    jTextField6.addActionListener(new DebugSettingsAntPane_jTextField6_actionAdapter(this));
    jLabel2.setText("Delay (seconds)");
    jLabel1.setText("Delay (seconds)");
    jLabel3.setText("");
    jLabel2.setText("Message Time To Live (hops)");
    jLabel4.setText("");
    jLabel3.setText("Debug mode");
    jLabel5.setText("Parallel");
    jLabel4.setText("Parallel");
    jLabel6.setText("Efficiency limit");
    jLabel5.setText("Efficiency limit");
    jLabel7.setText("Efficiency Modifier");
    jLabel6.setText("Efficiency Modifier");
    jLabel8.setText("In transit queue");
    jLabel7.setText("In transit queue");
    jLabel8.setText("Own Delivered Message queue");
    jLabel14.setText("Max Pull Request To Serve");
    jLabel9.setText("Max Pull Request To Serve");
    jLabel12.setText("Max Secure Connections");
    jLabel12.setText("Max Secure Connections");
    jLabel10.setText("Blocks Per Source");
    jLabel14.setText("Max Sources");
    jLabel15.setText("Message Timeout (seconds)");
    jLabel15.setText("Message Timeout (milliseconds)");
    jLabel13.setText("Max Retransmissions");
    jLabel11.setText("Max Failed Message To Trace");
    jLabel16.setText("Max Neighbours");
    jTextField7.setMaximumSize(new Dimension(100, 2147483647));
    jTextField7.setMinimumSize(new Dimension(100, 21));
    jTextField7.setPreferredSize(new Dimension(100, 21));
    jTextField7.setText("jTextField7");
    jTextField7.addActionListener(new DebugSettingsAntPane_jTextField7_actionAdapter(this));
    jLabel17.setText("Block Size In Download");
    jTextField15.setMaximumSize(new Dimension(100, 2147483647));
    jTextField15.setMinimumSize(new Dimension(100, 21));
    jTextField15.setPreferredSize(new Dimension(100, 21));
    jTextField15.setText("jTextField15");
    jTextField15.addActionListener(new DebugSettingsAntPane_jTextField15_actionAdapter(this));
    jLabel18.setText("DoubleClick with the right mouse buttton on the tab to close this " +
    "panel.");
    jLabel19.setRequestFocusEnabled(true);
    jLabel19.setText("Max msg to Route Toghether");
    jTextField16.setMaximumSize(new Dimension(100, 2147483647));
    jTextField16.setMinimumSize(new Dimension(100, 21));
    jTextField16.setPreferredSize(new Dimension(100, 21));
    jTextField16.setText("jTextField16");
    jTextField16.addActionListener(new DebugSettingsAntPane_jTextField16_actionAdapter(this));
    jComboBox1.addItem("OFF");
    jComboBox1.addItem("DEBUG");
    jComboBox1.addItem("INFO");
    jComboBox1.addItem("WARN");
    jComboBox1.addItem("ERROR");
    jComboBox1.addItem("FATAL");
    jComboBox1.addItem("ALL");
    switch(_logger.getRootLogger().getLevel().toInt()){
      case Level.OFF_INT:
        jComboBox1.setSelectedItem("OFF");
        break;
      case Level.DEBUG_INT:
        jComboBox1.setSelectedItem("DEBUG");
        break;
      case Level.INFO_INT:
        jComboBox1.setSelectedItem("INFO");
        break;
      case Level.WARN_INT:
        jComboBox1.setSelectedItem("WARN");
        break;
      case Level.ERROR_INT:
        jComboBox1.setSelectedItem("ERROR");
        break;
      case Level.FATAL_INT:
        jComboBox1.setSelectedItem("FATAL");
        break;
      case Level.ALL_INT:
        jComboBox1.setSelectedItem("ALL");
        break;
    }
    jComboBox1.addActionListener(new DebugSettingsAntPane_jComboBox1_actionAdapter(this));
    jComboBox1.setMaximumSize(new Dimension(100, 32767));
    jComboBox1.setMinimumSize(new Dimension(100, 21));
    jComboBox1.setPreferredSize(new Dimension(100, 21));
    jPanel3.add(jLabel18, new XYConstraints(8, 1, -1, -1));
    jPanel1.setBackground(Color.lightGray);
    jPanel1.setLayout(xYLayout2);
    jCheckBox1.setBackground(Color.lightGray);
    jCheckBox1.setText("");
    jRadioButton1.setText("Routing Settings");
    jRadioButton2.setText("Ant Settings");
    buttonGroup1.add(jRadioButton1);
    buttonGroup1.add(jRadioButton2);
    jPanel2.add(jLabel9, new XYConstraints(5, 6, -1, -1));
    jPanel2.add(jTextField10, new XYConstraints(185, 3, -1, -1));
    jPanel2.add(jTextField9, new XYConstraints(185, 28, -1, -1));
    jPanel2.add(jTextField13, new XYConstraints(185, 52, -1, -1));
    jPanel2.add(jTextField14,  new XYConstraints(185, 76, -1, -1));
    jPanel2.add(jTextField8, new XYConstraints(185, 100, -1, -1));
    jPanel2.add(jTextField12, new XYConstraints(184, 125, -1, -1));
    jPanel2.add(jTextField11, new XYConstraints(184, 150, -1, -1));
    jPanel2.add(jLabel12, new XYConstraints(4, 30, -1, -1));
    jPanel2.add(jLabel10, new XYConstraints(3, 54, -1, -1));
    jPanel2.add(jLabel14, new XYConstraints(3, 80, -1, -1));
    jPanel2.add(jLabel15, new XYConstraints(3, 103, -1, -1));
    jPanel2.add(jLabel13, new XYConstraints(3, 128, -1, -1));
    jPanel2.add(jLabel11,   new XYConstraints(3, 152, -1, -1));
    jPanel2.add(jLabel16,  new XYConstraints(2, 181, -1, -1));
    jPanel2.add(jTextField7,  new XYConstraints(184, 175, -1, -1));
    jPanel2.add(jLabel17,  new XYConstraints(2, 204, -1, -1));
    jPanel2.add(jTextField15,   new XYConstraints(184, 198, -1, -1));
    jPanel3.add(jRadioButton1,  new XYConstraints(50, 26, -1, -1));
    jPanel3.add(jRadioButton2,  new XYConstraints(50, 48, -1, -1));
    jPanel3.add(jPanel1,                                     new XYConstraints(50, 78, 320, 257));
    jPanel1.add(jLabel1, new XYConstraints(4, 6, -1, -1));
    jPanel1.add(jTextField1, new XYConstraints(207, 5, -1, -1));
    jPanel1.add(jLabel2,  new XYConstraints(4, 36, -1, -1));
    jPanel1.add(jTextField2, new XYConstraints(206, 33, -1, -1));
    jPanel1.add(jLabel3, new XYConstraints(3, 67, -1, -1));
    jPanel1.add(jCheckBox1, new XYConstraints(205, 91, -1, -1));
    jPanel1.add(jLabel4, new XYConstraints(3, 96, -1, 12));
    jPanel1.add(jTextField3, new XYConstraints(207, 119, -1, -1));
    jPanel1.add(jLabel5, new XYConstraints(2, 126, -1, -1));
    jPanel1.add(jTextField4, new XYConstraints(206, 146, -1, -1));
    jPanel1.add(jTextField5, new XYConstraints(205, 172, -1, -1));
    jPanel1.add(jLabel7, new XYConstraints(3, 177, -1, -1));
    jPanel1.add(jLabel6,  new XYConstraints(2, 150, -1, -1));
    jPanel1.add(jTextField6, new XYConstraints(204, 197, -1, -1));
    jPanel1.add(jLabel8, new XYConstraints(1, 201, -1, -1));
    jPanel1.add(jLabel19,  new XYConstraints(2, 233, -1, -1));
    jPanel1.add(jTextField16,  new XYConstraints(204, 229, -1, -1));
    jPanel1.add(jComboBox1,    new XYConstraints(206, 64, -1, -1));
    jPanel3.add(jPanel2,  new XYConstraints(50, 78, 319, 225));
    this.add(jPanel3, null);
  }

  void jRadioButton1_actionPerformed(ActionEvent e) {
    if(jRadioButton1.isSelected()){
      this.jPanel1.setVisible(true);
      this.jPanel2.setVisible(false);
    }
    else{
      this.jPanel2.setVisible(true);
      this.jPanel1.setVisible(false);
    }
  }

  void jRadioButton2_actionPerformed(ActionEvent e) {
    if(jRadioButton2.isSelected()){
      this.jPanel2.setVisible(true);
      this.jPanel1.setVisible(false);
    }
    else{
      this.jPanel1.setVisible(true);
      this.jPanel2.setVisible(false);
    }
  }

  void jTextField9_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField9.getText());
      WarriorAnt.maxSecureConnections = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField13_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField13.getText());
      MultipleSourcesDownloadManager.blocksPerSource = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField14_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField4.getText());
      MultipleSourcesDownloadManager.MaxSources = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField8_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField8.getText());
      Ant.messageTimeout = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField12_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField12.getText());
      Ant.maxRetransmissions = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField11_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField11.getText());
      Ant.maxFailedMessageToTrace = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField10_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField10.getText());
      WarriorAnt.maxPullRequestsToServe = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField1_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField1.getText());
      Router.delay = num*1000;
    }
    catch (Exception ex) {
    }
  }

  void jTextField2_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField2.getText());
      Router.timeToLive = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField3_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField3.getText());
      Router.efficiencyLimit = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField4_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField4.getText());
      Router.efficiencyModifier = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField5_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField5.getText());
      Router.inTransitQueue = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField6_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField6.getText());
      Router.ownDeliveredMessagesQueue = num;
    }
    catch (Exception ex) {
    }
  }

  void jCheckBox1_actionPerformed(ActionEvent e) {
    if(jCheckBox1.isSelected())
      Router.PARALLEL=true;
    else
      Router.PARALLEL=false;
  }

  void jTextField7_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField7.getText());
      Ant.maxNeighbours = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField15_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField15.getText());
      WarriorAnt.blockSizeInDownload = num;
    }
    catch (Exception ex) {
    }
  }

  void jTextField16_actionPerformed(ActionEvent e) {
    try {
      int num = Integer.parseInt(jTextField16.getText());
      Ant.maxMessagesToRouteToghether = num;
    }
    catch (Exception ex) {
    }
  }

  void jComboBox1_actionPerformed(ActionEvent e) {
    if(jComboBox1.getSelectedItem().equals("OFF")){
      Logger.getRootLogger().setLevel(Level.OFF);
    }else if(jComboBox1.getSelectedItem().equals("INFO")){
      Logger.getRootLogger().setLevel(Level.INFO);
    }else if(jComboBox1.getSelectedItem().equals("DEBUG")){
      Logger.getRootLogger().setLevel(Level.DEBUG);
    }else if(jComboBox1.getSelectedItem().equals("WARN")){
      Logger.getRootLogger().setLevel(Level.WARN);
    }else if(jComboBox1.getSelectedItem().equals("ERROR")){
      Logger.getRootLogger().setLevel(Level.ERROR);
    }else if(jComboBox1.getSelectedItem().equals("FATAL")){
      Logger.getRootLogger().setLevel(Level.FATAL);
    }else if(jComboBox1.getSelectedItem().equals("ALL")){
      Logger.getRootLogger().setLevel(Level.ALL);
    }
  }
}

class SettingsAntPane_jRadioButton1_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  SettingsAntPane_jRadioButton1_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jRadioButton1_actionPerformed(e);
  }
}

class SettingsAntPane_jRadioButton2_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  SettingsAntPane_jRadioButton2_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jRadioButton2_actionPerformed(e);
  }
}

class SettingsAntPane_jCheckBox1_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  SettingsAntPane_jCheckBox1_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBox1_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField7_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField7_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField7_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField15_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField15_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField15_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField16_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField16_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField16_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField11_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField11_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField11_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField12_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField12_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField12_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField8_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField8_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField8_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField14_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField14_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField14_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField13_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField13_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField13_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField9_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField9_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField9_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField10_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField10_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField10_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField6_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField6_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField6_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField5_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField5_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField5_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField4_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField4_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField4_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField3_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField3_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField3_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField2_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField2_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField2_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jTextField1_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jTextField1_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jTextField1_actionPerformed(e);
  }
}

class DebugSettingsAntPane_jComboBox1_actionAdapter implements java.awt.event.ActionListener {
  DebugSettingsAntPane adaptee;

  DebugSettingsAntPane_jComboBox1_actionAdapter(DebugSettingsAntPane adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jComboBox1_actionPerformed(e);
  }
}