package ants.p2p.gui;

import org.jibble.pircbot.*;
import org.apache.log4j.*;

import ants.p2p.*;
import ants.p2p.irc.*;
import ants.p2p.query.*;
import ants.p2p.utils.*;


import java.beans.*;
import java.util.*;

public class ConnectionManager extends Thread implements PropertyChangeListener{
  ConnectionAntPanel cap;

  public static int timeout = 60000;

  static Logger _logger = Logger.getLogger(ConnectionManager.class.getName());

  public ConnectionManager(ConnectionAntPanel cap){
    super();
    this.cap = cap;
    this.setPriority(Thread.MIN_PRIORITY);
  }

  public void propertyChange(PropertyChangeEvent e){
    if(e.getPropertyName().equals("removedNeighbour")){
      resume();
    }
  }

  public void run(){
    while (true) {
      while (cap.warriorAnt.getNeighboursNumber() <
             cap.warriorAnt.getMaxNeighbours()) {
        ArrayList peers = InetAddressEngine.getInstance().getTrustedPeers();
        if(peers.size() > 0){
          /*
          for (int x = 0;
               x < peers.size() &&
               cap.warriorAnt.getNeighboursNumber() <
               cap.warriorAnt.getMaxNeighbours(); x++) {
            ServerInfo peer = (ServerInfo)peers.get(x);
            if(!(peer.getAddress().equals(this.cap.getLocalAddress()) &&
               peer.getPort().intValue()==this.cap.warriorAnt.getServerPort())){
              _logger.info("Trying direct connection to trusted peer: " +
                           ( (ServerInfo) peers.get(x)).
                           getAddress().
                           getHostAddress() + ":" +
                           ( (ServerInfo) peers.get(x)).getPort().
                           intValue());
              try {
                cap.warriorAnt.addNeighbour( ( (ServerInfo) peers.get(x)).
                                            getAddress().
                                            getHostAddress(),
                                            ( (ServerInfo) peers.get(x)).
                                            getPort().
                                            intValue(), true, FrameAnt.
                                            getInstance(null).getGuiAnt().
                                            getConnectionAntPanel().
                                            getLocalAddress());
                Thread.sleep(10000);
              }
              catch (Exception e) {
                _logger.error("Failed adding neighbour: " + e.getMessage());
              }
            }
          }
          */
          for (int x = 0;
               x < peers.size() &&
               cap.warriorAnt.getNeighboursNumber() <
               cap.warriorAnt.getMaxNeighbours(); x++) {
            ServerInfo peer = (ServerInfo)peers.get(x);
            if (! (peer.getAddress().equals(this.cap.
                getLocalAddress()) &&
                   peer.getPort().intValue() ==
                   this.cap.warriorAnt.getServerPort())) {
              _logger.info("Trying retrieving peers info from: " +
                           ( (ServerInfo) peers.get(x)).
                           getAddress().
                           getHostAddress() + ":" +
                           ( ( (ServerInfo) peers.get(x)).getPort().
                            intValue() + 1));

              ServerInfo sInfos = (ServerInfo) peers.get(x);
              cap.jTextField5.setText(sInfos.getAddress().getHostAddress());
              cap.jTextField6.setText( (sInfos.getPort().intValue() + 1) + "");

              RefreshAndConnectThread refreshAndConnectThread = new RefreshAndConnectThread(this.cap);
              refreshAndConnectThread.start();
            }
          }
        }
        peers = InetAddressEngine.getInstance().getPeersWithFreeSlots(InetAddressEngine.peersToMemorize);
        if(peers.size() > 0){
          /*
          for (int x = 0;
               x < peers.size() &&
               cap.warriorAnt.getNeighboursNumber() <
               cap.warriorAnt.getMaxNeighbours(); x++) {
            ServerInfo peer = (ServerInfo)peers.get(x);
            if (! (peer.getAddress().equals(this.cap.
                getLocalAddress()) &&
                   peer.getPort().intValue() ==
                   this.cap.warriorAnt.getServerPort())) {
              _logger.info("Trying direct connection to discovered peer: " +
                           ( (ServerInfo) peers.get(x)).
                           getAddress().
                           getHostAddress() + ":" +
                           ( (ServerInfo) peers.get(x)).getPort().
                           intValue());
              try {
                cap.warriorAnt.addNeighbour( ( (ServerInfo) peers.get(x)).
                                            getAddress().
                                            getHostAddress(),
                                            ( (ServerInfo) peers.get(x)).
                                            getPort().
                                            intValue(), true, FrameAnt.
                                            getInstance(null).getGuiAnt().
                                            getConnectionAntPanel().
                                            getLocalAddress());
                Thread.sleep(10000);
              }
              catch (Exception e) {
                _logger.error("Failed adding neighbour: " + e.getMessage());
              }
            }
          }
          */
          for (int x = 0;
               x < peers.size() &&
               cap.warriorAnt.getNeighboursNumber() <
               cap.warriorAnt.getMaxNeighbours(); x++) {
            ServerInfo peer = (ServerInfo)peers.get(x);
            if (! (peer.getAddress().equals(this.cap.
                getLocalAddress()) &&
                   peer.getPort().intValue() ==
                   this.cap.warriorAnt.getServerPort())) {
              _logger.info("Trying retrieving peers info from: " +
                           ( (ServerInfo) peers.get(x)).
                           getAddress().
                           getHostAddress() + ":" +
                           ( ( (ServerInfo) peers.get(x)).getPort().
                            intValue() + 1));

              ServerInfo sInfos = (ServerInfo) peers.get(x);
              cap.jTextField5.setText(sInfos.getAddress().getHostAddress());
              cap.jTextField6.setText( (sInfos.getPort().intValue() + 1) + "");
              RefreshAndConnectThread refreshAndConnectThread = new RefreshAndConnectThread(this.cap);
              refreshAndConnectThread.start();
            }
          }
        }
        if(this.cap.ircBot != null &&
           this.cap.ircBot.isConnected() &&
           this.cap.searchPeersOnIRC &&
           cap.warriorAnt.getNeighboursNumber() < cap.warriorAnt.getMaxNeighbours()){
          try {
            User[] users = cap.ircBot.getUsers(ConnectionAntPanel.ircChannel); //this.ircBot.getActiveChannel());
            if (users.length > 1) {
              int userIndex = (int) (Math.random() * users.length);
              while (users[userIndex].equals(ConnectionAntPanel.nick) &&
                     users.length > 1) {
                userIndex = (int) (Math.random() * users.length);
              }
              cap.ircBot.sendMessage(users[userIndex].getNick(),
                                     "CommandCode:0003");
              _logger.info("Sent request message to: " +
                           users[userIndex].getNick());
            }
          }
          catch (Exception ex) {
            _logger.error("IRC Client Error: " +ex.getMessage());
          }
        }
        try {
          if(cap.warriorAnt.getNeighboursNumber()>0)
            sleep(timeout*cap.warriorAnt.getNeighboursNumber());
          else
            sleep(timeout);
        }
        catch (Exception e) {
          _logger.error("Connection manager sleep Exception: "+e.getMessage());
        }
      }
      suspend();
    }
  }
}