//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import java.beans.*;
import java.net.*;
import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

import org.apache.log4j.*;
import org.jibble.pircbot.*;
import ants.p2p.*;
import ants.p2p.irc.*;
import ants.p2p.messages.*;
import ants.p2p.query.*;
import ants.p2p.query.security.*;
import ants.p2p.security.*;
import ants.p2p.utils.*;
import com.borland.jbcl.layout.*;

public class ConnectionAntPanel extends JPanel implements PropertyChangeListener{
  public static String lastRoutingPoint = "";
  public static int lastRoutingPointPort = 4568;

  public static String nick = "Default"+(int)(Math.random()*10000);
  public static String ircServer = "";
  public static String ircChannel = "#ants-peers-"+Ant.getVersion();
  public static int ircPort = 6666;
  public static boolean autoReconnectIRC = false;
  public static boolean searchPeersOnIRC = true;

  public static String pic = "./backgrounds/bg0.jpg";

  static Logger _logger = Logger.getLogger(ConnectionAntPanel.class.getName());

  public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

  InetAddress localAddress = null;

  ConnectionManager connectionManager = null;
  Image buffer;
  JLabel jLabel1 = new JLabel();
  JList jList1;
  JList jList2;
  XYLayout xYLayout1 = new XYLayout();
  JLabel jLabel2 = new JLabel();
  JTextField jTextField1 = new JTextField();
  JTextField jTextField2 = new JTextField();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JButton jButton3 = new JButton();
  JLabel jLabel5 = new JLabel();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel6 = new JLabel();
  JTextField jTextField4 = new JTextField();
  JLabel jLabel7 = new JLabel();
  GuiAnt container;

  public WarriorAnt warriorAnt;
  public IrcBot ircBot;
  JScrollPane jScrollPane1 = new JScrollPane();
  DefaultListModel neighbours = new DefaultListModel();
  DefaultListModel secureConnections = new DefaultListModel();
  JLabel jLabel9 = new JLabel();
  JLabel jLabel10 = new JLabel();
  JLabel jLabel11 = new JLabel();
  JScrollPane jScrollPane2 = new JScrollPane();
  JLabel jLabel13 = new JLabel();
  JButton jButton4 = new JButton();
  JButton jButton5 = new JButton();
  JButton jButton6 = new JButton();
  JButton jButton7 = new JButton();
  JScrollPane jScrollPane3 = new JScrollPane();
  JList jList3 = new JList();
  JLabel jLabel14 = new JLabel();
  JButton jButton8 = new JButton();
  JTextField jTextField5 = new JTextField();
  JTextField jTextField6 = new JTextField();
  JLabel jLabel15 = new JLabel();
  JLabel jLabel16 = new JLabel();
  JButton jButton9 = new JButton();
  JLabel jLabel8 = new JLabel();
  JCheckBox jCheckBox1 = new JCheckBox();
  JPanel jPanel1 = new JPanel();
  XYLayout xYLayout2 = new XYLayout();
  TitledBorder titledBorder1;
  TitledBorder titledBorder2;
  JPanel jPanel2 = new JPanel();
  XYLayout xYLayout3 = new XYLayout();
  Border border1;
  JPanel jPanel3 = new JPanel();
  XYLayout xYLayout4 = new XYLayout();
  JPanel jPanel4 = new JPanel();
  XYLayout xYLayout5 = new XYLayout();
  JLabel jLabel12 = new JLabel();
  JButton jButton10 = new JButton();
  JLabel jLabel17 = new JLabel();
  JScrollPane jScrollPane4 = new JScrollPane();
  JList jList4 = new JList();
  JTextField jTextField7 = new JTextField();
  JTextField jTextField8 = new JTextField();
  JButton jButton11 = new JButton();
  JButton jButton12 = new JButton();
  JLabel jLabel18 = new JLabel();
  JLabel jLabel19 = new JLabel();
  JLabel jLabel20 = new JLabel();

  public ConnectionAntPanel(GuiAnt container) {
    this.ircChannel = this.ircChannel.toLowerCase();
    this.container=container;
    try{
      Toolkit tk = Toolkit.getDefaultToolkit();
      MediaTracker mt = new MediaTracker(this);
      buffer = tk.getImage(pic);
      mt.waitForAll();
    }catch(Exception e){}
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
    this.jCheckBox1.setSelected(false);
    this.jList4.setListData(InetAddressEngine.getTrustedPeers().toArray());
  }
  void jbInit() throws Exception {
    jList1 = new JList(neighbours);
    jList2 = new JList(secureConnections);
    titledBorder1 = new TitledBorder("");
    titledBorder2 = new TitledBorder("");
    border1 = BorderFactory.createEmptyBorder(20,20,20,20);
    jLabel1.setForeground(Color.black);
    jLabel1.setText("Connected Ants");
    this.setLayout(xYLayout1);
    jLabel2.setForeground(Color.black);
    jLabel2.setText("Connect to:");
    jTextField2.setMaximumSize(new Dimension(60, 2147483647));
    jTextField2.setMinimumSize(new Dimension(60, 21));
    jTextField2.setPreferredSize(new Dimension(60, 21));
    jTextField2.setText("4567");
    jTextField2.addFocusListener(new ConnectionAntPanel_jTextField2_focusAdapter(this));
    jLabel3.setForeground(Color.black);
    jLabel3.setText("Neighbour Address");
    jLabel4.setForeground(Color.black);
    jLabel4.setText("Port");
    jButton1.setEnabled(false);
    jButton1.setVerifyInputWhenFocusTarget(true);
    jButton1.setText("Connect...");
    jButton1.addActionListener(new ConnectionAntPanel_jButton1_actionAdapter(this));
    xYLayout1.setWidth(930);
    xYLayout1.setHeight(580);
    jButton2.setEnabled(false);
    jButton2.setText("Disconnect");
    jButton2.addActionListener(new ConnectionAntPanel_jButton2_actionAdapter(this));
    jButton3.setText("Start ANts");
    jButton3.addActionListener(new ConnectionAntPanel_jButton3_actionAdapter(this));
    jLabel5.setForeground(Color.black);
    jLabel5.setText("Ant not running...");
    jTextField3.setMaximumSize(new Dimension(60, 2147483647));
    jTextField3.setMinimumSize(new Dimension(60, 21));
    jTextField3.setOpaque(true);
    jTextField3.setPreferredSize(new Dimension(60, 21));
    jTextField3.setToolTipText("");
    jTextField3.setText("4567");
    jTextField3.addFocusListener(new ConnectionAntPanel_jTextField3_focusAdapter(this));
    jLabel6.setForeground(Color.black);
    jLabel6.setText("Port");
    jTextField4.setMaximumSize(new Dimension(100, 2147483647));
    jTextField4.setMinimumSize(new Dimension(100, 21));
    jTextField4.setOpaque(true);
    jTextField4.setPreferredSize(new Dimension(100, 21));
    jTextField4.setSelectionStart(0);
    this.jTextField4.setText(ConnectionAntPanel.nick);
    jTextField4.addFocusListener(new ConnectionAntPanel_jTextField4_focusAdapter(this));
    jLabel7.setForeground(Color.black);
    jLabel7.setText("Nick");
    jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
    jLabel9.setForeground(Color.black);
    jLabel9.setVerifyInputWhenFocusTarget(true);
    jLabel9.setText("Status:");
    jLabel10.setText("Neighbours connection");
    jLabel11.setForeground(Color.black);
    jLabel11.setText("Neighbours connections");
    jLabel13.setForeground(Color.black);
    jLabel13.setVerifyInputWhenFocusTarget(true);
    jLabel13.setText("Avaiable secure output connections");
    jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
    jButton4.setEnabled(false);
    jButton4.setText("Remove Secure");
    jButton4.addActionListener(new ConnectionAntPanel_jButton4_actionAdapter(this));
    jButton5.setEnabled(false);
    jButton5.setMaximumSize(new Dimension(100, 25));
    jButton5.setMinimumSize(new Dimension(100, 25));
    jButton5.setPreferredSize(new Dimension(100, 25));
    jButton5.setText("New Query");
    jButton5.addActionListener(new ConnectionAntPanel_jButton5_actionAdapter(this));
    jButton6.setMaximumSize(new Dimension(100, 25));
    jButton6.setMinimumSize(new Dimension(100, 25));
    jButton6.setPreferredSize(new Dimension(100, 25));
    jButton6.setText("Settings");
    jButton6.addActionListener(new ConnectionAntPanel_jButton6_actionAdapter(this));
    jButton7.setMaximumSize(new Dimension(100, 25));
    jButton7.setMinimumSize(new Dimension(100, 25));
    jButton7.setPreferredSize(new Dimension(100, 25));
    jButton7.setText("Advanced");
    jButton7.addActionListener(new ConnectionAntPanel_jButton7_actionAdapter(this));
    jLabel14.setForeground(Color.black);
    jLabel14.setText("Peers with free slots");
    jButton8.setEnabled(false);
    jButton8.setText("Refresh");
    jButton8.addActionListener(new ConnectionAntPanel_jButton8_actionAdapter(this));
    jTextField5.setMaximumSize(new Dimension(200, 2147483647));
    jTextField5.setMinimumSize(new Dimension(200, 21));
    jTextField5.setOpaque(true);
    jTextField5.setPreferredSize(new Dimension(200, 21));
    jTextField5.setText(ConnectionAntPanel.lastRoutingPoint);
    jTextField6.setOpaque(true);
    jTextField6.setText("4568");
    jTextField6.addFocusListener(new ConnectionAntPanel_jTextField6_focusAdapter(this));
    jLabel15.setForeground(Color.black);
    jLabel15.setText("Routing Point Addr...");
    jLabel16.setForeground(Color.black);
    jLabel16.setText("Port");
    jList3.addMouseListener(new ConnectionAntPanel_jList3_mouseAdapter(this));
    jList3.setOpaque(true);
    jList3.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jScrollPane3.setBorder(BorderFactory.createEtchedBorder());
    jScrollPane3.setDebugGraphicsOptions(0);
    jButton9.setEnabled(false);
    jButton9.setText("Find Routing Point");
    jButton9.addActionListener(new ConnectionAntPanel_jButton9_actionAdapter(this));
    jLabel8.setForeground(Color.black);
    jLabel8.setText("Users in the chatroom: ");
    jCheckBox1.setForeground(Color.black);
    jCheckBox1.setOpaque(false);
    jCheckBox1.setText("Advanced Mode");
    jCheckBox1.addChangeListener(new ConnectionAntPanel_jCheckBox1_changeAdapter(this));
    jCheckBox1.setSelected(true);
    jList1.setOpaque(true);
    jList2.setOpaque(true);
    jTextField1.setOpaque(true);
    jPanel1.setBorder(BorderFactory.createEtchedBorder());
    jPanel1.setDebugGraphicsOptions(0);
    jPanel1.setDoubleBuffered(true);
    jPanel1.setMaximumSize(new Dimension(256, 386));
    jPanel1.setMinimumSize(new Dimension(256, 386));
    jPanel1.setPreferredSize(new Dimension(256, 386));
    jPanel1.setLayout(xYLayout2);
    jPanel2.setLayout(xYLayout3);
    jPanel2.setBorder(BorderFactory.createEtchedBorder());
    jPanel2.setMaximumSize(new Dimension(2147483647, 115));
    jPanel2.setMinimumSize(new Dimension(342, 115));
    jPanel2.setPreferredSize(new Dimension(342, 115));
    this.setBorder(border1);
    this.addComponentListener(new ConnectionAntPanel_this_componentAdapter(this));
    jPanel3.setBorder(BorderFactory.createEtchedBorder());
    jPanel3.setDebugGraphicsOptions(0);
    jPanel3.setMaximumSize(new Dimension(2147483647, 111));
    jPanel3.setMinimumSize(new Dimension(443, 111));
    jPanel3.setPreferredSize(new Dimension(443, 111));
    jPanel3.setLayout(xYLayout4);
    jPanel4.setLayout(xYLayout5);
    jPanel4.setBorder(BorderFactory.createEtchedBorder());
    jPanel4.setMaximumSize(new Dimension(365, 365));
    jPanel4.setMinimumSize(new Dimension(365, 365));
    jPanel4.setPreferredSize(new Dimension(600, 365));
    jLabel12.setText("ID: ");
    jButton10.setMaximumSize(new Dimension(120, 25));
    jButton10.setMinimumSize(new Dimension(120, 25));
    jButton10.setPreferredSize(new Dimension(120, 25));
    jButton10.setText("Shared Files");
    jButton10.addActionListener(new ConnectionAntPanel_jButton10_actionAdapter(this));
    jLabel17.setText("Trusted Peers");
    jTextField7.setText("");
    jTextField8.setText("");
    jTextField8.addFocusListener(new ConnectionAntPanel_jTextField8_focusAdapter(this));
    jButton11.setText("Add Trusted Peer");
    jButton11.addActionListener(new ConnectionAntPanel_jButton11_actionAdapter(this));
    jButton12.setText("Remove Trusted Peer");
    jButton12.addActionListener(new ConnectionAntPanel_jButton12_actionAdapter(this));
    jLabel18.setText("Trusted Peer Address");
    jLabel19.setText("Port");
    jLabel20.setText("Total compression gain:");
    jPanel1.add(jLabel1, new XYConstraints(10, 10, 155, -1));
    jPanel1.add(jScrollPane1,      new XYConstraints(10, 30, 230, 120));
    jPanel1.add(jScrollPane2, new XYConstraints(10, 220, 230, 120));
    jPanel1.add(jLabel13, new XYConstraints(10, 200, -1, -1));
    jPanel1.add(jButton2, new XYConstraints(10, 155, -1, -1));
    jPanel1.add(jButton4, new XYConstraints(10, 346, -1, -1));
    this.add(jPanel4,  new XYConstraints(258, 16, -1, -1));
    jScrollPane2.getViewport().add(jList2, null);
    jScrollPane1.getViewport().add(jList1, null);
    jPanel4.add(jLabel14,  new XYConstraints(10, 10, -1, -1));
    jPanel4.add(jScrollPane3,     new XYConstraints(10, 30, 170, 174));
    jPanel4.add(jTextField5, new XYConstraints(10, 280, 116, -1));
    jPanel4.add(jTextField6, new XYConstraints(140, 280, 49, -1));
    jPanel4.add(jLabel11, new XYConstraints(210, 10, -1, -1));
    jPanel4.add(jButton9, new XYConstraints(10, 310, 150, -1));
    jPanel4.add(jLabel2, new XYConstraints(210, 40, -1, -1));
    jPanel4.add(jLabel3, new XYConstraints(210, 60, -1, -1));
    jPanel4.add(jTextField1, new XYConstraints(210, 80, 125, -1));
    jPanel4.add(jLabel4, new XYConstraints(210, 110, -1, -1));
    jPanel4.add(jTextField2, new XYConstraints(210, 130, -1, -1));
    jPanel4.add(jButton1, new XYConstraints(210, 180, 105, -1));
    jPanel4.add(jLabel15, new XYConstraints(10, 260, -1, -1));
    jPanel4.add(jLabel16, new XYConstraints(140, 260, -1, -1));
    jPanel4.add(jButton8, new XYConstraints(10, 210, -1, -1));
    jPanel4.add(jLabel17,    new XYConstraints(400, 10, -1, -1));
    jPanel4.add(jScrollPane4,        new XYConstraints(400, 30, 170, 174));
    jPanel4.add(jTextField7,    new XYConstraints(400, 280, 116, -1));
    jPanel4.add(jTextField8,         new XYConstraints(530, 280, 49, -1));
    jPanel4.add(jButton11,     new XYConstraints(400, 310, 150, -1));
    jPanel4.add(jButton12,   new XYConstraints(400, 210, 150, -1));
    jPanel4.add(jLabel18,   new XYConstraints(400, 260, -1, -1));
    jPanel4.add(jLabel19,    new XYConstraints(530, 260, -1, -1));
    jScrollPane4.getViewport().add(jList4, null);
    jScrollPane3.getViewport().add(jList3, null);
    this.add(jPanel1, new XYConstraints(-2, 15, -1, -1));
    this.add(jPanel2,  new XYConstraints(466, 401, -1, -1));
    jPanel2.add(jLabel8,          new XYConstraints(100, 70, -1, -1));
    jPanel2.add(jLabel5,       new XYConstraints(100, 30, -1, -1));
    jPanel2.add(jLabel9,    new XYConstraints(100, 10, -1, -1));
    jPanel2.add(jLabel12,    new XYConstraints(100, 50, -1, -1));
    jPanel2.add(jLabel20,   new XYConstraints(100, 90, -1, -1));
    if(this.container.animationPanel != null){
      jPanel2.add(this.container.animationPanel,
                  new XYConstraints(5, 5, 80, 100));
    }
    this.add(jPanel3, new XYConstraints(-2, 405, -1, -1));
    jPanel3.add(jTextField3,   new XYConstraints(120, 30, -1, -1));
    jPanel3.add(jLabel6,    new XYConstraints(120, 10, -1, -1));
    jPanel3.add(jLabel7,   new XYConstraints(200, 10, -1, -1));
    jPanel3.add(jTextField4,  new XYConstraints(200, 30, -1, -1));
    jPanel3.add(jButton5,   new XYConstraints(320, 10, -1, -1));
    jPanel3.add(jButton3,  new XYConstraints(10, 10, -1, -1));
    jPanel3.add(jCheckBox1,    new XYConstraints(10, 60, -1, -1));
    jPanel3.add(jButton7,    new XYConstraints(320, 70, -1, -1));
    jPanel3.add(jButton6,      new XYConstraints(320, 40, -1, -1));
    jPanel3.add(jButton10,         new XYConstraints(180, 70, -1, -1));
    this.setIrcUsersNumberInChannel(-1, "");
  }

  public void setIrcUsersNumberInChannel(int number, String channel){
    if(number > 0){
      this.jLabel8.setText("Users in the chatroom "+channel+": " + number);
    }else if(number == 0){
      this.jLabel8.setText("No users in the chatroom");
    }else{
      this.jLabel8.setText("IRC client not connected");
    }
  }

  public void setRoutingPoint(InetAddress address, int port){
    _logger.info("Setting routing point: "+address.getHostAddress()+":"+port);
    this.jTextField5.setText(address.getHostAddress());
    this.jTextField6.setText(port+"");
  }

  public GuiAnt getContainer(){
    return this.container;
  }

  public JButton getJButton9(){
    return this.jButton9;
  }

  public void propertyChange(PropertyChangeEvent e){
    if(e.getPropertyName().equals("removedNeighbour")){
      NeighbourAnt na = (NeighbourAnt)e.getNewValue();
      this.neighbours.removeElement(na);
      if(this.neighbours.size()==0){
        this.jButton5.setEnabled(false);
        for(int x = this.container.queryPanels.size()-1; x >= 0; x--){
          QueryAntPanel qap = (QueryAntPanel)this.container.queryPanels.remove(x);
          this.container.jTabbedPane1.remove(qap);
        }
        if(this.container.dap != null){
          this.container.dap.interruptAllDownloads();
          this.container.jTabbedPane1.remove(this.container.dap);
          this.container.dap = null;
        }
        if(this.container.uap != null){
          this.container.uap.interruptAllUploads();
          this.container.jTabbedPane1.remove(this.container.uap);
          this.container.uap = null;
        }
      }
    }
    if(e.getPropertyName().equals("newNeighbour")){
      this.neighbours.addElement(e.getNewValue());
      this.jButton5.setEnabled(true);
      if(this.container.queryPanels.size()==0){
        QueryAntPanel qap = new QueryAntPanel(this.container);
        this.container.queryPanels.add(qap);
        this.container.jTabbedPane1.add("Query",qap);
        this.warriorAnt.getPropertyChangeSupport().addPropertyChangeListener(qap);
      }
      if(this.container.dap == null){
        DownloadAntPanel dap = new DownloadAntPanel(this.container);
        this.container.dap = dap;
        this.container.jTabbedPane1.add("Download",dap);
        this.warriorAnt.getPropertyChangeSupport().
            addPropertyChangeListener(dap);
      }
      if(this.container.uap == null){
        UploadAntPanel uap = new UploadAntPanel(this.container);
        this.container.uap = uap;
        this.container.jTabbedPane1.add("Upload",uap);
        this.warriorAnt.getPropertyChangeSupport().
            addPropertyChangeListener(uap);
      }
    }
    if(e.getPropertyName().equals("secureConnectionCreated")){
      this.secureConnections.removeElement(((SecurityResponseMessage)e.getNewValue()).getSource());
      this.secureConnections.addElement(((SecurityResponseMessage)e.getNewValue()).getSource());
    }
    if(e.getPropertyName().equals("updatePacketCompressionStats")){
      this.jLabel20.setText("Total compression gain:  "+NeighbourAnt.getTotalCompressionGainIn()+"%(in)   "+NeighbourAnt.getTotalCompressionGainOut()+"%(out)");
    }
  }

  void jButton3_actionPerformed(ActionEvent e) {
    try{
      this.jLabel5.setText("Connecting...");
      if (this.jButton3.getLabel().equals("Start ANts")) {
        this.jButton3.setEnabled(false);
        if (this.warriorAnt != null) {
          this.jLabel5.setText("Shutting down ANts...");
          this.warriorAnt.disconnectWarrior();
        }
        if (this.ircBot != null) {
          this.jLabel5.setText("Shutting down IRC Bot...");
          this.ircBot.shutdown();
        }

        this.jLabel5.setText("Generating ID...");
        AsymmetricProvider ap = new AsymmetricProvider(true);
        DigestManager dm = new DigestManager();
        String antID = dm.getDigest(this.jTextField4.getText() + "@" +
                                    System.currentTimeMillis());

        this.jLabel5.setText("Initializing ANts...");
        this.warriorAnt = new WarriorAnt(antID, Ant.maxNeighbours,
                                         Integer.
                                         parseInt(this.jTextField3.getText()));

        Thread.sleep(1000);
        if(!warriorAnt.isAlive()){
          this.jLabel5.setText("ANts is not running...");
          this.jLabel12.setText("ID:");
          throw new Exception("WarriorAnt not Started");
        }

        /* IrcBot Setup*/
        if(!ConnectionAntPanel.ircServer.equals("")){
          try{
            this.jLabel5.setText("Initializing IRC Bot...");
            this.ircBot = new IrcBot(ConnectionAntPanel.nick, this);
            this.ircBot.connect(ConnectionAntPanel.ircServer);
            Thread.sleep(2000);
            this.ircBot.joinChannel(ConnectionAntPanel.ircChannel);
            Thread.sleep(2000);
            this.ircBot.refreshUsers(ConnectionAntPanel.ircChannel);
            //this.jButton9.setEnabled(true);
          }catch(Exception ex){
            this.container.sap.setIrcConnected(false);
            this.container.sap.setIrcEnabled(false);
            _logger.error("IRC not started: "+ex.getMessage());
            final SwingWorker worker = new SwingWorker() {
              public Object construct() {
                ircBot.autoReconnect();
                return null;
              }
            };
            worker.start();
          }
        }else{
          this.jLabel5.setText("No IRC Bot selected...");
          this.container.sap.setIrcConnected(false);
          this.container.sap.setIrcEnabled(false);
        }
        /*Fine IrcBot setup*/

        this.jLabel5.setText("Initializing Address Server...");
        this.warriorAnt.startAddressServer();
        jLabel5.setText("ANts is listening on port: " + warriorAnt.getServerPort());
        jLabel12.setText("ID: " + warriorAnt.getId());
        this.warriorAnt.getPropertyChangeSupport().addPropertyChangeListener(this);
        if(container.animationPanel!=null){
          this.container.animationPanel.init();
        }
        this.connectionManager = new ConnectionManager(this);
        if(this.connectionManager != null){
          this.warriorAnt.getPropertyChangeSupport().addPropertyChangeListener(this.connectionManager);
          this.connectionManager.start();
        }
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(true);
        this.jButton3.setEnabled(true);
        this.jButton3.setLabel("Stop ANts");
        this.jButton4.setEnabled(true);
        this.jButton8.setEnabled(true);
        this.jTextField3.setEnabled(false);
        this.jTextField4.setEnabled(false);
        this.propertyChangeSupport.firePropertyChange("antStarted",null,this);
      }else{
        this.jButton3.setEnabled(false);
        if (this.warriorAnt != null) {
          this.warriorAnt.disconnectWarrior();
        }
        if (this.ircBot != null) {
          this.ircBot.shutdown();
          //this.jButton9.setEnabled(false);
          this.container.sap.setIrcConnected(false);
          this.container.sap.setIrcEnabled(false);
        }
        if(this.connectionManager != null){
          this.connectionManager.stop();
          this.connectionManager = null;
        }
        this.neighbours.removeAllElements();
        for(int x = this.container.queryPanels.size()-1; x >= 0; x--){
          QueryAntPanel qap = (QueryAntPanel)this.container.queryPanels.remove(x);
          this.container.jTabbedPane1.remove(qap);
        }
        if(this.container.dap != null){
          this.container.jTabbedPane1.remove(this.container.dap);
          this.container.dap = null;
        }
        if(this.container.uap != null){
          this.container.jTabbedPane1.remove(this.container.uap);
          this.container.uap = null;
        }
        jLabel5.setText("Ant is not running...");
        this.jLabel12.setText("ID:");
        if(container.animationPanel!=null){
          this.container.animationPanel.stop();
        }
        this.secureConnections.removeAllElements();
        Enumeration neighs = this.neighbours.elements();
        for(int x = this.neighbours.size() - 1; x >= 0; x++){
          Object neigh = this.neighbours.get(x);
          this.warriorAnt.removeNeighbour((NeighbourAnt)neigh);
          this.neighbours.remove(x);
        }
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jButton3.setLabel("Start ANts");
        this.jButton3.setEnabled(true);
        this.jButton4.setEnabled(false);
        this.jButton8.setEnabled(false);
        this.jTextField3.setEnabled(true);
        this.jTextField4.setEnabled(true);
        this.propertyChangeSupport.firePropertyChange("antStopped",null,this);
      }
    }
    catch (Exception ex) {
      if (this.warriorAnt != null) {
        this.warriorAnt.disconnect();
      }
      if (this.ircBot != null) {
        this.ircBot.shutdown();
      }
      jLabel5.setText("Ant is not running...");
      this.jLabel12.setText("ID:");
      this.jButton3.setEnabled(true);
      this.jButton3.setLabel("Start ANts");

      this.jButton1.setEnabled(false);
      this.jButton2.setEnabled(false);
      this.jButton4.setEnabled(false);
      this.jButton8.setEnabled(false);
      this.jTextField3.setEnabled(true);
      this.jTextField4.setEnabled(true);
      this.jButton9.setEnabled(false);
      this.container.sap.setIrcConnected(false);
      this.container.sap.setIrcEnabled(false);
      this.propertyChangeSupport.firePropertyChange("antStopped",null,this);
      _logger.info("Ant is not running! "+ex.getMessage());
      _logger.debug("Ant is not running! ",ex);
    }
  }

  void jButton1_actionPerformed(ActionEvent e) {
    try{
      this.warriorAnt.addNeighbour(this.jTextField1.getText(),
                                   Integer.parseInt(this.jTextField2.getText()),true,FrameAnt.
                getInstance(null).getGuiAnt().getConnectionAntPanel().
                getLocalAddress());
    }catch(Exception ex){
      _logger.error("",ex);
    }
  }

  void jButton2_actionPerformed(ActionEvent e) {
    Object[] objects = this.jList1.getSelectedValues();
    for(int y=0; y<objects.length; y++){
      this.warriorAnt.removeNeighbour((NeighbourAnt)objects[y]);
      if(this.neighbours.size()==0){
        for(int x = this.container.queryPanels.size()-1; x >= 0; x--){
          QueryAntPanel qap = (QueryAntPanel)this.container.queryPanels.remove(x);
          this.container.jTabbedPane1.remove(qap);
        }
        if(this.container.dap != null){
          this.container.dap.interruptAllDownloads();
          this.container.jTabbedPane1.remove(this.container.dap);
          this.container.dap = null;
        }
        if(this.container.uap != null){
          this.container.uap.interruptAllUploads();
          this.container.jTabbedPane1.remove(this.container.uap);
          this.container.uap = null;
        }
      }
    }
  }

  void jButton4_actionPerformed(ActionEvent e) {
    Object[] objects = this.jList2.getSelectedValues();
    java.util.List outputSecure = this.container.cap.warriorAnt.outputSecureConnections;
    for(int y = 0; y < objects.length; y++){
      for (int x = outputSecure.size()-1; x >= 0; x--) {
        if ( ( (EndpointSecurityManager) outputSecure.get(x)).getPeerId().
            equals((String)objects[y])){
         outputSecure.remove(x);
       }
      }
      this.secureConnections.removeElement(objects[y]);
    }
  }

  void jButton5_actionPerformed(ActionEvent e) {
    QueryAntPanel qap = new QueryAntPanel(this.container);
    this.container.queryPanels.add(qap);
    this.container.jTabbedPane1.add("Query", qap);
    this.container.cap.warriorAnt.getPropertyChangeSupport().
        addPropertyChangeListener(qap);
  }

  void jButton6_actionPerformed(ActionEvent e) {
    if(this.container.sap != null){
      this.container.jTabbedPane1.add("Settings",this.container.sap);
    }
  }

  void jButton7_actionPerformed(ActionEvent e) {
    if(this.container.dsap != null){
      this.container.jTabbedPane1.add("Server & Router Settings", this.container.dsap);
    }
  }

  public synchronized void refreshAndConnect(){
    try {
      ArrayList peers = this.warriorAnt.getServersWithFreeSlots(InetAddress.
          getByName(this.jTextField5.getText()),
          Integer.parseInt(this.jTextField6.getText()),
          FrameAnt.
                getInstance(null).getGuiAnt().getConnectionAntPanel().
                getLocalAddress());
      jList3.setListData(peers.toArray());
      ConnectionAntPanel.lastRoutingPoint = this.jTextField5.getText();
      ConnectionAntPanel.lastRoutingPointPort = Integer.parseInt(this.
          jTextField6.getText());
      this.container.sap.storeSettings();
      for(int x = 0; x < peers.size() && this.warriorAnt.getNeighboursNumber() < this.warriorAnt.getMaxNeighbours();x++){
        try {
          this.warriorAnt.addNeighbour( ( (ServerInfo) peers.get(x)).getAddress().
                                       getHostAddress(),
                                       ( (ServerInfo) peers.get(x)).getPort().
                                       intValue(), true, FrameAnt.
                                       getInstance(null).getGuiAnt().
                                       getConnectionAntPanel().
                                       getLocalAddress());
          Thread.sleep(10000);
        }
        catch (Exception e) {
          _logger.error("Failed adding neighbour: "+e.getMessage());
        }
      }
    }
    catch (Exception ex) {
      _logger.error("Failed in retrieving peers infos from server: "+ex.getMessage());
    }
  }

  private static InetAddress searchForInternetPublicAddress(InetAddress[]
      addresses) {
    try {
      InetAddress publicAddress = null;
      for (int x = 0; x < addresses.length; x++) {
        byte head = addresses[x].getAddress()[0];
        byte body = addresses[x].getAddress()[1];
        byte tail = addresses[x].getAddress()[2];
        if (head >= 89 && head <= 127)
          continue;
        if (head >= 173 && head <= 187)
          continue;
        if (head >= 224 && head <= 239)
          continue;
        if (head >= 240 && head <= 255)
          continue;
        switch (head) {
          case (byte) 0:
            break;
          case (byte) 1:
            break;
          case (byte) 2:
            break;
          case (byte) 5:
            break;
          case (byte) 10:
            break;
          case (byte) 23:
            break;
          case (byte) 27:
            break;
          case (byte) 31:
            break;
          case (byte) 36:
            break;
          case (byte) 37:
            break;
          case (byte) 39:
            break;
          case (byte) 41:
            break;
          case (byte) 42:
            break;
          case (byte) 46:
            break;
          case (byte) 49:
            break;
          case (byte) 50:
            break;
          case (byte) 58:
            break;
          case (byte) 59:
            break;
          case (byte) 60:
            break;
          case (byte) 71:
            break;
          case (byte) 72:
            break;
          case (byte) 73:
            break;
          case (byte) 74:
            break;
          case (byte) 75:
            break;
          case (byte) 76:
            break;
          case (byte) 77:
            break;
          case (byte) 78:
            break;
          case (byte) 79:
            break;
          case (byte) 128:
            if (body == (byte) 0)
              break;
          case (byte) 169:
            if (body == (byte) 254)
              break;
          case (byte) 172:
            if (body >= (byte) 16 && body <= (byte) 31)
              break;
          case (byte) 189:
            break;
          case (byte) 190:
            break;
          case (byte) 191:
            if (body == (byte) 255)
              break;
          case (byte) 192:
            if (body == (byte) 0 ||
                (body == (byte) 68 && tail == (byte) 185) ||
                body == (byte) 168)
              break;
          case (byte) 197:
            break;
          case (byte) 198:
            if (body >= (byte) 18 && body <= (byte) 19)
              break;
          case (byte) 223:
            break;
          default:
            publicAddress = addresses[x];
            break;
        }
      }
      return publicAddress;
    }
    catch (Exception e) {
      return null;
    }
  }

  public InetAddress getLocalAddress() {
    try {
      if (this.localAddress == null) {
        InetAddress[] addresses = InetAddress.getAllByName(InetAddress.
            getLocalHost().getHostName());
        InetAddress publicAddress = ConnectionAntPanel.
            searchForInternetPublicAddress(addresses);
        if (publicAddress != null)
          return publicAddress;
        else
          return this.localAddress = InetAddress.getLocalHost();
      }
      else {
        return this.localAddress;
      }
    }
    catch (Exception e) {
      _logger.error("", e);
      return null;
    }
  }

  public void startANts(){
    this.jButton3_actionPerformed(new ActionEvent(this, 0, "Start Ant"));
  }

  /*
  public static boolean isLocalAddress(String address) {
    if (!address.startsWith("1.") &&
        !address.startsWith("2.") &&
        !address.startsWith("3.") &&
        !address.startsWith("4.") &&
        !address.startsWith("5.") &&
        !address.startsWith("6.") &&
        !address.startsWith("7.") &&
        !address.startsWith("8.") &&
        !address.startsWith("9.") &&
        !address.startsWith("10.") &&
        !address.startsWith("127.") &&
        !address.startsWith("172.16.") &&
        !address.startsWith("172.17.") &&
        !address.startsWith("172.18.") &&
        !address.startsWith("172.19.") &&
        !address.startsWith("172.20.") &&
        !address.startsWith("172.21.") &&
        !address.startsWith("172.22.") &&
        !address.startsWith("172.23.") &&
        !address.startsWith("172.24.") &&
        !address.startsWith("172.25.") &&
        !address.startsWith("172.26.") &&
        !address.startsWith("172.27.") &&
        !address.startsWith("172.28.") &&
        !address.startsWith("172.29.") &&
        !address.startsWith("172.30.") &&
        !address.startsWith("172.31.") &&
        !address.startsWith("169.254.") &&
        !address.startsWith("192.168.")) {
      return true;
    }
    return false;
  }
  */

  void jButton8_actionPerformed(ActionEvent e) {
    try {
      ArrayList peers = this.warriorAnt.getServersWithFreeSlots(InetAddress.getByName(this.jTextField5.getText()),
                                   Integer.parseInt(this.jTextField6.getText()),
                                   FrameAnt.
                                   getInstance(null).getGuiAnt().getConnectionAntPanel().
                                   getLocalAddress());
      jList3.setListData(peers.toArray());
      ConnectionAntPanel.lastRoutingPoint = this.jTextField5.getText();
      ConnectionAntPanel.lastRoutingPointPort = Integer.parseInt(this.jTextField6.getText());
      this.container.sap.storeSettings();
    }
    catch (Exception ex) {
      _logger.error("",ex);
    }
  }

  void jList3_mousePressed(MouseEvent e) {
    ServerInfo peer = (ServerInfo) this.jList3.getSelectedValue();
    this.jTextField1.setText(peer.getAddress().getHostAddress());
    this.jTextField2.setText(peer.getPort()+"");
  }

  void jButton9_actionPerformed(ActionEvent e) {
    try{
      User[] users = this.ircBot.getUsers(ConnectionAntPanel.ircChannel);//this.ircBot.getActiveChannel());
      if(users.length > 1){
        int userIndex = (int) (Math.random() * users.length);
        while (users[userIndex].equals(ConnectionAntPanel.nick) && users.length > 1) {
          userIndex = (int) (Math.random() * users.length);
        }
        this.ircBot.sendMessage(users[userIndex].getNick(),
                                "CommandCode:0000");
        _logger.info("Sent request message to: " +
                           users[userIndex].getNick());
      }
    }catch(Exception ex){_logger.error("IRC Client not connected.",ex);}
  }

  void jTextField4_focusLost(FocusEvent e) {
    if(this.jTextField4.getText().equals(""))
      this.jTextField4.setText("Default"+(int)(Math.random()*10000));
    ConnectionAntPanel.nick = this.jTextField4.getText();
    this.container.sap.storeSettings();
  }

  public void setNick(String newNick){
    if(newNick != null && ! newNick.equals("")){
      ConnectionAntPanel.nick = newNick;
      this.jTextField4.setText(newNick);
      this.container.sap.storeSettings();
    }
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (buffer != null){
      int posX = (int)(this.getSize().getWidth() - 650) / 2;
      int posY = (int)(this.getSize().getHeight() - 550) / 2;
      if(posX < 0) posX = 0;
      if(posY < 0) posY = 0;
      g.drawImage(buffer, posX, posY, this);
    }
  }


  void jCheckBox1_stateChanged(ChangeEvent e) {
    if (this.jCheckBox1.isSelected() == true) {
      this.jPanel4.setVisible(true);
      this.jButton7.setVisible(true);
    }
    else {
      this.jPanel4.setVisible(false);
      this.jButton7.setVisible(false);
    }
  }

  void jTextField3_focusLost(FocusEvent e) {
    try {
      int port = Integer.parseInt(this.jTextField3.getText());
      if (port <= 0 || port > 65536)
        throw new Exception("Invalid port number");
    }
    catch (Exception ex) {
      this.jTextField3.setText("");
    }
  }

  void jTextField2_focusLost(FocusEvent e) {
    try {
      int port = Integer.parseInt(this.jTextField2.getText());
      if (port <= 0 || port > 65536)
        throw new Exception("Invalid port number");
    }
    catch (Exception ex) {
      this.jTextField2.setText("");
    }
  }

  void jTextField6_focusLost(FocusEvent e) {
    try {
      int port = Integer.parseInt(this.jTextField6.getText());
      if (port <= 0 || port > 65536)
        throw new Exception("Invalid port number");
    }
    catch (Exception ex) {
      this.jTextField6.setText("");
    }
  }

  void this_componentResized(ComponentEvent e) {
    int limit;
    if(this.jCheckBox1.isSelected())
      limit = 600;
    else
      limit = 450;
    this.remove(this.jPanel2);
    this.remove(this.jPanel3);
    this.remove(this.jPanel1);
    this.remove(this.jPanel4);
    int jPanel1PositionX = this.getWidth()-this.jPanel1.getWidth() - 40;
    if(jPanel1PositionX < limit)
      jPanel1PositionX = limit;
    this.jPanel2.setPreferredSize(new Dimension(jPanel1PositionX,this.jPanel2.getHeight()));
    this.jPanel3.setPreferredSize(new Dimension(jPanel1PositionX,this.jPanel3.getHeight()));
    this.jPanel4.setPreferredSize(new Dimension(jPanel1PositionX,365));
    this.add(this.jPanel2, new XYConstraints(0, 0, -1, -1));
    this.add(this.jPanel3, new XYConstraints(0, this.jPanel2.getHeight(), -1, -1));
    this.add(this.jPanel1, new XYConstraints(jPanel1PositionX, 0, -1, -1));
    this.add(this.jPanel4, new XYConstraints(0, this.jPanel2.getHeight()+this.jPanel3.getHeight(), -1, -1));
  }

  void jButton10_actionPerformed(ActionEvent e) {
    if (this.container.shareap != null) {
      this.container.jTabbedPane1.add("Shared Files", this.container.shareap);
    }
  }

  void jButton11_actionPerformed(ActionEvent e) {
    try{
      if(this.jTextField7.getText() != null &&
         this.jTextField7.getText() != "" &&
         !this.jTextField8.equals("")){
        InetAddress addr = InetAddress.getByName(this.jTextField7.getText());
        int port = Integer.parseInt(this.jTextField8.getText());
        InetAddressEngine.addTrustedPeer(addr, port);
        this.jList4.setListData(InetAddressEngine.getTrustedPeers().toArray());
      }
    }catch(Exception ex){
      this.jTextField7.setText("");
    }
  }

  void jTextField8_focusLost(FocusEvent e) {
    try {
      int port = Integer.parseInt(this.jTextField8.getText());
      if (port <= 0 || port > 65536)
        throw new Exception("Invalid port number");
    }
    catch (Exception ex) {
      this.jTextField8.setText("");
    }
  }

  void jButton12_actionPerformed(ActionEvent e) {
    if(this.jList4.getSelectedValue() != null)
      InetAddressEngine.removeTrustedPeer((ServerInfo)this.jList4.getSelectedValue());
      this.jList4.setListData(InetAddressEngine.getTrustedPeers().toArray());
  }
}

class ConnectionAntPanel_jButton3_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton3_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    final ActionEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jButton3_actionPerformed(event);
        return null;
      }
    };
    worker.start();
  }
}

class ConnectionAntPanel_jButton1_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton1_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    final ActionEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jButton1_actionPerformed(event);
        return null;
      }
    };
    worker.start();
  }
}

class ConnectionAntPanel_jButton2_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton2_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}

class ConnectionAntPanel_jButton4_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton4_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton4_actionPerformed(e);
  }
}

class ConnectionAntPanel_jButton5_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton5_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton5_actionPerformed(e);
  }
}

class ConnectionAntPanel_jButton6_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton6_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton6_actionPerformed(e);
  }
}

class ConnectionAntPanel_jButton7_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton7_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton7_actionPerformed(e);
  }
}

class ConnectionAntPanel_jButton8_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton8_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    final ActionEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jButton8_actionPerformed(event);
        return null;
      }
    };
    worker.start();
  }
}

class ConnectionAntPanel_jList3_mouseAdapter extends java.awt.event.MouseAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jList3_mouseAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jList3_mousePressed(e);
  }
}

class ConnectionAntPanel_jButton9_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton9_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton9_actionPerformed(e);
  }
}

class ConnectionAntPanel_jTextField4_focusAdapter extends java.awt.event.FocusAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jTextField4_focusAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField4_focusLost(e);
  }
}

class ConnectionAntPanel_jCheckBox1_changeAdapter implements javax.swing.event.ChangeListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jCheckBox1_changeAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.jCheckBox1_stateChanged(e);
  }
}

class ConnectionAntPanel_jTextField3_focusAdapter extends java.awt.event.FocusAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jTextField3_focusAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField3_focusLost(e);
  }
}

class ConnectionAntPanel_jTextField2_focusAdapter extends java.awt.event.FocusAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jTextField2_focusAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField2_focusLost(e);
  }
}

class ConnectionAntPanel_jTextField6_focusAdapter extends java.awt.event.FocusAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jTextField6_focusAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField6_focusLost(e);
  }
}

class ConnectionAntPanel_this_componentAdapter extends java.awt.event.ComponentAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_this_componentAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}

class ConnectionAntPanel_jButton10_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton10_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton10_actionPerformed(e);
  }
}

class ConnectionAntPanel_jButton11_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton11_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton11_actionPerformed(e);
  }
}

class ConnectionAntPanel_jTextField8_focusAdapter extends java.awt.event.FocusAdapter {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jTextField8_focusAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField8_focusLost(e);
  }
}

class ConnectionAntPanel_jButton12_actionAdapter implements java.awt.event.ActionListener {
  ConnectionAntPanel adaptee;

  ConnectionAntPanel_jButton12_actionAdapter(ConnectionAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton12_actionPerformed(e);
  }
}