package ants.p2p.gui;

import java.awt.*;
import java.util.*;
import java.net.*;
import com.borland.jbcl.layout.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.text.*;
import java.beans.*;

import ants.p2p.irc.*;

import org.jibble.pircbot.*;
import org.apache.log4j.*;
import javax.swing.event.*;
import javax.swing.border.*;

public class ChatAntPanel extends JPanel {
  public static String pic = "./backgrounds/bg1.jpg";
  static Logger _logger = Logger.getLogger(ChatAntPanel.class.getName());

  XYLayout xYLayout1 = new XYLayout();
  JList jList1 = new JList();
  JLabel jLabel1 = new JLabel();
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextPane jTextPane1 = new JTextPane();
  JTextField jTextField1 = new JTextField();
  IrcBot bot;
  JScrollPane jScrollPane2 = new JScrollPane();
  Image buffer;
  JLabel jLabel4 = new JLabel();
  JButton jButton1 = new JButton();
  JTextArea jTextArea1 = new JTextArea();
  JButton jButton2 = new JButton();
  JTextField jTextField3 = new JTextField();
  JLabel jLabel5 = new JLabel();
  JButton jButton3 = new JButton();

  boolean keepCurrentViewport = false;
  JViewport vp = null;
  JTextField jTextField4 = new JTextField();
  JScrollPane jScrollPane3 = new JScrollPane();
  JList jList2 = new JList();

  ArrayList pendingDiscussions = new ArrayList();
  Border border1;
  JPanel jPanel1 = new JPanel();
  XYLayout xYLayout2 = new XYLayout();

  public ChatAntPanel(IrcBot bot) {
    this.bot = bot;
    try{
      Toolkit tk = Toolkit.getDefaultToolkit();
      MediaTracker mt = new MediaTracker(this);
      buffer = tk.getImage(pic);
      mt.waitForAll();
    }catch(Exception e){}
    try {
      jbInit();
    }
    catch(Exception ex) {
      _logger.error("",ex);
    }
  }
  void jbInit() throws Exception {
    border1 = BorderFactory.createEmptyBorder(20,20,20,20);
    this.setBorder(border1);
    this.setDebugGraphicsOptions(0);
    this.addComponentListener(new ChatAntPanel_this_componentAdapter(this));
    this.setLayout(xYLayout1);
    jLabel1.setText("Users");
    xYLayout1.setWidth(764);
    xYLayout1.setHeight(489);
    jTextField1.setOpaque(true);
    jTextField1.setDocument(new StyledDiscussion());
    jTextField1.addKeyListener(new ChatAntPanel_jTextField1_keyAdapter(this));
    jTextPane1.setEditable(false);
    jTextPane1.setMargin(new Insets(5, 5, 30, 30));
    jTextPane1.addMouseListener(new ChatAntPanel_jTextPane1_mouseAdapter(this));
    jTextPane1.setAutoscrolls(true);
    jTextPane1.setOpaque(true);
    jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    jScrollPane1.setAutoscrolls(true);
    jScrollPane1.setOpaque(true);
    jLabel4.setText("Current channels:");
    jButton1.setText("Leave");
    jButton1.addActionListener(new ChatAntPanel_jButton1_actionAdapter(this));
    jTextArea1.setEnabled(true);
    jTextArea1.setOpaque(false);
    jTextArea1.setEditable(false);
    jTextArea1.setText("Commands:\nType words and press [ENTER] to send a message.\nSelect one or more users in the\nlist if you want to chat in private.\nFor multiple selections or unselection: [ctrl + click].\n/join [channel] -> join a channel\n/nick [newNick] -> change your nick");
    jButton2.setText("Request Op");
    jButton2.addActionListener(new ChatAntPanel_jButton2_actionAdapter(this));
    jTextField3.setMaximumSize(new Dimension(127, 2147483647));
    jTextField3.setMinimumSize(new Dimension(127, 21));
    jTextField3.setPreferredSize(new Dimension(127, 21));
    jTextField3.setText("");
    jLabel5.setText("Password for Op");
    jButton3.setText("Request Connection");
    jButton3.addActionListener(new ChatAntPanel_jButton3_actionAdapter(this));
    jTextField4.addFocusListener(new ChatAntPanel_jTextField4_focusAdapter(this));
    jList1.setOpaque(true);
    jTextField4.setOpaque(true);
    jTextField4.addKeyListener(new ChatAntPanel_jTextField4_keyAdapter(this));
    jList2.addMouseListener(new ChatAntPanel_jList2_mouseAdapter(this));
    jList2.setCellRenderer(new MyCellRenderer(this));
    jList2.setSelectionForeground(Color.white);
    jList2.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jPanel1.setLayout(xYLayout2);
    jPanel1.setOpaque(false);
    this.add(jLabel1,   new XYConstraints(11, 18, -1, -1));
    this.add(jScrollPane1,           new XYConstraints(148, 35, 388, 223));
    jScrollPane1.getViewport().add(jTextPane1, null);
    this.add(jTextField1,   new XYConstraints(148, 263, 388, -1));
    this.add(jScrollPane2,      new XYConstraints(9, 35, 127, 248));
    this.add(jTextField4,   new XYConstraints(148, 11, 388, -1));
    this.add(jScrollPane3,    new XYConstraints(541, 36, 118, 224));
    this.add(jLabel4,  new XYConstraints(545, 18, -1, -1));
    this.add(jButton1, new XYConstraints(541, 263, -1, -1));
    this.add(jPanel1,                      new XYConstraints(0, 303, 717, 140));
    jPanel1.add(jButton2,    new XYConstraints(0, 0, -1, -1));
    jPanel1.add(jTextField3,    new XYConstraints(0, 50, -1, -1));
    jPanel1.add(jLabel5,   new XYConstraints(0, 30, -1, -1));
    jPanel1.add(jButton3,    new XYConstraints(0, 110, -1, -1));
    jPanel1.add(jTextArea1,                   new XYConstraints(175, 0, 500, 121));
    jScrollPane3.getViewport().add(jList2, null);
    jScrollPane2.getViewport().add(jList1, null);
  }

  public JTextPane getJTextPanel(){
    return this.jTextPane1;
  }

  public String getCurrentSelectedDiscussion(){
    return (String)this.jList2.getSelectedValue();
  }

  public JList getUserList(){
    return this.jList1;
  }

  public void setUserList(User[] users) {
    if(users != null){
      this.jList1.setListData(users);
    }
  }

  public void setTopic(String topic){
    this.jTextField4.setText(topic);
  }

  public void setChannel(String channel){
    for(int x = 0; x < this.bot.getDiscussions().length; x++){
      if (this.bot.getDiscussions()[x].equals(channel)) {
        this.jList2.setSelectedIndex(x);
        this.setTopic(this.bot.getTopic(channel));
        this.checkOp();
        return;
      }
    }
    this.checkOp();
    this.pendingDiscussions.remove(channel);
    this.jList2.revalidate();
  }

  public void checkOp(){
    try{
      if (this.getUserList().getNextMatch("@" + this.bot.getNick(), 0, Position.Bias.Forward) != -1 ||
          this.getUserList().getNextMatch("@", 0, Position.Bias.Forward) == -1 )
        this.jTextField4.setEditable(true);
      else
        this.jTextField4.setEditable(false);
    }
    catch (Exception e) {}
  }

  public void addDiscussion(String key){
    this.jList2.setListData(this.bot.getDiscussions());
    this.jList2.revalidate();
  }

  public void setMessage(String key, String user, String message){
    String selected = (String)this.jList2.getSelectedValue();
    this.bot.setMessage(key, message, user);
    this.jList2.setListData(this.bot.getDiscussions());
    this.jList2.setSelectedValue(selected,true);
    if(this.jList2.getSelectedValue().equals(key)){
      this.jTextPane1.setDocument(this.bot.getDiscussion(key));
      if(!this.keepCurrentViewport)
        this.jTextPane1.scrollRectToVisible(new Rectangle(new Point(0,this.jTextPane1.getHeight()-this.jScrollPane1.getHeight()),new Dimension(this.jScrollPane1.getWidth(),this.jScrollPane2.getHeight())));
      else
        this.jTextPane1.scrollRectToVisible(new Rectangle(this.vp.getLocation(), this.vp.getSize()));
      this.repaint();
    }else{
      if(!this.pendingDiscussions.contains(key))
        this.pendingDiscussions.add(key);
      this.repaint();
    }
  }

  public void setControlMessage(String key, String message){
    this.bot.setControlMessage(key, message);
    if(this.jList2.getSelectedValue().equals(key)){
      this.jTextPane1.setDocument(this.bot.getDiscussion(key));
      if(!this.keepCurrentViewport)
        this.jTextPane1.scrollRectToVisible(new Rectangle(new Point(0,this.jTextPane1.getHeight()-this.jScrollPane1.getHeight()),new Dimension(this.jScrollPane1.getWidth(),this.jScrollPane2.getHeight())));
      else
        this.jTextPane1.scrollRectToVisible(new Rectangle(this.vp.getLocation(), this.vp.getSize()));
    }else{
      if(!this.pendingDiscussions.contains(key))
        this.pendingDiscussions.add(key);
      this.repaint();
    }
  }

  String getFirstParameter(String input){
    input = input.trim();
    if(input.indexOf(' ') > 0)
      input = input.substring(0,input.indexOf(' '));
    return input;
  }

  void jTextField1_keyPressed(KeyEvent e) {
    if (e.getKeyChar() == '\n') {
      if(this.jTextField1.getText().startsWith("/nick ")){
        String nick = this.jTextField1.getText().substring(6);
        nick = this.getFirstParameter(nick);
        if(nick != null & nick.length() > 0){
          this.bot.changeNick(nick);
          this.bot.getCaller().setNick(nick);
        }
        this.jTextField1.setText("");
      }else if(this.jTextField1.getText().startsWith("/me ")){
        String action = this.jTextField1.getText().substring(4);
        if(action != null & action.length() > 0){
          if(((String)this.getCurrentSelectedDiscussion()).charAt(0)=='#'){
            this.bot.sendAction( (String)this.getCurrentSelectedDiscussion(),
                                action);
            this.setControlMessage( (String)this.getCurrentSelectedDiscussion(),
                                   "* " + this.bot.getNick() + " "+action);
          }
        }
        this.jTextField1.setText("");
      }else if(this.jTextField1.getText().startsWith("/join ")){
        String channel = this.jTextField1.getText().substring(6);
        channel = this.getFirstParameter(channel);
        if(channel.charAt(0)=='#' &&
           channel.length() > 1){
          if (Arrays.binarySearch(this.bot.getChannels(),
                                  channel) <
              0) {
            this.bot.joinChannel(channel);
            try {
              Thread.sleep(2000);
            }
            catch (Exception ex) {
              _logger.error("", ex);
            }
            this.bot.refreshUsers(channel);
          }
          else {
            this.bot.getCaller().setIrcUsersNumberInChannel(this.bot.getUsers(channel).length,
                channel);
            Object[] selected = this.getUserList().getSelectedValues();
            this.setUserList(this.bot.getUsers(channel));
            for (int x = 0; x < selected.length; x++) {
              this.getUserList().setSelectedValue(selected[x], true);
            }
          }
          this.jTextField1.setText("");
        }
      }else if(((String)this.getCurrentSelectedDiscussion()).charAt(0)=='#'){
        if (this.jList1.getSelectedValues().length > 0) {
          for (int x = 0; x < this.jList1.getSelectedValues().length; x++) {
            User user = (User)this.jList1.getSelectedValues()[x];
            if (!user.getNick().equals(ConnectionAntPanel.nick)){
              this.bot.sendMessage(user.getNick(), this.jTextField1.getText());
              this.setMessage(user.getNick(), bot.getNick(),
                              this.jTextField1.getText());
            }
          }
          this.jTextField1.setText("");
        }
        else {
          this.bot.sendMessage(this.getCurrentSelectedDiscussion(),
                               this.jTextField1.getText());
          this.setMessage(this.getCurrentSelectedDiscussion(), bot.getNick(),
                          this.jTextField1.getText());
          this.jTextField1.setText("");
        }
      }else{
        this.bot.sendMessage((String)this.getCurrentSelectedDiscussion(), this.jTextField1.getText());
        this.setMessage((String)this.getCurrentSelectedDiscussion(), bot.getNick(), this.jTextField1.getText());
        this.jTextField1.setText("");
      }
    }
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    if (buffer != null){
      int posX = (this.getWidth() - 650)/2;
      int posY = (this.getHeight() - 550)/2;
      if(posX < 0) posX = 0;
      if(posY < 0) posY = 0;
      g.drawImage(buffer, posX, posY, this);
    }
  }

  void jButton1_actionPerformed(ActionEvent e) {
    if(!this.jList2.getSelectedValue().equals(ConnectionAntPanel.ircChannel) &&
       ((String)this.jList2.getSelectedValue()).charAt(0)=='#'){
      this.bot.partChannel((String)this.jList2.getSelectedValue());
      this.bot.removeDiscussion((String)this.jList2.getSelectedValue());
      this.jList2.setListData(this.bot.getDiscussions());
      this.jList2.setSelectedValue(ConnectionAntPanel.ircChannel,true);
      this.refreshCurrentChannel();
    }else if(!(((String)this.jList2.getSelectedValue()).charAt(0)=='#')){
      this.bot.removeDiscussion((String)this.jList2.getSelectedValue());
      this.jList2.setListData(this.bot.getDiscussions());
      this.jList2.setSelectedValue(ConnectionAntPanel.ircChannel,true);
      this.refreshCurrentChannel();
    }
  }

  void jButton3_actionPerformed(ActionEvent e) {
    if ( ( (String)this.getCurrentSelectedDiscussion()).charAt(0) == '#') {
      if (this.jList1.getSelectedValues().length > 0) {
        for (int x = 0; x < this.jList1.getSelectedValues().length; x++) {
          User user = (User)this.jList1.getSelectedValues()[x];
          if (!user.getNick().equals(ConnectionAntPanel.nick)){
            try{
              this.bot.sendMessage(user.getNick(),
                                   "CommandCode:0001 " +
                                   FrameAnt.getInstance(null).ga.cap.getLocalAddress().getHostAddress() +
                                   ":" +
                                   this.bot.getCaller().warriorAnt.getServerPort());
            }catch(Exception ex){_logger.error("",ex);}
          }
        }
      }
    }
  }

  void jButton2_actionPerformed(ActionEvent e) {
    if ( ( (String)this.getCurrentSelectedDiscussion()).charAt(0) == '#') {
      if (this.jList1.getSelectedValues().length > 0) {
        for (int x = 0; x < this.jList1.getSelectedValues().length; x++) {
          User user = (User)this.jList1.getSelectedValues()[x];
          if (!user.getNick().equals(ConnectionAntPanel.nick)) {
            try {
              this.bot.sendMessage(user.getNick(),
                                   "CommandCode:0002 " +
                                   this.jTextField3.getText() + " " +
                                   (String)this.getCurrentSelectedDiscussion());
            }
            catch (Exception ex) {
              _logger.error("",ex);
            }
          }
        }
      }
    }
  }

  void jTextPane1_mousePressed(MouseEvent e) {
    if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON3) {
      if (this.keepCurrentViewport = false) {
        this.vp = this.jScrollPane1.getViewport();
        this.keepCurrentViewport = true;
      }
      else {
        this.vp = null;
        this.keepCurrentViewport = false;
      }
    }
  }

  void jTextField4_focusLost(FocusEvent e) {
    //this.bot.setTopic(this.bot.getActiveChannel(),this.jTextField4.getText());
  }

  void jTextField4_keyPressed(KeyEvent e) {
    if(e.getKeyChar()=='\n'){
      this.bot.setTopic(this.bot.getActiveChannel(),this.jTextField4.getText());
    }
  }


  public void refreshCurrentChannel(){
    this.bot.getCaller().setIrcUsersNumberInChannel(this.bot.getUsers((String)this.jList2.getSelectedValue()).length,
                                           (String)this.jList2.getSelectedValue());
    Object[] selected = this.getUserList().getSelectedValues();
    this.bot.refreshUsers((String)this.jList2.getSelectedValue());
    for (int x = 0; x < selected.length; x++) {
      this.getUserList().setSelectedValue(selected[x], true);
    }
    StyledDocument discussion = this.bot.getDiscussion((String)this.jList2.getSelectedValue());
    if(discussion != null) this.jTextPane1.setDocument(discussion);
    this.pendingDiscussions.remove(this.jList2.getSelectedValue());
  }

  void this_componentResized(ComponentEvent e) {
    int width = this.getWidth() - 40;
    int height = this.getHeight() - 100 - this.jPanel1.getHeight() - this.jTextField4.getHeight();
    this.remove(this.jTextField4);
    this.remove(this.jTextField1);
    this.remove(this.jScrollPane1);
    this.remove(this.jScrollPane2);
    this.remove(this.jScrollPane3);
    this.remove(this.jLabel1);
    this.remove(this.jLabel4);
    this.remove(this.jButton1);
    this.remove(this.jPanel1);
    this.add(jTextField4,   new XYConstraints(2*width/12, 0, 7*width/12, -1));
    this.add(jScrollPane3,    new XYConstraints(9*width/12, this.jTextField4.getHeight(), 3*width/12, height));
    this.add(jScrollPane2,      new XYConstraints(0, this.jTextField4.getHeight(), 2*width/12, height));
    this.add(jScrollPane1,           new XYConstraints(2*width/12, this.jTextField4.getHeight(), 7*width/12, height));
    this.add(jTextField1,   new XYConstraints(width/6, this.jTextField4.getHeight() + height, 7*width/12, -1));
    this.add(jLabel1,   new XYConstraints(0, 0, -1, -1));
    this.add(jLabel4,  new XYConstraints(9*width/12, 0, -1, -1));
    this.add(jButton1, new XYConstraints(9*width/12, height + 20, -1, -1));
    this.add(jPanel1,           new XYConstraints(0, height + 60, width, 140));
  }

  void jList2_mouseReleased(MouseEvent e) {
    this.refreshCurrentChannel();
  }
}

class ChatAntPanel_jTextField1_keyAdapter extends java.awt.event.KeyAdapter {
  ChatAntPanel adaptee;

  ChatAntPanel_jTextField1_keyAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void keyPressed(KeyEvent e) {
    adaptee.jTextField1_keyPressed(e);
  }
}

class ChatAntPanel_jButton1_actionAdapter implements java.awt.event.ActionListener {
  ChatAntPanel adaptee;

  ChatAntPanel_jButton1_actionAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton1_actionPerformed(e);
  }
}

class ChatAntPanel_jButton3_actionAdapter implements java.awt.event.ActionListener {
  ChatAntPanel adaptee;

  ChatAntPanel_jButton3_actionAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton3_actionPerformed(e);
  }
}

class ChatAntPanel_jButton2_actionAdapter implements java.awt.event.ActionListener {
  ChatAntPanel adaptee;

  ChatAntPanel_jButton2_actionAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}

class ChatAntPanel_jTextPane1_mouseAdapter extends java.awt.event.MouseAdapter {
  ChatAntPanel adaptee;

  ChatAntPanel_jTextPane1_mouseAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jTextPane1_mousePressed(e);
  }
}

class ChatAntPanel_jTextField4_focusAdapter extends java.awt.event.FocusAdapter {
  ChatAntPanel adaptee;

  ChatAntPanel_jTextField4_focusAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void focusLost(FocusEvent e) {
    adaptee.jTextField4_focusLost(e);
  }
}

class ChatAntPanel_jTextField4_keyAdapter extends java.awt.event.KeyAdapter {
  ChatAntPanel adaptee;

  ChatAntPanel_jTextField4_keyAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void keyPressed(KeyEvent e) {
    adaptee.jTextField4_keyPressed(e);
  }
}

class ChatAntPanel_jList2_mouseAdapter extends java.awt.event.MouseAdapter {
  ChatAntPanel adaptee;

  ChatAntPanel_jList2_mouseAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void mouseReleased(MouseEvent e) {
    adaptee.jList2_mouseReleased(e);
  }
}

class MyCellRenderer extends JLabel implements ListCellRenderer {
     ChatAntPanel cap;

     public MyCellRenderer(ChatAntPanel cap) {
         this.cap = cap;
         setOpaque(true);
     }
     public Component getListCellRendererComponent(
         JList list,
         Object value,
         int index,
         boolean isSelected,
         boolean cellHasFocus)
     {
         setText(value.toString());
         boolean isPending;
         if(cap != null && cap.pendingDiscussions.contains(value.toString()))
           isPending = true;
         else
           isPending = false;
         if(!isPending){
           setBackground(isSelected ? Color.blue : Color.white);
           setForeground(isSelected ? Color.white : Color.black);
         }else{
           setBackground(Color.lightGray);
           setForeground(Color.black);
         }
         return this;
     }
 }

class ChatAntPanel_this_componentAdapter extends java.awt.event.ComponentAdapter {
  ChatAntPanel adaptee;

  ChatAntPanel_this_componentAdapter(ChatAntPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void componentResized(ComponentEvent e) {
    adaptee.this_componentResized(e);
  }
}
