//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p.gui;

import javax.swing.*;

import ants.p2p.*;
import ants.p2p.query.*;
import ants.p2p.query.security.*;
import ants.p2p.security.*;
import java.awt.event.*;
import javax.swing.tree.*;
import java.beans.*;
import java.awt.*;
import java.io.*;

import ants.p2p.*;

import org.apache.log4j.*;

public class AntPopupMenu extends JPopupMenu {
  QueryAntPanel callerQuery;
  DownloadAntPanel callerDownload;
  UploadAntPanel callerUpload;
  JPanel caller;
  FilePullMessageProcessor toBeInterrupted;
  QueryFileTuple fileToDownload;
  QueryFileTuple source;
  InterruptedDownload toBeProcessed;
  MultipleSourcesDownloadManager downloader;
  JMenuItem jMenuItem1 = new JMenuItem();
  JMenuItem jMenuItem2 = new JMenuItem();
  int selRow;
  TreePath selPath;
  JMenuItem jMenuItem3 = new JMenuItem();
  JMenuItem jMenuItem4 = new JMenuItem();
  JMenuItem jMenuItem5 = new JMenuItem();
  JMenuItem jMenuItem6 = new JMenuItem();
  JMenuItem jMenuItem7 = new JMenuItem();
  JMenuItem jMenuItem8 = new JMenuItem();

  static Logger _logger = Logger.getLogger(AntPopupMenu.class.getName());
  JMenuItem jMenuItem9 = new JMenuItem();

  public AntPopupMenu(QueryAntPanel callerQuery, QueryFileTuple fileToDownload, int selRow, TreePath selPath) {
    super();
    this.selPath = selPath;
    this.selRow = selRow;
    this.fileToDownload = fileToDownload;
    this.callerQuery = callerQuery;
    this.caller = caller;
    this.addPropertyChangeListener(this.callerQuery.container.dap);
    try {
      jbInit();
    }
    catch(Exception e) {
      _logger.error("", e);
    }
  }

  public AntPopupMenu(DownloadAntPanel caller, MultipleSourcesDownloadManager downloader,
                      int selRow, TreePath selPath) {
    super();
    this.selPath = selPath;
    this.selRow = selRow;
    this.downloader = downloader;
    this.callerDownload = (DownloadAntPanel)caller;
    this.caller = caller;
    this.addPropertyChangeListener(this.callerDownload);
    try {
      jbInit();
    }
    catch (Exception e) {
      _logger.error("", e);
    }
  }

  public AntPopupMenu(DownloadAntPanel caller, QueryFileTuple source, MultipleSourcesDownloadManager downloader,
                      int selRow, TreePath selPath) {
    super();
    this.selPath = selPath;
    this.selRow = selRow;
    this.downloader = downloader;
    this.source = source;
    this.callerDownload = (DownloadAntPanel)caller;
    this.caller = caller;
    this.addPropertyChangeListener(this.callerDownload);
    try {
      jbInit();
    }
    catch (Exception e) {
      _logger.error("", e);
    }
  }

  public AntPopupMenu(DownloadAntPanel caller, InterruptedDownload toBeProcessed,
                      int selRow, TreePath selPath) {
    super();
    this.selPath = selPath;
    this.selRow = selRow;
    this.toBeProcessed = toBeProcessed;
    this.callerDownload = (DownloadAntPanel)caller;
    this.caller = caller;
    try {
      jbInit();
    }
    catch (Exception e) {
      _logger.error("", e);
    }
  }

  public AntPopupMenu(UploadAntPanel caller, FilePullMessageProcessor toBeInterrupted,
                      int selRow, TreePath selPath) {
    super();
    this.selPath = selPath;
    this.selRow = selRow;
    this.toBeInterrupted = toBeInterrupted;
    this.callerUpload = (UploadAntPanel)caller;
    this.caller = caller;

    try {
      jbInit();
    }
    catch (Exception e) {
      _logger.error("", e);
    }
  }

  private void jbInit() throws Exception {
    jMenuItem2.setText("Download File");
    jMenuItem2.addMouseListener(new AntPopupMenu_jMenuItem2_mouseAdapter(this));
    jMenuItem1.setActionCommand("Secure connection");
    jMenuItem1.setText("Download File (Create secure connection)");
    jMenuItem1.addMouseListener(new AntPopupMenu_jMenuItem1_mouseAdapter(this));
    jMenuItem3.setText("Clear");
    jMenuItem3.addMouseListener(new AntPopupMenu_jMenuItem3_mouseAdapter(this));
    jMenuItem4.setText("Interrupt");
    jMenuItem4.addMouseListener(new AntPopupMenu_jMenuItem4_mouseAdapter(this));
    jMenuItem5.setText("Remove source");
    jMenuItem5.addMouseListener(new AntPopupMenu_jMenuItem5_mouseAdapter(this));
    jMenuItem6.setText("Search sources");
    jMenuItem6.addMouseListener(new AntPopupMenu_jMenuItem6_mouseAdapter(this));
    jMenuItem7.setText("Interrupt");
    jMenuItem7.addMouseListener(new AntPopupMenu_jMenuItem7_mouseAdapter(this));
    jMenuItem8.setText("Remove Interrupted");
    jMenuItem8.addMouseListener(new AntPopupMenu_jMenuItem8_mouseAdapter(this));
    jMenuItem9.setText("Activate Autoresume");
    jMenuItem9.addMouseListener(new AntPopupMenu_jMenuItem9_mouseAdapter(this));
    this.add(jMenuItem1);
    this.add(jMenuItem2);
    this.add(jMenuItem3);
    this.add(jMenuItem4);
    this.add(jMenuItem5);
    this.add(jMenuItem6);
    this.add(jMenuItem7);
    this.add(jMenuItem8);
    this.add(jMenuItem9);

    if(this.callerQuery != null){
      EndpointSecurityManager esm = this.callerQuery.container.cap.warriorAnt.
            getOutputSecureConnectionManager(fileToDownload.getOwnerID());
      this.remove(jMenuItem3);
      this.remove(jMenuItem4);
      this.remove(jMenuItem5);
      this.remove(jMenuItem6);
      this.remove(jMenuItem7);
      this.remove(jMenuItem8);
      this.remove(jMenuItem9);
      if (esm == null){
        this.remove(jMenuItem2);
      }
      else{
        this.remove(jMenuItem1);
        DefaultMutableTreeNode[] msdmInterrupted = new
            DefaultMutableTreeNode[this.callerQuery.container.dap.
            interruptedRoot.
            getChildCount()];
        for (int x = 0; x < msdmInterrupted.length; x++) {
          msdmInterrupted[x] = (DefaultMutableTreeNode)this.callerQuery.
              container.
              dap.interruptedRoot.getChildAt(x);
        }
        for (int x = 0; x < msdmInterrupted.length; x++) {
          InterruptedDownload currentNode = (
              InterruptedDownload) msdmInterrupted[x].
              getUserObject();
          if (currentNode.getFileHash().equals(fileToDownload.getFileHash())) {
            jMenuItem2.setText("Resume");
          }
        }
      }
    }
    if(this.callerDownload != null){
      this.remove(jMenuItem1);
      this.remove(jMenuItem2);
      this.remove(jMenuItem7);
      if(source != null){
        this.remove(jMenuItem3);
        this.remove(jMenuItem4);
        this.remove(jMenuItem6);
        this.remove(jMenuItem8);
        this.remove(jMenuItem9);
      }else if(downloader!=null){
        if (downloader.isAlive()) {
          this.remove(jMenuItem3);
          this.remove(jMenuItem5);
          this.remove(jMenuItem8);
          if(downloader.isAutoresumeActive())
            this.jMenuItem9.setText("Deactivate Autoresume");
        }
        else {
          this.remove(jMenuItem4);
          this.remove(jMenuItem5);
          this.remove(jMenuItem6);
          this.remove(jMenuItem8);
          this.remove(jMenuItem9);
        }
      }else if(toBeProcessed!=null){
        this.remove(jMenuItem3);
        this.remove(jMenuItem4);
        this.remove(jMenuItem5);
        if(toBeProcessed.isAutoresumeActive())
            this.jMenuItem9.setText("Deactivate Autoresume");
      }
    }
    if(this.callerUpload != null){
      this.remove(jMenuItem1);
      this.remove(jMenuItem2);
      this.remove(jMenuItem3);
      this.remove(jMenuItem4);
      this.remove(jMenuItem5);
      this.remove(jMenuItem6);
      this.remove(jMenuItem8);
      this.remove(jMenuItem9);
    }
  }

  void jMenuItem1_mousePressed(MouseEvent e) {
    if (this.fileToDownload != null) {
      this.callerQuery.container.cap.warriorAnt.scheduleDownload(this.fileToDownload);
      this.callerQuery.container.cap.warriorAnt.createSecureConnection(this.
          fileToDownload.getOwnerID());
      this.setVisible(false);
    }
  }

  void jMenuItem2_mousePressed(MouseEvent e) {
    this.firePropertyChange("addSourcePeer",null,this.fileToDownload);
    this.setVisible(false);
  }

  void jMenuItem3_mousePressed(MouseEvent e) {
    DefaultMutableTreeNode toBeRemoved = ((DefaultMutableTreeNode) selPath.getLastPathComponent());
    this.callerDownload.downloadTree.removeNodeFromParent(toBeRemoved);
    this.callerDownload.jTree1.setModel(this.callerDownload.downloadTree);
    //this.callerDownload.downloadTree.reload();
    this.callerDownload.repaint();
  }

  void jMenuItem4_mousePressed(MouseEvent e) {
    DefaultMutableTreeNode toBeRemoved = ((DefaultMutableTreeNode) selPath.getLastPathComponent());
    MultipleSourcesDownloadManager msdm = (MultipleSourcesDownloadManager)toBeRemoved.getUserObject();
    msdm.setInterrupt(true);
    this.callerDownload.downloadTree.removeNodeFromParent(toBeRemoved);
    this.callerDownload.jTree1.setModel(this.callerDownload.downloadTree);
    this.callerDownload.downloadTree.reload();
    this.callerDownload.repaint();
    InterruptedDownload interruptedDownload = new
        InterruptedDownload(msdm);
    if (msdm.isAutoresumeActive()) {
      msdm.getAutoresumeEngine().setInterruptedDownload(
          interruptedDownload);
    }
    this.callerDownload.interruptedRoot.add(new DefaultMutableTreeNode(interruptedDownload));
    this.callerDownload.jTree2.setModel(this.callerDownload.interruptedTree);
    this.callerDownload.interruptedTree.reload();
    this.callerDownload.repaint();
  }

  void jMenuItem5_mousePressed(MouseEvent e) {
    DefaultMutableTreeNode toBeRemoved = ((DefaultMutableTreeNode) selPath.getLastPathComponent());
    DefaultMutableTreeNode father = ((DefaultMutableTreeNode) selPath.getParentPath().getLastPathComponent());
    MultipleSourcesDownloadManager msdm = (MultipleSourcesDownloadManager)father.getUserObject();
    QueryFileTuple qft = (QueryFileTuple)toBeRemoved.getUserObject();
    if(msdm.removePeer(qft.getOwnerID())!=null){
      if(msdm.getPeersNumber() > 0){
        this.callerDownload.downloadTree.removeNodeFromParent(toBeRemoved);
        //this.callerDownload.jTree1.setModel(this.callerDownload.downloadTree);
        //this.callerDownload.downloadTree.reload();
        this.callerDownload.repaint();
      }else{
        this.callerDownload.downloadTree.removeNodeFromParent(father);
        this.callerDownload.jTree1.setModel(this.callerDownload.downloadTree);
        this.callerDownload.downloadTree.reload();
        this.callerDownload.repaint();
        InterruptedDownload interruptedDownload = new
            InterruptedDownload(msdm);
        if (msdm.isAutoresumeActive()) {
          /*msdm.deactivateAutoresumeEngine();
          AutoresumeEngine ae = new AutoresumeEngine(interruptedDownload,
              this.callerDownload.container.cap.warriorAnt);
          ae.pcs.addPropertyChangeListener(this.callerDownload);
          interruptedDownload.addAutoresumeEngine(ae);*/
          msdm.getAutoresumeEngine().setInterruptedDownload(interruptedDownload);
        }
        this.callerDownload.interruptedRoot.add(new DefaultMutableTreeNode(interruptedDownload));
        this.callerDownload.jTree2.setModel(this.callerDownload.interruptedTree);
        this.callerDownload.interruptedTree.reload();
        this.callerDownload.repaint();
      }
    }
  }

  void jMenuItem6_mousePressed(MouseEvent e) {
    if(this.toBeProcessed!=null){
      DefaultMutableTreeNode selected = ( (DefaultMutableTreeNode) selPath.
                                         getLastPathComponent());
      InterruptedDownload toBeResumed = (InterruptedDownload) selected.
          getUserObject();
      QueryAntPanel qap = new QueryAntPanel(this.callerDownload.container);
      qap.jTextField1.setText(toBeResumed.getFileHash());
      this.callerDownload.container.queryPanels.add(qap);
      int max = toBeResumed.getFileName().length();
      if (max > 10)
        max = 10;
      this.callerDownload.container.jTabbedPane1.add("Query: " +
          toBeResumed.getFileHash().substring(0, max), qap);
      this.callerDownload.container.cap.warriorAnt.getPropertyChangeSupport().
          addPropertyChangeListener(qap);
      try {
        QueryHashItem qsi = new QueryHashItem(null, toBeResumed.getFileHash());
        AsymmetricProvider ap = new AsymmetricProvider(false);
        qap.currentQuery = (QueryMessage) qap.container.cap.warriorAnt.doQuery(
            qsi, ap.getPublicHeader(), WarriorAnt.queryTimeToLive).getMessage();
        qap.jLabel2.setText("Last search (by hash): " + toBeResumed.getFileHash());
      }
      catch (Exception ex) {
        _logger.error("",ex);
      }
    }else if(this.downloader!=null){
      DefaultMutableTreeNode selected = ( (DefaultMutableTreeNode) selPath.
                                         getLastPathComponent());
      MultipleSourcesDownloadManager downloader = (MultipleSourcesDownloadManager) selected.
          getUserObject();
      QueryAntPanel qap = new QueryAntPanel(this.callerDownload.container);
      qap.jTextField1.setText(downloader.getFileHash());
      this.callerDownload.container.queryPanels.add(qap);
      int max = downloader.getFileName().length();
      if (max > 10)
        max = 10;
      this.callerDownload.container.jTabbedPane1.add("Query: " +
          downloader.getFileHash().substring(0, max), qap);
      this.callerDownload.container.cap.warriorAnt.getPropertyChangeSupport().
          addPropertyChangeListener(qap);
      try {
        QueryHashItem qsi = new QueryHashItem(null, downloader.getFileHash());
        AsymmetricProvider ap = new AsymmetricProvider(false);
        qap.currentQuery = (QueryMessage) qap.container.cap.warriorAnt.doQuery(
            qsi, ap.getPublicHeader(), WarriorAnt.queryTimeToLive).getMessage();
        qap.jLabel2.setText("Last search (by hash): " + downloader.getFileHash());
      }
      catch (Exception ex) {
        _logger.error("",ex);
      }
    }
  }

  void jMenuItem7_mousePressed(MouseEvent e) {
    DefaultMutableTreeNode selected = ((DefaultMutableTreeNode) selPath.getLastPathComponent());
    FilePullMessageProcessor toBeInterrupted = (FilePullMessageProcessor)selected.getUserObject();
    toBeInterrupted.terminate();
    this.callerUpload.uploadTree.removeNodeFromParent(selected);
    this.callerUpload.jTree1.setModel(this.callerUpload.uploadTree);
    this.callerUpload.uploadTree.reload();
    this.callerUpload.repaint();
  }

  void jMenuItem8_mousePressed(MouseEvent e) {
    if (this.toBeProcessed != null) {
      DefaultMutableTreeNode selected = ( (DefaultMutableTreeNode) selPath.
                                         getLastPathComponent());
      InterruptedDownload toBeRemoved = (InterruptedDownload) selected.
          getUserObject();
      toBeRemoved.deactivateAutoresumeEngine();
      toBeRemoved.removeInterrupted();
      this.callerDownload.container.dap.interruptedTree.removeNodeFromParent(selected);
      this.callerDownload.container.dap.jTree2.setModel(this.callerDownload.
          container.dap.interruptedTree);
      this.callerDownload.container.dap.repaint();
    }
  }

  void jMenuItem9_mousePressed(MouseEvent e) {
    if(this.downloader != null){
      if(this.downloader.isAutoresumeActive()){
        this.downloader.deactivateAutoresumeEngine();
      }
      else{
        AutoresumeEngine ae = new AutoresumeEngine(this.downloader, this.callerDownload);
      }
    }else if(this.toBeProcessed != null){
      if(this.toBeProcessed.isAutoresumeActive()){
        this.toBeProcessed.deactivateAutoresumeEngine();
      }
      else{
        AutoresumeEngine ae = new AutoresumeEngine(this.toBeProcessed, this.callerDownload.container.cap.warriorAnt, this.callerDownload);
      }
    }
  }
}


class AntPopupMenu_jMenuItem1_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem1_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem1_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem2_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem2_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem2_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem3_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem3_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem3_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem4_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem4_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem4_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem5_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem5_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem5_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem6_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem6_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem6_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem7_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem7_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem7_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem8_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem8_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    final MouseEvent event = e;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        adaptee.jMenuItem8_mousePressed(event);
        return null;
      }
    };
    worker.start();
  }
}

class AntPopupMenu_jMenuItem9_mouseAdapter extends java.awt.event.MouseAdapter {
  AntPopupMenu adaptee;

  AntPopupMenu_jMenuItem9_mouseAdapter(AntPopupMenu adaptee) {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e) {
    adaptee.jMenuItem9_mousePressed(e);
  }
}