//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p;

import java.util.*;
import ants.p2p.messages.*;
import ants.p2p.exceptions.*;

import org.apache.log4j.*;

/**
 * Lighweight class for a router process. The routing procedures are
 * defined in Ant class.
 */
public class Router
    extends Thread {

  static Logger _logger = Logger.getLogger(Router.class.getName());

  Ant ant = null;
  Message m;
  String requirer;
  boolean notifiedNetModification = false;

  public static double jumpProbability = 0; //NON USATO!!!
  public static int delay = 0;
  public static long timeToLive = 10000;
  public static int[] primes = {1,3,5,7,11,13,17,19,23,29,31,37,41,43,47,51,53,57,59};
  public static int timeToLiveDecreaseFactorIndex = 15;
  public static int timeToLiveDecreaseRounds = 2;
  public static boolean PARALLEL = true;
  public static int efficiencyLimit = 1000;
  public static int efficiencyModifier = 10;
  public static int inTransitQueue = 10000;
  public static int ownDeliveredMessagesQueue = 10000;

  RouterWatchDog rw = null;

  public SenderThread[] st = null;

  public int dieProbability = 5 + (int)(System.currentTimeMillis() % 10);
  public int routeProbability = 5 + (int)(System.currentTimeMillis() % 10);

  public Router() {
    this.rw = new RouterWatchDog(this);
  }

  public Router(Ant n, Message m, String requirer) {
    this.ant = n;
    this.m = m;
    this.requirer = requirer;
    this.rw = new RouterWatchDog(this);
  }

  public String getRequirer(){
    return this.requirer;
  }

  public void run() {
    try {
      rw.start();
      st = this.ant.route(null,m,this.requirer,this,true,false);
      if(st != null){
        for(int x = 0; x < this.st.length; x++){
          st[x].join();
        }
      }
      rw.stop();
      Ant.decBeingRoutedMessages();
    }
    catch (Throwable ex) {
      rw.stop();
      _logger.error(this.ant.getId() + " Router error: ",  ex);
    }
  }
}

class RouterWatchDog extends Thread{

  static Logger _logger = Logger.getLogger(RouterWatchDog.class.getName());

  public static long routeTimeout = 300000;
  Router r = null;

  public RouterWatchDog(Router r){
    super();
    this.r = r;
    this.setPriority(Thread.MIN_PRIORITY);
  }

  public void run(){
    long init = System.currentTimeMillis();
    while (true) {
      try {
        sleep(5000);
      }
      catch (Exception e) {
        _logger.error("",e);
      }
      long elapsed = System.currentTimeMillis() - init;
      if(elapsed > routeTimeout){
        _logger.info("Routing stopped...");
        try{
          for(int x = 0; x < r.st.length; x++){
            if (r.st[x] != null && r.st[x].isAlive())
              r.st[x].stop();
          }
        }catch(ThreadDeath td){_logger.info("Routing timed out: message killed");}
        try{
          if(r != null && r.isAlive())
            r.stop();
        }catch(ThreadDeath td){_logger.info("Routing timed out: message killed");}
        Ant.decBeingRoutedMessages();
        return;
      }
    }
  }
}
