//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p;

import java.util.*;

/**
 * A message wrapper is used to store a message (own or remote) and
 * its infos:
 * sender
 * destination
 * previous hop
 * next hop
 */
public class MessageWrapper {
  private Message message;
  private long creationDate;
  public java.util.List notToBeConsidered = Collections.synchronizedList(new ArrayList());
  public java.util.List alreadyVisited = Collections.synchronizedList(new ArrayList());
  private String routedTo = null;
  private String requiredBy = null;

  public MessageWrapper(Message message, String requirer) {
    this.message = message;
    creationDate = System.currentTimeMillis();
    this.requiredBy = requirer;
  }

  public void disableAutoRetransmit() {
    this.message.disableAutoRetransmit();
  }

  public Message getMessage() {
    return this.message;
  }

  public void setStoreFormat() {
    this.message = new Message(message);
  }

  public long getLifetime() {
    return System.currentTimeMillis() - this.creationDate;
  }

  public void retrasmitted(Ant n) {
    creationDate = System.currentTimeMillis();
    this.message.retrasmitted();
    //this.message.ack_id = n.getId() +"@"+ System.currentTimeMillis();vaffanculo!!!
  }

  public int getRetrasmissions() {
    return this.message.getRetrasmissions();
  }

  //Neighbour destination
  public String getRoutedTo() {
    return this.routedTo;
  }

  public String getRequirer() {
    return this.requiredBy;
  }

  public void setRoutedTo(String routedTo) {
    this.routedTo = routedTo;
  }

  public void setRequirer(String requiredBy) {
    this.requiredBy = requiredBy;
  }

  public boolean equals(Object o) {
    if (o instanceof MessageWrapper) {
      return ( (MessageWrapper) o).message.getAck_Id().equals(this.message.
          getAck_Id()) &&
          ( (MessageWrapper) o).message.getType() == this.message.getType();
    }
    else {
      try {
        return ( (Message) o).getAck_Id().equals(this.message.getAck_Id()) &&
            ( (Message) o).getType() == this.message.getType();
      }
      catch (ClassCastException e) {
        return o == this;
      }

    }
  }
}