//******************************************************************
//******************************************************************
//**********          ANts Peer To Peer Sources        *************
//
// ANts P2P realizes a third generation P2P net. It protects your
// privacy while you are connected and makes you not trackable, hiding
// your identity (ip) and crypting everything you are sending/receiving
// from others.

// Copyright (C) 2004  Roberto Rossi

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package ants.p2p;

import java.io.*;
import javax.crypto.*;
import java.math.*;

/**
 * This class models a message at Link/Net level. The message has
 * no body and contains only infos related to routing.
 */
public class Message implements Serializable{
  private final String antMessageVersion = Ant.getVersion();

  private int retransmissions;
  private boolean delivered = false;
  private boolean resolveLoop = false;
  private String source;
  private String dest;
  String ack_id;
  private int type;
  protected long ttl = Router.timeToLive;

  public Message(Message m){
    this.source = m.source;
    this.dest = m.dest;
    this.ack_id = m.ack_id;
    this.type = m.type;
    this.ttl = m.ttl;
    this.delivered = m.delivered;
    this.resolveLoop = m.resolveLoop;
    this.retransmissions = m.retransmissions;
  }

  public String getVersion(){
    return antMessageVersion;
  }

  public Message(MessageWrapper wm){
    this(wm.getMessage());
  }

  public void resetResolveLoop() {
    this.resolveLoop = false;
  }

  public void setResolveLoop() {
    this.resolveLoop = true;
  }

  public boolean getResolveLoop(){
    return this.resolveLoop;
  }

  public void disableAutoRetransmit() {
    this.retransmissions = Ant.maxRetransmissions;
  }

  public void retrasmitted() {
    this.retransmissions++;
  }

  public int getRetrasmissions() {
    return this.retransmissions;
  }

  public synchronized void decTTL(){
    int x = 0;
    int index = Router.timeToLiveDecreaseFactorIndex;
    while(x < Router.timeToLiveDecreaseRounds){
      x++;
      int decFactor = (int) (System.currentTimeMillis() % Router.primes[index++]);
      this.ttl -= decFactor;
    }
    if(this.ttl < 0) this.ttl = 0;
  }

  public void resetTTL(){
    this.ttl=Router.timeToLive;
    int x = 0;
    int index = Router.timeToLiveDecreaseFactorIndex;
    while(x < Router.timeToLiveDecreaseRounds){
      x++;
      int decFactor = (int) (System.currentTimeMillis() % Router.primes[index++]);
      this.ttl -= decFactor;
    }
    if(this.ttl < 0) this.ttl = 0;
    if(this.ttl < 0) this.ttl = 0;
  }

  public long getTTL(){
    return this.ttl;
  }

  public void setTTLtoZero(){
    this.ttl=0;
  }

  public void invalidate(){
    this.delivered = true;
  }

  public boolean getDelivered(){
    return this.delivered;
  }

  public void resetDelivered() {
    this.delivered=false;
  }

  public void setDelivered() {
    this.delivered=true;
  }

/*
  public Message(String source, String dest, int type, String id_ack) {
    this.type = type;
    //Type 0 Messages
    //Type 1 Ack
    //Type 2 Broad
    this.ack_id = id_ack;
    this.source = source;
    this.dest = dest;
  }
*/

  public Message() {
    this.type = -1;
    this.ack_id = null;
    //Type 0 Messages
    //Type 1 Ack
    this.source = null;
    this.dest = null;
    int x = 0;
    int index = Router.timeToLiveDecreaseFactorIndex;
    while(x < Router.timeToLiveDecreaseRounds){
      x++;
      int decFactor = (int) (System.currentTimeMillis() % Router.primes[index++]);
      this.ttl -= decFactor;
    }
    if(this.ttl < 0) this.ttl = 0;
    this.retransmissions = 0;
  }

  public void fillMessageProperties(String source, String dest, int type, String id_ack) {
    this.type = type;
    //Type 0 Messages
    //Type 1 Ack
    //Type 2 Discover
    this.ack_id = id_ack;
    this.source = source;
    this.dest = dest;
  }

  public int getType(){
    return this.type;
  }

  public String getAck_Id(){
    return this.ack_id;
  }

  public String getSource(){
    return this.source;
  }

  public String getDest(){
    return this.dest;
  }

  public boolean equals(Object o) {
    if (o instanceof MessageWrapper) {
      return ( (MessageWrapper) o).getMessage().getAck_Id().equals(this.
          getAck_Id()) &&
          ( (MessageWrapper) o).getMessage().getType() == this.getType();
    }
    else{
      try {
        return ( (Message) o).ack_id.equals(this.ack_id) &&
            ( (Message) o).type == this.type;
      }
      catch (ClassCastException e) {
        return o == this;
      }
    }
  }

  public void encrypt(Cipher enc)throws Exception{}
  public void decrypt(Cipher dec)throws Exception{}
}