package ants.p2p;

import ants.p2p.gui.*;
import ants.p2p.query.*;
import ants.p2p.query.security.*;
import ants.p2p.security.*;
import ants.p2p.messages.*;

import java.beans.*;
import java.util.*;

import org.apache.log4j.*;

/**
 * This class cooperates with a multiple sources download manager or an
 * interrupted download to realize an autoresume service for a download.
 */
public class AutoresumeEngine extends Thread implements PropertyChangeListener{
  MultipleSourcesDownloadManager msdm;
  InterruptedDownload interruptedDownload;
  WarriorAnt n;

  boolean terminate = false;

  public PropertyChangeSupport pcs = new PropertyChangeSupport(this);

  QueryMessage currentQuery = null;
  java.util.List secureConnectionRequired = Collections.synchronizedList(new ArrayList());;

  static int secureConnectionToTrace = 1000;
  public static int sleepRate = 180000;

  static Logger _logger = Logger.getLogger(AutoresumeEngine.class.getName());

  public AutoresumeEngine(MultipleSourcesDownloadManager msdm, DownloadAntPanel dap) {
    this.msdm = msdm;
    this.n = msdm.n;
    this.interruptedDownload = null;
    this.n.propertyChangeSupport.addPropertyChangeListener(this);
    this.pcs.addPropertyChangeListener(dap);
    this.setMultipleSourcesDownloadManager(msdm);
  }

  public AutoresumeEngine(InterruptedDownload interruptedDownload, WarriorAnt n, DownloadAntPanel dap) {
    this.msdm = null;
    this.interruptedDownload = interruptedDownload;
    this.n = n;
    this.n.propertyChangeSupport.addPropertyChangeListener(this);
    this.pcs.addPropertyChangeListener(dap);
    this.setInterruptedDownload(interruptedDownload);
  }

  public void deactivate(){
    this.n.propertyChangeSupport.removePropertyChangeListener(this);
    this.terminate = true;
    this.stop();
    if(this.msdm != null){
      _logger.info("Autoresume Engine deactivated for file: " + this.msdm.getFileHash());
    }else if(this.interruptedDownload != null){
      _logger.info("Autoresume Engine deactivated for file: " + this.interruptedDownload.getFileHash());
    }
  }

  public void run(){
    try{
      while(!terminate){
        synchronized(this){
          if (this.interruptedDownload != null) {
            _logger.info("Autoresume is running for file (interrupted): " +
                         this.interruptedDownload.
                         getFileHash());
            QueryHashItem qsi = new QueryHashItem(null,
                                                  this.interruptedDownload.
                                                  getFileHash());
            AsymmetricProvider ap = new AsymmetricProvider(false);

            Message query = this.n.doQuery(
                qsi, ap.getPublicHeader(), WarriorAnt.queryTimeToLive).
                getMessage();
            if(query != null && query instanceof QueryMessage)
              this.currentQuery = (QueryMessage)query;
          }
          else if (this.msdm != null) {
            _logger.info("Autoresume is running for file (downloading): " +
                         this.msdm.
                         getFileHash());
            QueryHashItem qsi = new QueryHashItem(null,
                                                  this.msdm.
                                                  getFileHash());
            AsymmetricProvider ap = new AsymmetricProvider(false);
            Message query = this.n.doQuery(
                qsi, ap.getPublicHeader(), WarriorAnt.queryTimeToLive).
                getMessage();
            if(query != null && query instanceof QueryMessage)
              this.currentQuery = (QueryMessage)query;
          }
        }
        this.sleep(sleepRate);
      }
    }catch(Exception e){
      _logger.error("Autoresume Engine Exception",e);
    }
  }

  public void propertyChange(PropertyChangeEvent e) {
    if (e.getPropertyName().equals("queryCompleted")) {
      if (this.currentQuery != null){
        QueryMessage eventQuerySource = (QueryMessage) e.getOldValue();
        if(eventQuerySource.getLocalQueryId() == currentQuery.getLocalQueryId()){
          ArrayList resultset = this.mergeQueryResults((ArrayList) e.getNewValue());
          for (int x = 0; x < resultset.size() && (msdm == null || msdm.getPeersNumber() < msdm.MaxSources); x++) {
            FileTupleGroup ftg = (FileTupleGroup) resultset.get(x);
            _logger.info("Autoresume query completed for file: "+ftg.getHash());
            Object[] tuples = ftg.tuples.toArray();
            Arrays.sort(tuples, new QueryFileTupleComparator());
            for (int y = 0; y < tuples.length && (msdm == null || msdm.getPeersNumber() < msdm.MaxSources); y++) {
              QueryFileTuple qft = (QueryFileTuple) tuples[x];
              EndpointSecurityManager esm = this.n.getOutputSecureConnectionManager(qft.getOwnerID());
              if(esm != null){
                this.pcs.firePropertyChange("addSourcePeer", this, qft);
              }else{
                this.n.createSecureConnection(qft.getOwnerID());
                if(this.secureConnectionRequired.size() > secureConnectionToTrace)
                  this.secureConnectionRequired.remove(0);
                this.secureConnectionRequired.add(qft);
              }
            }
          }
        }
      }
    }
    if(e.getPropertyName().equals("secureConnectionCreated")){
      for(int x = 0; x < this.secureConnectionRequired.size() && (msdm == null || msdm.getPeersNumber() < msdm.MaxSources); x++){
        QueryFileTuple qft = (QueryFileTuple) this.secureConnectionRequired.get(x);
        if(qft.getOwnerID().equals(((SecurityResponseMessage)e.getNewValue()).getSource())){
          _logger.info("Autoresume secure connection created file: "+qft.getFileHash());
          this.pcs.firePropertyChange("addSourcePeer", this, qft);
        }
      }
    }
  }

  public ArrayList mergeQueryResults(ArrayList resultSet){
    ArrayList tupleGroups = new ArrayList();
    for(int x=0; x < resultSet.size(); x++){
      if(resultSet.get(x) instanceof QueryCompletedFileTuple){
        if(tupleGroups.contains((QueryCompletedFileTuple)resultSet.get(x))){
          FileTupleGroup ftg = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryCompletedFileTuple)resultSet.get(x)));
          ftg.tuples.add(resultSet.get(x));
        }else{
          QueryCompletedFileTuple qft = (QueryCompletedFileTuple)resultSet.get(x);
          FileTupleGroup ftg = new FileTupleGroup(qft.getFileHash(),qft.getSize());
          ftg.tuples.add(qft);
          tupleGroups.add(ftg);
        }
      }else if(resultSet.get(x) instanceof QueryPartialFileTuple){
        if(tupleGroups.contains((QueryPartialFileTuple)resultSet.get(x))){
          FileTupleGroup ftg = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryPartialFileTuple)resultSet.get(x)));
          ftg.tuples.add(resultSet.get(x));
        }else{
          QueryPartialFileTuple qpft = (QueryPartialFileTuple)resultSet.get(x);
          FileTupleGroup ftg = new FileTupleGroup(qpft.getFileHash(),qpft.getSize());
          ftg.tuples.add(qpft);
          tupleGroups.add(ftg);
        }
      }
    }
    return tupleGroups;
  }

  /**
   * Link this instance to an interrupted download
   * @param interruptedDownload
   */
  public void setInterruptedDownload(InterruptedDownload interruptedDownload){
    synchronized(this){
      this.interruptedDownload = interruptedDownload;
      this.msdm = null;
    }
    this.interruptedDownload.addAutoresumeEngine(this);
  }

  /**
   * Link this instance to a multiple sources download
   * @param msdm
   */
  public void setMultipleSourcesDownloadManager(MultipleSourcesDownloadManager msdm){
    synchronized(this){
      this.msdm = msdm;
      this.interruptedDownload = null;
    }
    this.msdm.addAutoresumeEngine(this);
  }
}