import java.io.BufferedReader;
import java.rmi.RemoteException;

import JSR.*;
import JSR.Exceptions.JSRAccountNotValid;
import JSR.Exceptions.JSROperationNotAllowed;
import JSR.Exceptions.JSRServiceNotAvaliable;
import JSR.Exceptions.JSRServiceNotFound;

/**
 * Classe di Prova per il servizio CounterService.
 * @author Mattia Righini Mat 170738
 */
public class ProvaCounter {

	public static void main(String[] args) {
		try{
			if (System.getSecurityManager() == null)
			{ 
				System.setSecurityManager(new java.rmi.RMISecurityManager());
			}
			BufferedReader in=new BufferedReader(new java.io.InputStreamReader(System.in));
			System.out.println("Inserire Nome: ");
			String name=in.readLine();
			System.out.println("Inserire Indirizzo Broker: ");
			String brokerName=in.readLine();
			IServiceBroker broker=(IServiceBroker)java.rmi.Naming.lookup(brokerName);
			Account my=broker.logIn(name);
			Interface i=null;
			try{
				i=broker.getServiceInterface("CounterService",my);
			}catch(RemoteException e)
			{
				if(e.detail.getClass().equals(JSRServiceNotFound.class)){
					System.out.println("Counter Service non trovato");
				}else
					if(e.detail.getClass().equals(JSROperationNotAllowed.class))
						System.out.println("Operazione GetInterface non consentia");					
				broker.logOut(my);
				System.exit(1);
			}
			Method inc,get,reset;
			Method [] ms=i.getMethodsByName("get");
			get=ms[0];
			ms=i.getMethodsByName("inc");
			inc=ms[0];
			ms=i.getMethodsByName("reset");
			reset=ms[0];
			Object[] arg=new Object[0];
			char s;
			do{
				System.out.println("G get");
				System.out.println("I inc");
				System.out.println("R reset");
				System.out.println("L lock");
				System.out.println("U unlock");
				System.out.println("Q quit");
				s=in.readLine().toLowerCase().charAt(0);
				try{
					switch(s)
					{
						case 'g':
						{
							System.out.println("Valore :"+broker.sendRequest("CounterService",new Request(get,arg),my));
							break;
						}
						case 'i':
						{
							broker.sendRequest("CounterService",new Request(inc,arg),my);
							break;
						}
						case 'r':
						{
							broker.sendRequest("CounterService",new Request(reset,arg),my);
							break;
						}
						case 'l':
						{
							if(broker.lockService("CounterService",my))
								System.out.println("Servizio Lockato");
							break;
						}
						case 'u':
						{
							if(broker.unLockService("CounterService",my))
								System.out.println("Rimosso il Lock");
							break;
						}
						case 'q':
						{
							broker.logOut(my);
							break;
						}
					}
				}catch(RemoteException e)
				{
					if(e.detail.getClass().equals(JSRServiceNotAvaliable.class))
						System.out.println("Servizio attualmente non disponibile");
					else
						if(e.detail.getClass().equals(JSRAccountNotValid.class)){
							System.out.println("Account scaduto");
							break;
						}else
							e.printStackTrace(System.out);
				}
			}while(s!='q');
		}
		catch(Exception e){System.out.println(e);};
	}
}
