package JSR;
import java.io.Serializable;
import java.util.Vector;
/**
 * Classe Astratta che rappresenta lo stato di un servizio.
 * @author Mattia Righini Mat 170738
 */
public abstract class Status implements Serializable {
	/**
	 * Comment for <code>lock</code> Indica se il servizio  lockato o meno
	 */
	protected boolean lock;
	/**
	 * Comment for <code>lockAccount</code> Mantiene l'account che detiene il lock
	 */
	protected Account lockAccount;
	/**
	 * Comment for <code>statusC</code> Contatore aggiornato ogni volta che lo stato
	 *  viene modificato, serve per stabilire dati due stati quale sia pi aggiornato.
	 */
	protected int statusC;
	/**
	 * Comment for <code>managers</code> Vector che mantiene i manager ({@link IReplicationManager IReplicationManager})
	 * che gestiscono il servizio.
	 */
	protected Vector managers;
	/**
	 * Costruttore<br/>
	 * Lock impostato a false e StatusCounter impostato a 0
	 */
	public Status()
	{
		lock=false;
		lockAccount=null;
		statusC=0;
		managers=new Vector();
	}
	/**
	 * Verifica se il servizio  lockato o meno
	 * @return True se il servizio  lockato false altrimenti.
	 */
	public boolean isLock(){return lock;}
	/**
	 * Restituisce il valore del contatore che identifica il grado di aggiornamento
	 * dello stato.
	 * @return grado di aggiornamento dello stato.
	 */
	public int getStatusCounter(){return statusC;}
	/**
	 * Aggiorna il grado di aggiornamento dello stato.
	 */
	public void nextStatus(){statusC++;}
	/**
	 * Imposta il valore dell'attributo che indica se il servizio  lockato o meno
	 * @param lock valore da impostare.
	 */
	public void setLock(boolean lock){this.lock=lock;}
	/**
	 * Restituisce l'account che detiene il lock.
	 * @return Account che detiene il lock del servizio.
	 */
	public Account getLockAccount(){return lockAccount;}
	/**
	 * Imposta l'account che detiene il lock.
	 * @param account Account che detiene il lock
	 */
	public void setLockAccount(Account account){this.lockAccount=account;}
	/**
	 * Metodo per aggiungere un manager
	 * @param manager Manager da aggiungere.
	 */
	public void addReplicationManager(IReplicationManager manager)
	{
		if(!managers.contains(manager))managers.add(manager);
	}
	/**
	 * Restituisce il numero di manager legati al servizio il cui stato  rappresentato
	 * dall'oggeto corrente
	 * @return Numero di manager legati al servizio.
	 */
	public int getManagersCount(){return managers.size();}
	/**
	 * Restituisce il manager all'indice fornito.
	 * @param index Indice del manager desiderato.
	 * @return Il manager desiderato o null se l'indice  fuori dal range consentito.
	 */
	public IReplicationManager getManager(int index)
	{
		if((index<0) || (index>=managers.size()))return null;
		return (IReplicationManager)managers.get(index);
	}
	/**
	 * Rimuove il manager presente all'indice fornito.
	 * @param index Indice del manager da rimuovere.
	 */
	public void removeManager(int index)
	{
		if((index<0) || (index>=managers.size()))return;
		managers.remove(index);
	}
	/**
	 * Rimuove il manager passato in ingresso.
	 * @param manager Manager da rimuovere.
	 */
	public void removeManager(IReplicationManager manager)
	{
		managers.remove(manager);
	}
	/**
	 * Metodo per aggiornare l'insieme dei Managers.
	 * Vengono aggiunti tutti i manager presenti nello stato fornito in ingresso e non 
	 * presenti nello stato corrente.
	 * @param s Stato dal quale prendere i Manager.
	 */
	public void updateManagers(Status s)
	{
		if(s!=null)
			for(int i=0;i<s.getManagersCount();i++)
				this.addReplicationManager(s.getManager(i));
	}
	public String toString()
	{
	    String ret="Lock="+lock;
	    if(lock)ret+="\nLockAccount="+lockAccount;
	    ret+="\n#Managers ="+managers.size();
	    return ret;
	}
}
