package JSR.ServiceManagers;
import JSR.*;
import java.io.IOException;
import java.rmi.RemoteException;

import JSR.Exceptions.JSRServiceNotAvaliable;

/**
 * Service Manager senza gestione di Code e priorit
 * <br/>Le richieste effettuate vengono direttamente inoltrate al provider attivo senza tenere 
 * conto delle priorit degli Account richiedenti.
 * @author Mattia Righini Mat 170738
 */
public class QueueLessServiceManager extends AServiceManager {
	public Object SendRequest(Request r, Account a) throws RemoteException{
		if(activeProvider==null)Activate();
		while(activeProvider!=null)
		{
			try
			{
				return activeProvider.sendRequest(r,a);
			}catch(IOException e)
			{
				Activate();
			}
		}
		throw new JSRServiceNotAvaliable(getServiceName());
	}

	public boolean lock(Account a) throws RemoteException{
		if(activeProvider==null)Activate();
		while(activeProvider!=null)
		{
			try
			{				
				return activeProvider.lock(a);
			}catch(IOException e)
			{
				Activate();
			}
		}
		throw new JSRServiceNotAvaliable(getServiceName());		
	}

	public boolean unLock(Account a)throws RemoteException {
		if(activeProvider==null)Activate();
		while(activeProvider!=null)
		{
			try
			{
				return activeProvider.unLock(a);
			}
			catch(IOException e)
			{
				Activate();
			}
		}
		throw new JSRServiceNotAvaliable(getServiceName());
	}
	/**
	 * Costruttore.
	 * @param serviceName Nome del servizio.
	 * @param serviceInterface Interfaccia del Servizio.
	 * @param parentManager IReplicationManager a cui appartiene il manager.
	 */
	public QueueLessServiceManager(String serviceName,Interface serviceInterface,IReplicationManager parentManager)
	{
		super(serviceName,serviceInterface,parentManager);
	}
}
