package JSR;
import java.util.Vector;
import java.io.Serializable;
/**
 * Rappresenta e incapsula una lista di servizi.<br/>
 * Ogni elemento della lista  un oggetto di classe {@link ServiceListElement ServiceListElement}.
 * @author Mattia Righini  Mat 170738
 */
public class ServiceList implements Serializable {
	/**
	 * Comment for <code>services</code> Vettore che mantiene i vari elementi.
	 */
	protected Vector services;
	/**
	 * Costruttore di Default.
	 */
	public ServiceList()
	{
		services=new Vector();
	}
	/**
	 * Costruttore per copia
	 * @param sl Lista da Copiare
	 */
	public ServiceList(ServiceList sl)
	{
		this();
		for(int i=0;i<sl.services.size();i++)
			services.add(sl.services.get(i));
	}
	/**
	 * Metodo per aggiungere un nuovo elemento alla lista, non vengono effettuati 
	 * controlli sulla presenza o meno di servizi con lo stesso nome di quello che 
	 * si vuole aggiungere.
	 * @param serviceName Nome del servizio da aggiungere.
	 * @param serviceInterface Interfaccia del servizio.
	 * @return True se l'inserimento  avvenuto false altrimenti.
	 */
	public boolean addService(String serviceName,Interface serviceInterface)
	{
		if(getService(serviceName)!=null)return false;
		return services.add(new ServiceListElement(serviceName,serviceInterface));
	}
	/**
	 * Metodo per ottenere un elemento della lista relativo al Servizio il cui nome 
	 * fornito in ingresso.
	 * @param serviceName Nome del servizio di cui si vuole ottenere
	 * @return Elemento della lista desiderato o null se non vengono trovati elementi
	 * corrispondenti al nome fornito.
	 */
	public ServiceListElement getService(String serviceName)
	{
		for(int i=0;i<services.size();i++)
		{
			ServiceListElement current=(ServiceListElement)services.get(i);
			if(current.getServiceName().equals(serviceName))return current;
		}
		return null;
	}
	/**
	 * Metodo per ottenere l'elemento dalla lista all'indice fornito in ingresso.
	 * @param index Indice dell'elemento che si vuole ottenere.
	 * @return Elemento desiderato o null se l'indice  fuori dal range consentito.
	 */
	public ServiceListElement getService(int index)
	{
		if((index<0)||(index>=services.size()))return null;
		return (ServiceListElement)services.get(index);
	}
	/**
	 * Metodo per ottenere il numero di servizi presenti nella lista.
	 * @return Numero di servizi presenti in lista.
	 */
	public int getServiceCount(){return services.size();}
	
}
