package JSR;

import java.io.Serializable;

/**
 * <p>Classe che rappresenta una richiesta per un servizio.
 * @author Mattia Righini Mat 170738
 */
public class Request implements Serializable {
	protected Method method;
	protected Object[] args;
	/**
	 * Costruttore
	 * @param method Metodo che si intende invocare
	 * @param args argomenti da passare.
	 */
	public Request(Method method,Object[] args)
	{
		this.method=method;
		this.args=args;
	}
	/**
	 * @return Metodo da invocare.
	 */
	public Method getMethod(){return method;}
	/**
	 * @return Argomenti da passare.
	 */
	public Object[] getArgs(){return args;}
	public String toString()
	{
	    String ret=method.getName()+"(";
	    for(int i=0;i<(args.length-1);i++)
	        ret=ret+args[i].toString()+",";
	    if(args.length>0)ret=ret+args[args.length-1].toString()+")";
	    else ret=ret+")";
	    return ret;
	}
}
