package JSR;
import java.io.Serializable;
/**
 * Classe che incapsula la risposta di un {@link IReplicationManager IReplicationManager}
 * a fronte di una registrazione di {@link IReplicableService IReplicableService}. Vedere
 * il metodo {@link JSR.IReplicationManager#registerService(String, IReplicableService) IReplicationManager.registerService}
 * @author Mattia Righini Mat 170738
 */
public class RegisterResponse implements Serializable {
	/**
	 * Id Proposto dal Manager.
	 */
	public int id;
	/**
	 * Indicazione se il provider deve essere attivato a registrazione ultimata.
	 */
	public boolean activate;
	/**
	 * Stato corrente presente sul Manager per il servizio.
	 */
	public Status status;
	/**
	 * Costruttore
	 * @param id Id Proposto dal Manager
	 * @param activate Indicazione se il provider deve essere attivato
	 * @param s Stato corrente presente sul Manager
	 */
	public RegisterResponse(int id,boolean activate,Status s)
	{
		this.id=id;
		this.activate=activate;
		this.status=s;
	}
	public String toString()
	{
		return "Id="+id+" Activate="+activate+" Status="+status;
	}
}
