package JSR;
import java.io.Serializable;

/**
 * <p>Classe che rappresenta un metodo invocabile su un servizio.
 * @author Mattia Righini Mat 170738
 */
public class Method implements Serializable {
	protected String name;
	protected Class retType;
	protected Class[] args;
	public Method(String name,Class retType,Class[] args)throws Exception
	{
		if(name==null)throw new Exception("name = null");
		this.name=name;
		if(retType==null)throw new Exception("retType = null");
		this.retType=retType;
		if(args==null)throw new Exception("args = null");
		this.args=args;
	}
	/**
	 * @return Nome del Metodo.
	 */
	public String getName(){return name;}
	/**
	 * @return Tipo di ritorno.
	 */
	public Class getReturnType(){return retType;}
	/**
	 * @return Tipi degli argomenti
	 */
	public Class[] getArgsType(){return args;}
	public boolean equals(Method m)
	{
		if(!name.equals(m.getName()))return false;
		if(!retType.equals(m.getReturnType()))return false;
		if(!(args.length==(m.getArgsType().length)))return false;
		for(int i=0;i<args.length;i++)
			if(!args[i].equals(m.getArgsType()[i]))return false;
		return true;
	}
}
