package JSR;
import java.util.Vector;
import java.io.Serializable;

/**
 * Classe che rappresenta l'interfaccia di un servizio, consente di aggiungere e ottenere
 * i metodi messi a disposizione da un servizio.
 * @author Mattia Righini Mat 170738
 */
public class Interface implements Serializable {
	/**
	 * Comment for <code>methods</code> Vector che mantiene oggetti di classe Method 
	 */
	protected Vector methods;
	/**
	 * Costruttore di default
	 */
	public Interface()
	{
		methods=new Vector();
	}
	/**
	 * Consente di aggiungere un nuovo metodo all'interfaccia.
	 * @param m Metodo da aggiungere
	 * @return true se l'inserimento ha avuto successo false altrimenti (l'inserimento 
	 * fallisce se il metodo  gi presente).
	 */
	public boolean addMethod(Method m)
	{
		if(methods.contains(m))return false;
		return methods.add(m);
	}
	/**
	 * Consente di ottenere tutti i metodi presenti nell'interfaccia con un determinato 
	 * nome.
	 * @param name Nome del metodo che si vuole ottenere
	 * @return Array di {@link Method Method} il cui nome corrisponde a quello fornito in ingresso.
	 */
	public Method[] getMethodsByName(String name)
	{
		Vector temp=new Vector();
		for(int i=0;i<methods.size();i++)
		{
			Method m=(Method)methods.get(i);
			if(m.getName().equals(name))temp.add(m);
		}
		if(temp.size()==0)return null;
		Method ret[]=new Method[temp.size()];
		for(int i=0;i<ret.length;i++)
			ret[i]=(Method)temp.get(i);
		return ret;
	}
	/**
	 * Consente di ottenere il metodo dell'interfaccia ad uno specifico indice.  
	 * @param index Indice del metodo desiderato
	 * @return null se l'indice  fuori dal range consentito.
	 */
	public Method getMethod(int index)
	{
		if((index<0) || (index>=methods.size()))return null;
		return (Method)methods.get(index);
	}
	/**
	 * Metodo per ottenere il numero di metodi presenti nell'interfaccia
	 * @return Numero id metodi presenti nell'interfaccia.
	 */
	public int getMethodCount(){return methods.size();}
	/**
	 * Verifica che l'interfaccia passata in ingresso sia uguale a quella corrente.
	 * @param i interfaccia da verificare
	 * @return true se le due interfacce coincidono, false altrimenti
	 */
	public boolean equals(Interface i)
	{
	    if(getMethodCount()!=i.getMethodCount())return false;
	    for(int j=0;j<getMethodCount();j++)
	    {
	        Method current=getMethod(j);
	        Method[] imet=i.getMethodsByName(current.getName());
	        if(imet==null)return false;
	        if(imet.length==0)return false;
	        boolean found=false;
	        for(int k=0;k<imet.length;k++)
	        {
	            if((current.getReturnType().getClass().equals(imet[k].getReturnType().getClass()))
	                    &&(current.getArgsType().length==imet[k].getArgsType().length))
	            {
	                found=true;
	                for(int z=0;z<imet[k].getArgsType().length;z++)
	                {
	                    if(!current.getArgsType()[z].getClass().equals(imet[k].getArgsType()[z].getClass()))
	                    {
	                        found=false;
	                        break;
	                    }
	                }
	                if(found)break;
	            }
	        }
	        if(!found)return false;
	    }
	    return true;
	}
	public String toString()
	{
	    String ret="Interface:";
	    for(int i=0;i<methods.size();i++)
	        ret+="\n\t"+((Method)methods.get(i)).getName();
	    return ret;
	}
}
