package JSR;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * <p>Interfaccia per l'acccesso ai servizi da parte dei clienti.
 * @author Mattia Righini Mat 170738
 */
public interface IServiceBroker extends Remote {
	/**
	 * Metodo per ottenere un l'interfaccia di un servizio.
	 * @param serviceName Nome del servizio di cui si vuole ottenere l'interfaccia.
	 * @param account Account richiedente
	 * @return Interfaccia del servizio richiesto
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRGenericException JSRGenericException} Nel caso in cui non venga settato il nome del servizio.
	 * <p> {@link JSR.Exceptions.JSRServiceNotFound JSRServiceNotFound} Nel caso in cui non venga trovato il servizio. 
	 * <p> {@link JSR.Exceptions.JSRAccountNotValid JSRAccountNotValid} Nel caso in cui l'account fornito non risulti valido.
	 * <p> {@link JSR.Exceptions.JSROperationNotAllowed JSROperationNotAllowed} Nel caso l'utente non possa effettuare l'operazione.
	 */
	Interface getServiceInterface(String serviceName,Account account)throws RemoteException;
	/**
	 * Metodo per ottenere la lista dei servizi attivi sul broker.
	 * @param account Account richiedente
	 * @return Lista dei servizi presenti sul broker.
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRAccountNotValid JSRAccountNotValid} Nel caso in cui l'account fornito non risulti valido.
	 * <p> {@link JSR.Exceptions.JSROperationNotAllowed JSROperationNotAllowed} Nel caso l'utente non possa effettuare l'operazione.
	 */
	ServiceList getServiceList(Account account)throws RemoteException;
	/**
	 * Metodo per lockare un servizio.
	 * @param serviceName Nome del servizio da lockare
	 * @param account Account richiedente
	 * @return true se il lock  stato ottenuto
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRGenericException JSRGenericException} Nel caso in cui non venga settato il nome del servizio.
	 * <p> {@link JSR.Exceptions.JSRServiceNotFound JSRServiceNotFound} Nel caso in cui non venga trovato il servizio. 
	 * <p> {@link JSR.Exceptions.JSRAccountNotValid JSRAccountNotValid} Nel caso in cui l'account fornito non risulti valido.
	 * <p> {@link JSR.Exceptions.JSROperationNotAllowed JSROperationNotAllowed} Nel caso l'utente non possa effettuare l'operazione.
	 * <p> {@link JSR.Exceptions.JSRServiceNotAvaliable JSRServiceNotAvaliable} Nel caso in cui al momento il servizio non sia dispobibile. 
	 */
	boolean lockService(String serviceName,Account account)throws RemoteException;
	/**
	 * Metodo per effettuare il LogIn e ottenere un Account valido.
	 * @param accountId Id per riconoscere l'utente
	 * @return Account valido.
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRGenericException JSRGenericException} Nel caso in cui il login non sia possibile. 
	 */
	Account logIn(String accountId)throws RemoteException;
	/**
	 * Metodo per effettuare il LogOut dal sistema.
	 * @param account Account che vuole uscire dal sistema
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRAccountNotValid JSRAccountNotValid} Nel caso in cui l'account fornito non risulti valido. 
	 */
	void logOut(Account account)throws RemoteException;
	/**
	 * Metodo per inviare una richiesta ad un servizio.
	 * @param serviceName Nome del servizio al quale va diretta la richiesta
	 * @param request Oggetto che rappresenta l'operazione richiesta
	 * @param account Account richiedente.
	 * @return La risposta fornita dal servizio.
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRGenericException JSRGenericException} Nel caso in cui non venga settato il nome del servizio.
	 * <p> {@link JSR.Exceptions.JSRServiceNotFound JSRServiceNotFound} Nel caso in cui non venga trovato il servizio. 
	 * <p> {@link JSR.Exceptions.JSRAccountNotValid JSRAccountNotValid} Nel caso in cui l'account fornito non risulti valido.
	 * <p> {@link JSR.Exceptions.JSROperationNotAllowed JSROperationNotAllowed} Nel caso l'utente non possa effettuare l'operazione.
	 * <p> {@link JSR.Exceptions.JSRServiceNotAvaliable JSRServiceNotAvaliable} Nel caso in cui al momento il servizio non sia dispobibile.
	 */
	Object sendRequest(String serviceName,Request request,Account account)throws RemoteException;
	/**
	 * Metodo per rimuovere il lock dal servizio.
	 * @param serviceName Nome del servizio da cui si vuole rimuovere il lock.
	 * @param account Account che detiene il lock
	 * @return true se il lock  stato rimosso
	 * @throws RemoteException <p>Precisamente pu lanciare le seguenti eccezioni:
	 * <p> {@link JSR.Exceptions.JSRGenericException JSRGenericException} Nel caso in cui non venga settato il nome del servizio.
	 * <p> {@link JSR.Exceptions.JSRServiceNotFound JSRServiceNotFound} Nel caso in cui non venga trovato il servizio. 
	 * <p> {@link JSR.Exceptions.JSRAccountNotValid JSRAccountNotValid} Nel caso in cui l'account fornito non risulti valido.
	 * <p> {@link JSR.Exceptions.JSROperationNotAllowed JSROperationNotAllowed} Nel caso l'utente non possa effettuare l'operazione.
	 * <p> {@link JSR.Exceptions.JSRServiceNotAvaliable JSRServiceNotAvaliable} Nel caso in cui al momento il servizio non sia dispobibile.
	 */
	boolean unLockService(String serviceName,Account account)throws RemoteException;
}
