package JSR;
import java.io.BufferedReader;
import java.rmi.*;

import JSR.Exceptions.JSRGenericException;

/**
 * Classe che realizza il servizio base di generazione Id Globali
 * @author Mattia Righini Mat 170738
 */
public class GlobalIdGenerator extends AReplicableService {
	/**
	 * Costruttore, a seconda del valore di root il servizio sar attivo e con id settato
	 * o inattivo in attesa di essere regisrato presso managers.
	 * @param root True se il servizio deve essere attivo e deve attendere registrazioni
	 * da parte dei managers (in questo caso l'id  fissato a 0), False se esiste gi un
	 * GlobalIdGenerator e il servizio si registrer presso i Manager come normale provider
	 * inattivo (in questo caso l'id  generato dinamicamente dai manager).
	 * @throws RemoteException
	 */
	public GlobalIdGenerator(boolean root)throws RemoteException
	{
		super();
		if(root)id=0;
		else id=-1;
		active=root;
	}
	//INIZIO SERVIZI
	/**
	 * Metodo per la generazione del prossimo Id.
	 * @return Id libero assegnabile ad un provider.
	 * @throws RemoteException 
	 */
	synchronized public int getNextId() throws RemoteException {
		return ((GlobalIdGeneratorStatus)serviceStatus).getNextId();
	}
	//FINE SERVIZI
	
	/**
	 *Funzione non supportata, si  ritenuto di nessuna utilit la possibilit 
	 *di lockare il servizio di Generazione degli ID.
	 *@throws RemoteException Precisamente {@link JSRGenericException JSRGenericException}. 
	 */
	public boolean lock(Account lockAccount) throws RemoteException {
		throw new JSRGenericException("Service cannot be locked");
	}
	/**
	 *Funzione non supportata, si  ritenuto di nessuna utilit la possibilit 
	 *di lockare il servizio di Generazione degli ID.
	 *@throws RemoteException Precisamente {@link JSRGenericException JSRGenericException}. 
	 */
	public boolean unLock(Account lockAccount) throws RemoteException {
		throw new JSRGenericException("Service cannot be unlocked");
	}
	/*Metodi Astratti di AReplicableService*/
	public String getServiceName() {
		return "GlobalIdGenerator";
	}
	protected Interface buildInterface() {
	    Interface ret=new Interface();
		java.lang.reflect.Method[] methods=this.getClass().getMethods();
		for(int i=0;i<methods.length;i++)
		{
			try{
				String methodName=methods[i].getName();
				if(methodName.equals("getNextId"))
					ret.addMethod(new Method(methodName,methods[i].getReturnType(),methods[i].getParameterTypes()));
			}catch(Exception e)
			{
				System.err.println(e.getMessage());
				System.exit(1);
			}
		}
		return ret;
	}
	protected Status buildInitialStatus() {
		return new GlobalIdGeneratorStatus();
	}
	protected boolean needToRefreshStatusAfter(String methodName) {
		return methodName.equals("getNextId");
	}
	/*Metodi Astratti di AReplicableService Fine*/
	
	public static void main(String[] args){
		if((args.length==0)||
				((!args[0].toLowerCase().equals("true"))&&(!args[0].toLowerCase().equals("false")))||
				((!args[1].toLowerCase().equals("true"))&&(!args[1].toLowerCase().equals("false")))||
				(args.length<3))
		{
			System.out.println("Uso:\nGlobalIdGenerator <debug> <root> <Indirizzi>\n" +
					"Se root=true Indirizzi=1 solo indirizzo che corrisponde al nome da registrare\n" +
					"Se root=false Indirizzi=lista di indirizzi separati da spazio che corrispondono agli indirizzi dei Manager presso cui il servizio si deve registrare ");
			System.exit(1);
		}
		boolean root=args[1].toLowerCase().equals("true");
		Configuration.DEBUG=args[0].toLowerCase().equals("true");
		if(Configuration.DEBUG)
			Configuration.addDebugListener(new JSR.Events.ConsoleDebug());
		if (System.getSecurityManager() == null)
		{ 
			System.setSecurityManager(new java.rmi.RMISecurityManager());
		}
		GlobalIdGenerator server=null;
		/*Se Root=true allora il GlobalIdGenerator va registrato presso il servizio di
		 * nomi di RMI con il nome indicato da linea di comando*/
		if(root)
		{
			try{
//			 Registrazione del servizio RMI
			    server =new GlobalIdGenerator(true);
				Naming.bind(args[2], server);
				System.out.println("Root GlobalIdGenerator Online, Nome="+args[2]);
			}
			catch (Exception e){
				System.err.println("Server RMI \"" +args[2] + "\": " + e.getMessage());
				e.printStackTrace();
				System.exit(1);
			}			
		}
		else
		{
			/*Se Root=false allora il servizio rappresenta un provider "aggiuntivo" per
			 * i broker specificati sulla linea di comando presso i quali verr registrato*/
			try{
				server =new GlobalIdGenerator(false);
				for(int i=2;i<args.length;i++)
				{
					try{
						IReplicationManager manager=(IReplicationManager)Naming.lookup(args[i]);
						server.addReplicationManager(manager);			
					}catch(Exception e)
					{
						System.err.println(e);
					}
				}
				if(server.registerService())
				{
				    System.out.println("Servizio Registrato");
				}
			}catch(RemoteException e)
			{
				System.err.println(e);
			}			
		}
        BufferedReader in=new BufferedReader(new java.io.InputStreamReader(System.in));
        char c='\0';
        boolean exit=true;
        do
        {
        	System.out.println("Premere Q per uscire");
        	try{c=in.readLine().toLowerCase().charAt(0);}
        	catch(Exception e)
        	{
         	    System.out.println("Errore sullo stdin, impossibile acquisire caratteri il servizio rimarr aperto");        	    
        	    exit=false;
        	    break;
        	}
        }while(c!='q');
        if(exit){
            server.unRegisterService();
            if(root)
                try{Naming.unbind(args[2]);}
            	catch(Exception e){}
            System.exit(0);
        }		
	}	
}
/**
 * Classe che rappresenta lo stato per il servizio di generazione Id.
 * @author Mattia Righini Mat 170738
 */
class GlobalIdGeneratorStatus extends Status
{
	/**
	 * Comment for <code>nextId</code> Prossimo Id da restituire.
	 */
	protected int nextId;
	/**
	 * NextId impostato a 1
	 */
	public GlobalIdGeneratorStatus()
	{
		super();
		nextId=1; /*ID=0 riservato per il GlobalIdGenerator Root*/
	}
	/**
	 * Metodo per ottenere il prossimo Id, il metodo aggiorna il valore di NextId.
	 * @return Id libero.
	 */
	public int getNextId()
	{
		return nextId++;
	}
	public String toString()
	{
	    String ret=super.toString();
	    ret+="\nNextId="+nextId;
	    return ret;
	}	
}