package JSR.Exceptions;
import JSR.IReplicableService;
/**
 * Eccezione lanciata in caso si tenti di effettuare operazioni di Lock,UnLock e SendRequest
 * su un provider inattivo. 
 * @author Mattia Righini Mat 170738
 */
public class JSRProviderNotActive extends JSRGenericException {
	/**
	 * Provider Inattivo che ha generato l'eccezione.
	 */
	public IReplicableService provider;
	/**
	 * Costruttore. 
	 * @param provider Provider Inattivo che ha generato l'eccezione.
	 */
	public JSRProviderNotActive(IReplicableService provider)
	{
		super("Provider not Active");
		this.provider=provider;
	}

}
