package JSR.Exceptions;
/**
 * Eccezione causata dal tentativo da parte di un Account di effetuare un operazione
 * non consentita dai propri diritti.
 * @author Mattia Righini Mat 170738
 */
public class JSROperationNotAllowed extends JSRGenericException{
	/**
	 * Operazione che ha causato l'errore
	 * <br/>Vedere {@link JSR.Constants.Permission Permission} per i valori possibili.
	 */
	public int operation;
	/**
	 * Costruttore.
	 * @param operation Operazione che ha causato l'errore
	 */
	public JSROperationNotAllowed(int operation)
	{
		super("Operation Not Allowed");
		this.operation=operation;
	}
}
